/*
#   rms_calc.c: generate a running rms count of the signal level over a specified time window
#   Copyright (C) 2006 Stephen Fairchild (s-fairchild@users.sourceforge.net)
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program in the file entitled COPYING.
#   If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include <stdlib.h>
#include <jack/jack.h>
#include <math.h>
#include "rms_calc.h"

struct rms_calc *rms_calc_create(int sr, float length)
   {
   struct rms_calc *self;
   int n_samples;

   if (!(self = malloc(sizeof (struct rms_calc))))
      {
      fprintf(stderr, "malloc failure\n");
      exit(5);
      }
   if (!(self->buffer = self->ptr = calloc((n_samples = length * sr), sizeof (rmsaudio_t))))
      {
      fprintf(stderr, "malloc failure\n");
      exit(5);
      }
   self->end = self->buffer + n_samples;
   self->sum = 0.0F;
   self->newsum = 0.0F;
   self->multiplier = 1.0F / (rmsaudio_t)n_samples;
   return self;
   }
   
void rms_calc_destroy(struct rms_calc *self)
   {
   free(self->buffer);
   free(self);
   }

rmsaudio_t rms_calc(struct rms_calc *self, rmsaudio_t input)
   {
   input *= input;
   self->sum -= *(self->ptr);
   self->sum += input;
   self->newsum += input;
   *(self->ptr)++ = input;
   if (self->ptr == self->end)
      {
      self->ptr = self->buffer;
      self->sum = self->newsum;
      self->newsum = 0.0F;
      }
   return sqrtf(self->sum * self->multiplier);
   }

