from hotwire.builtin import Builtin, BuiltinRegistry, OutputStreamSchema

class CurrentBuiltin(Builtin):
    """Returns objects generated by currently visible command."""
    def __init__(self):
        super(CurrentBuiltin, self).__init__('current', aliases=['cur'],
                                             output=OutputStreamSchema('any', 
                                                                       typefunc=lambda hotwire: hotwire.get_current_output_type()))

    def execute(self, context):
        current = context.current_output
        if not current:
            return
        for obj in current:
            yield obj
    
BuiltinRegistry.getInstance().register(CurrentBuiltin())
