# 
#  ***** BEGIN LICENSE BLOCK *****  
#   
#  Source last modified: $Id: test_utils.py,v 1.2 2007/07/17 00:17:49 jfinnecy Exp $ 
#   
#  Copyright Notices: 
#   
#  Portions Copyright (c) 1995-2006 RealNetworks, Inc. All Rights Reserved. 
#   
#  Patent Notices: This file may contain technology protected by one or  
#  more of the patents listed at www.helixcommunity.org 
#   
#  1.   The contents of this file, and the files included with this file, 
#  are protected by copyright controlled by RealNetworks and its  
#  licensors, and made available by RealNetworks subject to the current  
#  version of the RealNetworks Public Source License (the "RPSL")  
#  available at  * http://www.helixcommunity.org/content/rpsl unless  
#  you have licensed the file under the current version of the  
#  RealNetworks Community Source License (the "RCSL") available at 
#  http://www.helixcommunity.org/content/rcsl, in which case the RCSL 
#  will apply.  You may also obtain the license terms directly from 
#  RealNetworks.  You may not use this file except in compliance with 
#  the RPSL or, if you have a valid RCSL with RealNetworks applicable 
#  to this file, the RCSL.  Please see the applicable RPSL or RCSL for 
#  the rights, obligations and limitations governing use of the 
#  contents of the file. 
#   
#  2.  Alternatively, the contents of this file may be used under the 
#  terms of the GNU General Public License Version 2 (the 
#  "GPL") in which case the provisions of the GPL are applicable 
#  instead of those above.  Please note that RealNetworks and its  
#  licensors disclaim any implied patent license under the GPL.   
#  If you wish to allow use of your version of this file only under  
#  the terms of the GPL, and not to allow others 
#  to use your version of this file under the terms of either the RPSL 
#  or RCSL, indicate your decision by deleting Paragraph 1 above 
#  and replace them with the notice and other provisions required by 
#  the GPL. If you do not delete Paragraph 1 above, a recipient may 
#  use your version of this file under the terms of any one of the 
#  RPSL, the RCSL or the GPL. 
#   
#  This file is part of the Helix DNA Technology.  RealNetworks is the 
#  developer of the Original Code and owns the copyrights in the 
#  portions it created.   Copying, including reproducing, storing,  
#  adapting or translating, any or all of this material other than  
#  pursuant to the license terms referred to above requires the prior  
#  written consent of RealNetworks and its licensors 
#   
#  This file, and the files included with this file, is distributed 
#  and made available by RealNetworks on an 'AS IS' basis, WITHOUT  
#  WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS  
#  AND ITS LICENSORS HEREBY DISCLAIM  ALL SUCH WARRANTIES, INCLUDING  
#  WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS  
#  FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
#   
#  Technology Compatibility Kit Test Suite(s) Location:  
#     http://www.helixcommunity.org/content/tck 
#   
# Contributor(s):
# 
# ***** END LICENSE BLOCK *****
# 
"""Unit tests for utils class."""
import os
import glob

import unittest
from test import assertEquals, testRoot, testDataPath

# Setup test data references.

# Setup module to test.
import utils

#
# Test Cases
#
#
class globNoMetaPath( unittest.TestCase ):
    """Test the globNoMetaPath replacement for glob.glob
    """
    def setUp( self ):
        self.metaPath    = os.path.join( testDataPath , "utils" , "meta[dir]one" )
        self.nonMetaPath = os.path.join( testDataPath , "utils" , "nometa" )       
        
        self.multi    = "*.bif"
        self.single   = "*.txt"
        self.specific = "three.txt"
        
        self.multiMeta    = os.path.join( self.metaPath , self.multi )
        self.singleMeta   = os.path.join( self.metaPath , self.single )
        self.specificMeta = os.path.join( self.metaPath , self.specific )        
        
        self.multiNonMeta    = os.path.join( self.nonMetaPath , self.multi )
        self.singleNonMeta   = os.path.join( self.nonMetaPath , self.single )
        self.specificNonMeta = os.path.join( self.nonMetaPath , self.specific )
        
        
    def testMultiMeta( self ):
        assertEquals( 'File count' , 
                      len(utils.globNoMetaPath( self.multiMeta )),
                      2 )
                      
    def testSingleMeta( self ):
        assertEquals( 'File count' ,
                      len( utils.globNoMetaPath( self.singleMeta )),
                      1 )
              
    def testSpecificMeta( self ):
        assertEquals( 'File count' ,
                      len( utils.globNoMetaPath( self.specificMeta )),
                      1 )
                      
    def testMultiNonMeta( self ):
        assertEquals( 'File count' ,
                      len( utils.globNoMetaPath( self.multiNonMeta )),
                      2 )
          
    def testSingleNonMeta( self ):
        assertEquals( 'File count' ,
                      len( utils.globNoMetaPath( self.singleNonMeta )),
                      1 )
                      
    def testSpecificNonMeta( self ):
        assertEquals( 'File count' ,
                      len( utils.globNoMetaPath( self.specificNonMeta )),
                      1 )
                      
    def testGlobEquivalence( self ):
        assertEquals( 'Glob results' ,
                      utils.globNoMetaPath( self.multiNonMeta )[1],
                      glob.glob( self.multiNonMeta )[1] )
                      
    def testNonExistantDir( self ):
        assertEquals( 'Glob results' ,
                      len(utils.globNoMetaPath( os.path.join( self.metaPath , "totally" , "made" , "up" ))),
                      0 )
                           
                      
def getSuites():
    suite0 = unittest.makeSuite( globNoMetaPath  , 'test' )
    suites = unittest.TestSuite( ( suite0 ,
                              ) )
     
    return suites
