module Hat.Data.Bits
  (Bits((!.&.),(!.|.),gxor,gcomplement,gshift,grotate,gbit,gsetBit,gclearBit
      ,gcomplementBit,gtestBit,gbitSize,gisSigned,gshiftL,gshiftR,grotateL
      ,grotateR,(|.&.),(|.|.),sxor,scomplement,sshift,srotate,sbit,ssetBit
      ,sclearBit,scomplementBit,stestBit,sbitSize,sisSigned,sshiftL,sshiftR
      ,srotateL,srotateR)) where

import qualified Hat.PreludeBasic 
import qualified Prelude 
import Hat.Hack 
import qualified Hat.Hat as T 
import Hat.Hat  (WrapVal(wrapVal))
import Hat.Prelude 
import qualified Data.Bits 

class Num a => Bits a
  where
  
  (!.&.) :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a a))
  
  (!.|.) :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a a))
  
  gxor :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a a))
  
  gcomplement :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a a)
  
  gshift :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun Int a))
  
  gshift pshift p =
    T.ufun2 a33v8v33v12shift pshift p hshift
    where
    
    hshift fx fi p =
      T.ucguard
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !< p) fi
          (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
            (T.conInteger T.mkNoSrcPos p 0)))
        (T.uap2 T.mkNoSrcPos p (gshiftR T.mkNoSrcPos p) fx
          (T.uap1 T.mkNoSrcPos p (gnegate T.mkNoSrcPos p) fi))
        (T.ucguard
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fi
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 0))) (T.projection T.mkNoSrcPos p fx)
          (T.ucguard
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !> p) fi
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 0)))
            (T.uap2 T.mkNoSrcPos p (gshiftL T.mkNoSrcPos p) fx fi) (T.fatal p)))
    
  
  grotate :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun Int a))
  
  gbit :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int a)
  
  gsetBit :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun Int a))
  
  gclearBit :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun Int a))
  
  gcomplementBit :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun Int a))
  
  gtestBit :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun Int Bool))
  
  gbitSize :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a Int)
  
  gisSigned :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a Bool)
  
  gbit pbit p =
    T.ufun1 a47v5v47v38bit pbit p hbit
    where
    
    hbit fi p =
      T.uap2 T.mkNoSrcPos p (gshiftL T.mkNoSrcPos p)
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 1)) fi
    
  
  gsetBit psetBit p =
    T.ufun2 a48v8v48v13setBit psetBit p hsetBit
    where
    
    hsetBit fx fi p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !.|. p) fx
        (T.uap1 T.mkNoSrcPos p (gbit T.mkNoSrcPos p) fi)
    
  
  gclearBit pclearBit p =
    T.ufun2 a49v8v49v15clearBit pclearBit p hclearBit
    where
    
    hclearBit fx fi p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !.&. p) fx
        (T.uap1 T.mkNoSrcPos p (gcomplement T.mkNoSrcPos p)
          (T.uap1 T.mkNoSrcPos p (gbit T.mkNoSrcPos p) fi))
    
  
  gcomplementBit pcomplementBit p =
    T.ufun2 a50v8v50v20complementBit pcomplementBit p hcomplementBit
    where
    
    hcomplementBit fx fi p =
      T.uap2 T.mkNoSrcPos p (gxor T.mkNoSrcPos p) fx
        (T.uap1 T.mkNoSrcPos p (gbit T.mkNoSrcPos p) fi)
    
  
  gtestBit ptestBit p =
    T.ufun2 a51v8v51v14testBit ptestBit p htestBit
    where
    
    htestBit fx fi p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/= p)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !.&. p) fx
          (T.uap1 T.mkNoSrcPos p (gbit T.mkNoSrcPos p) fi))
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 0))
    
  
  gshiftL,gshiftR :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun Int a))
  
  grotateL,grotateR :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun Int a))
  
  gshiftL pshiftL p =
    T.ufun2 a55v8v55v13shiftL pshiftL p hshiftL
    where
    
    hshiftL fx fi p = T.uap2 T.mkNoSrcPos p (gshift T.mkNoSrcPos p) fx fi
    
  
  gshiftR pshiftR p =
    T.ufun2 a56v8v56v13shiftR pshiftR p hshiftR
    where
    
    hshiftR fx fi p =
      T.uap2 T.mkNoSrcPos p (gshift T.mkNoSrcPos p) fx
        (T.uap1 T.mkNoSrcPos p (gnegate T.mkNoSrcPos p) fi)
    
  
  grotateL protateL p =
    T.ufun2 a57v8v57v14rotateL protateL p hrotateL
    where
    
    hrotateL fx fi p = T.uap2 T.mkNoSrcPos p (grotate T.mkNoSrcPos p) fx fi
    
  
  grotateR protateR p =
    T.ufun2 a58v8v58v14rotateR protateR p hrotateR
    where
    
    hrotateR fx fi p =
      T.uap2 T.mkNoSrcPos p (grotate T.mkNoSrcPos p) fx
        (T.uap1 T.mkNoSrcPos p (gnegate T.mkNoSrcPos p) fi)
    
  
  (|.&.) :: T.R (T.Fun a (T.Fun a a))
  
  (|.|.) :: T.R (T.Fun a (T.Fun a a))
  
  sxor :: T.R (T.Fun a (T.Fun a a))
  
  scomplement :: T.R (T.Fun a a)
  
  sshift :: T.R (T.Fun a (T.Fun Int a))
  
  srotate :: T.R (T.Fun a (T.Fun Int a))
  
  sbit :: T.R (T.Fun Int a)
  
  ssetBit :: T.R (T.Fun a (T.Fun Int a))
  
  sclearBit :: T.R (T.Fun a (T.Fun Int a))
  
  scomplementBit :: T.R (T.Fun a (T.Fun Int a))
  
  stestBit :: T.R (T.Fun a (T.Fun Int Bool))
  
  sbitSize :: T.R (T.Fun a Int)
  
  sisSigned :: T.R (T.Fun a Bool)
  
  sshiftL,sshiftR :: T.R (T.Fun a (T.Fun Int a))
  
  srotateL,srotateR :: T.R (T.Fun a (T.Fun Int a))
  

g_andInt :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int (T.Fun Int Int))

g_andInt p_andInt p = T.ufun2 a_andInt p_andInt p h_andInt

h_andInt z1_andInt z2_andInt k_andInt =
  T.fromInt k_andInt
    ((T.toInt k_andInt z1_andInt) Data.Bits..&. (T.toInt k_andInt z2_andInt))

g_orInt :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int (T.Fun Int Int))

g_orInt p_orInt p = T.ufun2 a_orInt p_orInt p h_orInt

h_orInt z1_orInt z2_orInt k_orInt =
  T.fromInt k_orInt
    ((T.toInt k_orInt z1_orInt) Data.Bits..|. (T.toInt k_orInt z2_orInt))

g_xorInt :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int (T.Fun Int Int))

g_xorInt p_xorInt p = T.ufun2 a_xorInt p_xorInt p h_xorInt

h_xorInt z1_xorInt z2_xorInt k_xorInt =
  T.fromInt k_xorInt
    (Data.Bits.xor (T.toInt k_xorInt z1_xorInt) (T.toInt k_xorInt z2_xorInt))

g_notInt :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int Int)

g_notInt p_notInt p = T.ufun1 a_notInt p_notInt p h_notInt

h_notInt z1_notInt k_notInt =
  T.fromInt k_notInt (Data.Bits.complement (T.toInt k_notInt z1_notInt))

g_shiftInt :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int (T.Fun Int Int))

g_shiftInt p_shiftInt p = T.ufun2 a_shiftInt p_shiftInt p h_shiftInt

h_shiftInt z1_shiftInt z2_shiftInt k_shiftInt =
  T.fromInt k_shiftInt
    (Data.Bits.shift (T.toInt k_shiftInt z1_shiftInt)
      (T.toInt k_shiftInt z2_shiftInt))

g_rotateInt :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int (T.Fun Int Int))

g_rotateInt p_rotateInt p = T.ufun2 a_rotateInt p_rotateInt p h_rotateInt

h_rotateInt z1_rotateInt z2_rotateInt k_rotateInt =
  T.fromInt k_rotateInt
    (Data.Bits.rotate (T.toInt k_rotateInt z1_rotateInt)
      (T.toInt k_rotateInt z2_rotateInt))

g_sizeInt :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int Int)

g_sizeInt p_sizeInt p = T.ufun1 a_sizeInt p_sizeInt p h_sizeInt

h_sizeInt z1_sizeInt k_sizeInt =
  T.fromInt k_sizeInt (Data.Bits.bitSize (T.toInt k_sizeInt z1_sizeInt))

instance Bits (Int)
  where
  
  (!.&.) (%.&.) p = T.uconstUse (%.&.) p (|.&.)
  
  (|.&.) =
    T.uconstDef T.mkRoot (++>=&=+>=$$.&.) (\ p -> g_andInt T.mkNoSrcPos p)
  
  (!.|.) (%.|.) p = T.uconstUse (%.|.) p (|.|.)
  
  (|.|.) = T.uconstDef T.mkRoot (+^!=&=^!=$#.|.) (\ p -> g_orInt T.mkNoSrcPos p)
  
  gxor pxor p = T.uconstUse pxor p sxor
  
  sxor = T.uconstDef T.mkRoot a71v3v71v22xor (\ p -> g_xorInt T.mkNoSrcPos p)
  
  gcomplement pcomplement p = T.uconstUse pcomplement p scomplement
  
  scomplement =
    T.uconstDef T.mkRoot a72v3v72v22complement (\ p -> g_notInt T.mkNoSrcPos p)
  
  gshift pshift p = T.uconstUse pshift p sshift
  
  sshift =
    T.uconstDef T.mkRoot a73v3v73v24shift (\ p -> g_shiftInt T.mkNoSrcPos p)
  
  grotate protate p = T.uconstUse protate p srotate
  
  srotate =
    T.uconstDef T.mkRoot a74v3v74v25rotate (\ p -> g_rotateInt T.mkNoSrcPos p)
  
  gbitSize pbitSize p = T.uconstUse pbitSize p sbitSize
  
  sbitSize =
    T.uconstDef T.mkRoot a75v3v75v23bitSize (\ p -> g_sizeInt T.mkNoSrcPos p)
  
  gisSigned pisSigned p =
    T.ufun1 a76v3v76v19isSigned pisSigned p hisSigned
    where
    
    hisSigned _ p = T.con0 T.mkNoSrcPos p True aTrue
    
  

g_andInteger ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Integer (T.Fun Integer Integer))

g_andInteger p_andInteger p = T.ufun2 a_andInteger p_andInteger p h_andInteger

h_andInteger z1_andInteger z2_andInteger k_andInteger =
  T.fromInteger k_andInteger
    ((T.toInteger k_andInteger z1_andInteger)
      Data.Bits..&.
      (T.toInteger k_andInteger z2_andInteger))

g_orInteger ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Integer (T.Fun Integer Integer))

g_orInteger p_orInteger p = T.ufun2 a_orInteger p_orInteger p h_orInteger

h_orInteger z1_orInteger z2_orInteger k_orInteger =
  T.fromInteger k_orInteger
    ((T.toInteger k_orInteger z1_orInteger)
      Data.Bits..|.
      (T.toInteger k_orInteger z2_orInteger))

g_xorInteger ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Integer (T.Fun Integer Integer))

g_xorInteger p_xorInteger p = T.ufun2 a_xorInteger p_xorInteger p h_xorInteger

h_xorInteger z1_xorInteger z2_xorInteger k_xorInteger =
  T.fromInteger k_xorInteger
    (Data.Bits.xor (T.toInteger k_xorInteger z1_xorInteger)
      (T.toInteger k_xorInteger z2_xorInteger))

g_notInteger :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Integer Integer)

g_notInteger p_notInteger p = T.ufun1 a_notInteger p_notInteger p h_notInteger

h_notInteger z1_notInteger k_notInteger =
  T.fromInteger k_notInteger
    (Data.Bits.complement (T.toInteger k_notInteger z1_notInteger))

g_shiftInteger ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Integer (T.Fun Int Integer))

g_shiftInteger p_shiftInteger p =
  T.ufun2 a_shiftInteger p_shiftInteger p h_shiftInteger

h_shiftInteger z1_shiftInteger z2_shiftInteger k_shiftInteger =
  T.fromInteger k_shiftInteger
    (Data.Bits.shift (T.toInteger k_shiftInteger z1_shiftInteger)
      (T.toInt k_shiftInteger z2_shiftInteger))

g_rotateInteger ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Integer (T.Fun Int Integer))

g_rotateInteger p_rotateInteger p =
  T.ufun2 a_rotateInteger p_rotateInteger p h_rotateInteger

h_rotateInteger z1_rotateInteger z2_rotateInteger k_rotateInteger =
  T.fromInteger k_rotateInteger
    (Data.Bits.rotate (T.toInteger k_rotateInteger z1_rotateInteger)
      (T.toInt k_rotateInteger z2_rotateInteger))

g_sizeInteger :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Integer Int)

g_sizeInteger p_sizeInteger p =
  T.ufun1 a_sizeInteger p_sizeInteger p h_sizeInteger

h_sizeInteger z1_sizeInteger k_sizeInteger =
  T.fromInt k_sizeInteger
    (Data.Bits.bitSize (T.toInteger k_sizeInteger z1_sizeInteger))

instance Bits (Integer)
  where
  
  (!.&.) (%.&.) p = T.uconstUse (%.&.) p (|.&.)
  
  (|.&.) =
    T.uconstDef T.mkRoot (+>&=&=>&=$+.&.) (\ p -> g_andInteger T.mkNoSrcPos p)
  
  (!.|.) (%.|.) p = T.uconstUse (%.|.) p (|.|.)
  
  (|.|.) =
    T.uconstDef T.mkRoot (+>*=&=>*=$*.|.) (\ p -> g_orInteger T.mkNoSrcPos p)
  
  gxor pxor p = T.uconstUse pxor p sxor
  
  sxor =
    T.uconstDef T.mkRoot a96v3v96v26xor (\ p -> g_xorInteger T.mkNoSrcPos p)
  
  gcomplement pcomplement p = T.uconstUse pcomplement p scomplement
  
  scomplement =
    T.uconstDef T.mkRoot a97v3v97v26complement
      (\ p -> g_notInteger T.mkNoSrcPos p)
  
  gshift pshift p = T.uconstUse pshift p sshift
  
  sshift =
    T.uconstDef T.mkRoot a98v3v98v28shift (\ p -> g_shiftInteger T.mkNoSrcPos p)
  
  grotate protate p = T.uconstUse protate p srotate
  
  srotate =
    T.uconstDef T.mkRoot a99v3v99v29rotate
      (\ p -> g_rotateInteger T.mkNoSrcPos p)
  
  gbitSize pbitSize p =
    T.ufun1 a100v3v100v44bitSize pbitSize p hbitSize
    where
    
    hbitSize _ p =
      T.uwrapForward p
        (herror (T.fromLitString T.mkNoSrcPos p "Bits.bitSize(Integer)") p)
    
  
  gisSigned pisSigned p =
    T.ufun1 a101v3v101v19isSigned pisSigned p hisSigned
    where
    
    hisSigned _ p = T.con0 T.mkNoSrcPos p True aTrue
    
  

tData_Bits = T.mkModule "Data.Bits" "Data/Bits.hs" Prelude.False

a_andInt = T.mkVariable tData_Bits 600001 600077 3 2 "_andInt" Prelude.False

a_orInt = T.mkVariable tData_Bits 610001 610077 3 2 "_orInt" Prelude.False

a_xorInt = T.mkVariable tData_Bits 620001 620077 3 2 "_xorInt" Prelude.False

a_notInt = T.mkVariable tData_Bits 630001 630070 3 1 "_notInt" Prelude.False

a_shiftInt = T.mkVariable tData_Bits 640001 640077 3 2 "_shiftInt" Prelude.False

a_rotateInt =
  T.mkVariable tData_Bits 650001 650077 3 2 "_rotateInt" Prelude.False

a_sizeInt = T.mkVariable tData_Bits 660001 660070 3 1 "_sizeInt" Prelude.False

a_andInteger =
  T.mkVariable tData_Bits 780001 790051 3 2 "_andInteger" Prelude.False

a_orInteger =
  T.mkVariable tData_Bits 800001 810051 3 2 "_orInteger" Prelude.False

a_xorInteger =
  T.mkVariable tData_Bits 820001 830051 3 2 "_xorInteger" Prelude.False

a_notInteger =
  T.mkVariable tData_Bits 840001 850040 3 1 "_notInteger" Prelude.False

a_shiftInteger =
  T.mkVariable tData_Bits 860001 870047 3 2 "_shiftInteger" Prelude.False

a_rotateInteger =
  T.mkVariable tData_Bits 880001 890047 3 2 "_rotateInteger" Prelude.False

a_sizeInteger =
  T.mkVariable tData_Bits 900001 910036 3 1 "_sizeInteger" Prelude.False

a33v8v33v12shift =
  T.mkVariable tData_Bits 330008 330012 34 2 "shift" Prelude.False

a47v5v47v38bit = T.mkVariable tData_Bits 470005 470038 3 1 "bit" Prelude.False

a48v8v48v13setBit =
  T.mkVariable tData_Bits 480008 480013 3 2 "setBit" Prelude.False

a49v8v49v15clearBit =
  T.mkVariable tData_Bits 490008 490015 3 2 "clearBit" Prelude.False

a50v8v50v20complementBit =
  T.mkVariable tData_Bits 500008 500020 3 2 "complementBit" Prelude.False

a51v8v51v14testBit =
  T.mkVariable tData_Bits 510008 510014 3 2 "testBit" Prelude.False

a55v8v55v13shiftL =
  T.mkVariable tData_Bits 550008 550013 34 2 "shiftL" Prelude.False

a56v8v56v13shiftR =
  T.mkVariable tData_Bits 560008 560013 34 2 "shiftR" Prelude.False

a57v8v57v14rotateL =
  T.mkVariable tData_Bits 570008 570014 34 2 "rotateL" Prelude.False

a58v8v58v14rotateR =
  T.mkVariable tData_Bits 580008 580014 34 2 "rotateR" Prelude.False

(++>=&=+>=$$.&.) =
  T.mkVariable tData_Bits 690004 690022 30 0 ".&." Prelude.False

(+^!=&=^!=$#.|.) =
  T.mkVariable tData_Bits 700004 700021 22 0 ".|." Prelude.False

a71v3v71v22xor = T.mkVariable tData_Bits 710003 710022 26 0 "xor" Prelude.False

a72v3v72v22complement =
  T.mkVariable tData_Bits 720003 720022 3 0 "complement" Prelude.False

a73v3v73v24shift =
  T.mkVariable tData_Bits 730003 730024 34 0 "shift" Prelude.False

a74v3v74v25rotate =
  T.mkVariable tData_Bits 740003 740025 34 0 "rotate" Prelude.False

a75v3v75v23bitSize =
  T.mkVariable tData_Bits 750003 750023 3 0 "bitSize" Prelude.False

a76v3v76v19isSigned =
  T.mkVariable tData_Bits 760003 760019 3 1 "isSigned" Prelude.False

(+>&=&=>&=$+.&.) =
  T.mkVariable tData_Bits 940004 940026 30 0 ".&." Prelude.False

(+>*=&=>*=$*.|.) =
  T.mkVariable tData_Bits 950004 950025 22 0 ".|." Prelude.False

a96v3v96v26xor = T.mkVariable tData_Bits 960003 960026 26 0 "xor" Prelude.False

a97v3v97v26complement =
  T.mkVariable tData_Bits 970003 970026 3 0 "complement" Prelude.False

a98v3v98v28shift =
  T.mkVariable tData_Bits 980003 980028 34 0 "shift" Prelude.False

a99v3v99v29rotate =
  T.mkVariable tData_Bits 990003 990029 34 0 "rotate" Prelude.False

a100v3v100v44bitSize =
  T.mkVariable tData_Bits 1000003 1000044 3 1 "bitSize" Prelude.False

a101v3v101v19isSigned =
  T.mkVariable tData_Bits 1010003 1010019 3 1 "isSigned" Prelude.False
