import Control.Monad.State
import Data.Binary
import Data.Typeable
import HAppS hiding(Proxy)
import HAppS.Protocols.HList
import HList


data Foo deriving(Typeable); foo = proxy :: Proxy Foo
data Bar deriving(Typeable); bar = proxy :: Proxy Bar
data Baz deriving(Typeable); baz = proxy :: Proxy Baz

type MyR = Record (HCons (F (Proxy Foo) Int)
                  (HCons (F (Proxy Bar) String)
                  (HCons (F (Proxy Baz) Bool)
                  (HNil))))

type MyState = [MyR]

new a b c = foo .=. a .*. bar .=. b .*. baz .=. c .*. emptyRecord :: MyR

oo x = encode x
    where a = HBinaryPut

selFoo :: String -> MyState -> ToXml MyR
selFoo x st = ToXml "top" [ r  | r <- st, r # bar == x ]

f s = (new 34 s True :)

-- simple HAppS app

impl = simpleHTTP
       [debugFilter -- we want to see debug messages in the console
       ,h "/sel/" GET $ ok xml $ \a () -> respond =<< gets (selFoo a)
       ,h "/ins/" GET $ ok xml $ \s () -> modify (f s) >> respond "Insert"
       ,h "/foo" GET $ ok plain $ \() () -> fail "Fiikuna"
       ,h () GET $ ok plain $ val "Hello" -- http://localhost:8000/hello
--       , noState
       ]

main = stdMain $ impl :*: End


instance Read MyR
