module Main where
-- See MXClient.hs for more examples

import HAppS.Protocols.DNS
import Data.List

main = do
  -- Query for SRV DNS record
  res_srv <- ns $ question "_xmpp-server._tcp.jabber.ru" 33 1
  sequence_ $ flip map (getType 33 res_srv) $ \(RRvSRV prio weight port dest) ->
    do putStrLn $ "Priority = " ++ show prio
       putStrLn $ "Weight = " ++ show weight
       putStrLn $ "Port = " ++ show port
       putStrLn $ "Target = " ++ qd dest

  -- Query for TXT DNS record
  putStrLn "QUERY FOR TXT"
  res_txt <- ns $ question "_xmppconnect.jabber.ru" 16 1 
  sequence_ $ flip map (getType 16 res_txt) $ \(RRvTXT val) -> putStrLn $ "Value = " ++ qd val

getType x p = map getRRv $ filter (isType x) $ rsPQ p
isType x rr  =  rtype rr == x
getRRv (RR2 _ _ _ _ x) = x
