/***************************************************************************
                          openetext.cpp  -  description
    begin                : Sat Dec 4 1999
    begin                : Tue Jul 25 2000
    copyright            : (C) 2000 by llornkcor
    email                : ljp@llornkcor.com
 ***************************************************************************/
/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "gutenbrowser.h"
#include "openetext.h"
#include "editTitle.h"

#include <stdlib.h>
#include <qtextstream.h>
#if defined(Q_WS_WIN)
#include <windows.h>
#else
#include <unistd.h>
#include "sys/stat.h"
#endif

OpenEtext::OpenEtext(QWidget *parent, QString name) : QDialog(parent,name,true) {
#ifndef Q_WS_QWS
    setCursor( waitCursor );
#endif
#if defined(Q_WS_WIN)

    QString local_library = (QDir::homeDirPath ()) +"/.gutenbrowser/";
    this->setIcon(QPixmap(local_library+"pix/gutenbrowser.png"));
#else

    this->setIcon(QPixmap("/usr/share/gutenbrowser/pix/gutenbrowser.png"));
#endif
#ifdef Q_WS_QWS

    local_library = (QDir::homeDirPath ()) +"/gutenbrowser/";
#endif

    initDialog();

    connect(QListBox_1,SIGNAL(selected(int)),this,SLOT(select_title(int)));

    getTitles();
}

OpenEtext::~OpenEtext() {}

void OpenEtext::getTitles() {
    config->setGroup( "Files" );
    s_numofFiles = config->readEntry("NumberOfFiles", "0");
    QLabel_1->setText( tr(
                           s_numofFiles+" etexts in your library."));
    int  i_numofFiles = s_numofFiles.toInt();
    for (int i = 1; i <= i_numofFiles; i++) {
        QString temp;
        temp.setNum(i);
        config->setGroup( "Files" );
        QString ramble = config->readEntry(temp, "" );
        config->setGroup( "Titles" );
        title = config->readEntry(ramble, "");

        if( !title.isEmpty()) {
            QListBox_1->insertItem ( title, -1);
        }
    }
    setCursor(arrowCursor);
}

/*
 opens selected title */
void OpenEtext::OpenTitle() {
    if( QListBox_1->currentItem() != -1)
        select_title(  QListBox_1->currentItem() );
    else {
        QString sMsg;
        sMsg = "You must select an Etext to open";
        QMessageBox::message( "Error",sMsg);
    }
}

void OpenEtext::select_title(int index ) {
    QString temp;
    temp.setNum( index + 1);
    const char * title;
    title = QListBox_1->text( index );
    openFileTitle = title;

    config->setGroup( "Files" );
    file = config->readEntry(temp, "");
    OpenEtext::accept();
}

void OpenEtext::open() {
#ifndef Q_WS_QWS
    setCursor( waitCursor );
#endif

    title = "";
    QString currDir="";
    QString filer;
    QString local ;
#ifndef Q_WS_QWS

    local = (QDir::homeDirPath () +"/.gutenbrowser");
#else

    local = (QDir::homeDirPath () +"/gutenbrowser");
#endif

    QDir library( local);
    //////////////////////   TODO
    /////////////////////   figure out what to do about this in embedded
    fileList = QFileDialog::getOpenFileNames("Text Files (*.txt)",local,this);
    QStringList::ConstIterator f;
    QString fileTemp;
    for (  f = fileList.begin(); f != fileList.end(); f++ ) {
        fileTemp = *f;
        fileTemp.right( fileTemp.length()-5);
        fileName = fileTemp;
        if( !fileName.isEmpty() ) {
            filer = fileName;
        } else {
            QString sMsg;
            sMsg = "Error opening library filelist "+fileName;
        }

        if( filer.right(4) == ".txt" ||  filer.right(4) == ".TXT" ||  filer.right(4) == ".zip"  ||  filer.right(4) == ".ZIP" ) {
            QFileInfo zipFile( filer);
            QString s_fileName = zipFile.fileName();
            QString cmd;
            if( s_fileName.right(4) == ".zip") {     // unzip that sucker....
                s_fileName = s_fileName.left( s_fileName.length() - 4);
#if defined(Q_WS_X11_)

                if( chdir((const char*)local_library.latin1())!=0)
                    qDebug("chdir failed.");
                cmd = "gunzip -S .zip " + filer;
                //      cmd = "gunzip -S .zip " + local_library+zipFile;
#endif
#if defined(Q_WS_WIN)

                QString temp= QDir::convertSeparators(local_library);
                filer=QDir::convertSeparators( filer);
                QString cmd = temp+"unzip.exe -o " +filer/*newestLibraryFile  */+" -d " + temp;
#endif
#ifdef Q_WS_QWS

                if( chdir((const char*)local_library.latin1())!=0)
                    qDebug("chdir failed.");
                //                QString cmd = "gunzip -d " + filer + " -d " + local_library;
                cmd = "gunzip -S .zip " + filer;

#endif

                fileName = local_library + s_fileName + ".txt";

#if defined(Q_WS_X11_)//

                system( cmd);
#endif
#if defined(Q_WS_WIN)

                WinExec( cmd, SW_HIDE );
#endif

            }
        }
        FindTitle();
        QListBox_1->clear();
        getTitles();
    } // end of for each file name....
#ifndef Q_WS_QWS
    setCursor(arrowCursor);
#endif
}

/*
find the title in the config file */
bool OpenEtext::FindTitle() {
    config->setGroup( "Files" );
    QString s_numofFiles = config->readEntry("NumberOfFiles", "0");
    int  i_numofFiles = s_numofFiles.toInt();

    QFileInfo fi(fileName);
    name = fi.fileName();
#if defined(_WIN32)
    //      QMessageBox::message("Hi", "Trying to open "+fileName +"\n");
    //#if defined(Q_WS_WIN)
    //fileName = fileName.right( fileName.length() - 5);
#endif

#if defined(Q_WS_X11_)

    //    fileName = fileName.right( fileName.length() - 5);
#endif

    QFile indexLib( fileName);

    if ( indexLib.open( IO_ReadOnly) ) {
        // file opened successfully
        QTextStream indexStream( &indexLib );
        QString target = "Project Gutenberg Etext of";
        QString target2 = "Project Gutenberg Etext";
        QString indexLine;
        bool findCheck = false;
        while ( !indexStream.eof() ) {
            // until end of file..
            indexLine = indexStream.readLine();

            int Titlenumber = indexLine.find(target, 0, true);
            if( Titlenumber > -1) {
                findCheck = true;
                title = indexLine.mid( Titlenumber + (target.length()) , indexLine.find("\r", 0, true));
                title = title.left( title.find( "*",0, true));
                title = title.stripWhiteSpace ();
                //                qDebug("Found the title 1 and it is/n %s", title.latin1());
                //                              QListBox_1->insertItem ( title);
            } else if( findCheck == false) {
                int Titlenumber = indexLine.find( target2, 0, true);
                if( Titlenumber > -1) {
                    findCheck = true;
                    title = indexLine.mid( Titlenumber + ( target2.length()) , indexLine.find("\r", 0, true));
                    title = title.left( title.find( "*",0, true));
                    title = title.stripWhiteSpace ();
                    //                    qDebug("Found the title 2 and it is\n %s", title.latin1());
                    //                              QListBox_1->insertItem ( title);
                } else {
                    //                    qDebug("Having trouble finding title.");
                    title = titleFromLibrary( fileName);
                    //                    qDebug( "%s",title.latin1());
                    if( title.length() >3)
                        findCheck=true;
                }
            }
        }

        if ( checkConf() == false && findCheck == true) {
            config->setGroup( "Files");
            config->writeEntry("NumberOfFiles",i_numofFiles + 1 );
            QString interger;
            interger.setNum( i_numofFiles +1);
            config->writeEntry(interger, fileName);
            config->setGroup( "Titles" );
            config->writeEntry( fileName,title);
            config->write();
        }
    } else {
        QString sMsg;
        sMsg = "Error opening library file: "+fileName;
        printf( sMsg+"\n");
    }
    return true;
}

QString OpenEtext::titleFromLibrary( QString fileName) {
    QFile indexLib( local_index);
    QString target;
    int find1 = fileName.findRev("/",-1,true)  + 1;
    int find2 = fileName.findRev(".txt",-1,true) - find1;
    target = fileName.mid( find1,  find2 );
    QString checker = target.right(1);
    bool ok;
    checker.toInt( &ok,10);
    if( ok) {
        target = target.left( target.length()-1);
        checker = target.right(1);
        ok = false;
        checker.toInt( &ok,10);
        if( ok) {
            target = target.left( target.length()-1);
        }
    }
    if ( indexLib.open( IO_ReadOnly) ) {
        // file opened successfully
        QTextStream indexStream( &indexLib );
        QString indexLine;
        bool findCheck = false;
        while ( !indexStream.atEnd() ) {                  // until end of file..
            indexLine = indexStream.readLine();

            if( indexLine.find( target,0,false) > 0 ) {
                findCheck = true;
                title = indexLine.mid( 26, indexLine.length() );
                title = title.stripWhiteSpace ();
                //                qDebug("Finally Found the title and it is\n %s", title.latin1());
                //                              QListBox_1->insertItem ( title);
            }
        } //end while loop
    } else
        printf("Error opening library index\n");
    return title;
}

bool OpenEtext::checkConf() {
    QString file = fileName;
    config->setGroup( "Files" );
    QString s_numofFiles = config->readEntry("NumberOfFiles", "0" );
    int  i_numofFiles = s_numofFiles.toInt();

    for (int i = 1; i <= i_numofFiles; i++) {
        QString temp;
        temp.setNum(i);
        config->setGroup( "Files");
        QString ramble = config->readEntry(temp, "" );

        if(ramble == file ) {
            return true;
        }
    }
    return false;
}



void OpenEtext::remove
    () {
#ifndef Q_WS_QWS
    setCursor( waitCursor );
#endif

    title_text = QListBox_1->text( QListBox_1->currentItem() );
    title_text=title_text.stripWhiteSpace();
    QString msg ="Do you really want to REMOVE\n" +title_text +"?\nThis will not delete the file from the hard drive.";
    switch( QMessageBox::information( this, (tr("Remove Etext")),
                                      (tr(msg)),
                                      (tr("&Yes")), (tr("&Cancel")), 0 )) {
    case 0: // Yes clicked,
        removeSelection();
        QListBox_1->clear();
        getTitles();
        break;
    case 1: // Cancel
        break;
    };
#ifndef Q_WS_QWS

    setCursor(arrowCursor);
#endif
}

void OpenEtext::removeSelection() {
    //config->read();
    config->setGroup( "Files" );
    s_numofFiles = config->readEntry("NumberOfFiles", "0");

    int  i_numofFiles = s_numofFiles.toInt();
    for (int i = 1; i <= i_numofFiles; i++) {
        QString fileNum;
        fileNum.setNum(i);
        config->setGroup( "Files" );
        QString s_filename = config->readEntry(fileNum, "" );
        config->setGroup( "Titles" );
        QString file_title = config->readEntry( s_filename, "");
        //   QMessageBox::message("file_title",file_title);
        if(title_text == file_title ) {
            selFile = s_filename;
            //  QMessageBox::message( "Note", selFile );
        }
    }
    remFile();
}

void OpenEtext::remFile() {
    config->setGroup( "Files" );
    QString remFile;
    s_numofFiles = config->readEntry("NumberOfFiles", "0");
    int  i_numofFiles = s_numofFiles.toInt();
    for (int i = 1; i <= i_numofFiles; i++) {
        QString fileNum;
        fileNum.setNum(i);
        config->setGroup( "Files" );
        QString s_filename = config->readEntry(fileNum, "" );

        if( s_filename == selFile) {

            for(int fg = i_numofFiles - i; fg < i_numofFiles ; fg++  ) {
                QString fileNum2;
                fileNum2.setNum( fg + 1);
                QString s_filename2 = config->readEntry(fileNum2, "" );

                if (!s_filename2.isEmpty()) {
                    config->writeEntry(fileNum, s_filename2 );
                }
            }
        }
    }
    config->writeEntry("NumberOfFiles", i_numofFiles - 1 );
    config->write();
    QString local_fileToRemove;
    QString strDir;
    strDir = "/gutenbrowserrc";
    QString newRc;
    QFile rcFile(strDir);
    if ( rcFile.open(IO_ReadWrite) )  { // file opened successfully
        QTextStream rcStream( &rcFile );
        QString rcLine;

        while ( !rcStream.eof() )   { // until end of file..
            rcLine = rcStream.readLine();
            if (( rcLine.left(11) != selFile) && (  rcLine.left(2) != s_numofFiles)) {
                newRc += rcLine+"\n";
            }
        }
    }
    rcFile.close();
    QFile rcFile2(strDir);

    if ( rcFile2.open(IO_WriteOnly) ) {  // file opened successfully
        rcFile2.writeBlock(newRc, newRc.length());
        rcFile2.close();
    }
    if( !selFile.contains("/", true) ) {
        local_fileToRemove = local_library + selFile;
    } else {
        local_fileToRemove = selFile;
    }
    //    if(!QFile::remove(local_fileToRemove))
    //        QMessageBox::message( "Note","Could not delete\n" + selFile );
    config->write();
    QListBox_1->triggerUpdate(true);
}

/*
sorts the list*/
void OpenEtext::scan() {
    QListBox_1->sort(true);
    QListBox_1->triggerUpdate(true);
}

void  OpenEtext::editTitle() {

    int currentItem = QListBox_1->currentItem();
    QString title_text = QListBox_1->text( currentItem);
    //odebug << "Selected "+title_text << oendl;

    config->setGroup( "Files" );
    s_numofFiles = config->readEntry("NumberOfFiles", "0");
    int  i_numofFiles = s_numofFiles.toInt();
    QString fileNum;
    for (int i = 1; i <= i_numofFiles+1; i++) {

        fileNum.setNum(i);
        config->setGroup( "Files" );
        QString s_filename = config->readEntry(fileNum, "" );
        config->setGroup( "Titles" );
        QString file_title = config->readEntry( s_filename, "");
        //odebug << "file_title is "+file_title << oendl;
        if(title_text == file_title ) {
            selFile = s_filename;
            //odebug << "Edit: "+ file_title << oendl;
            i = i_numofFiles + 1;
            Edit_Title *titleEdit;
            titleEdit = new Edit_Title(this,file_title ,true);
            if(titleEdit->exec() !=0) {
                //odebug << titleEdit->newTitle << oendl;
                config->writeEntry( s_filename, titleEdit->newTitle);
                QListBox_1->removeItem(currentItem);
                QListBox_1->insertItem (/*QPixmap( QPEApplication::qpeDir()+"pics/gutenbrowser/gutenbrowser_sm.png"), */titleEdit->newTitle, currentItem);
            }
        }
    }
	 config->write();

    //    getTitles();
    QListBox_1->triggerUpdate(true);

}
