/***************************************************************************
                          gutenbrowser.cpp  -  description
                             -------------------
    begin                : Mon Jul 24 22:33:12 MDT 2000
    copyright            : (C) 2000 by llornkcor
    email                : ljp@llornkcor.com
 ***************************************************************************/
/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
// http search
//        http://digital.library.upenn.edu/books/authors.html
//        http://digital.library.upenn.edu/books/titles.html

//  #ifdef Q_WS_QWS
//  #include "/usr/lib/qpe-1.4.0/library/qpeapplication.h"
//  #include <qfiledialog.h>
//  #else

//  #endif
#include "gutenbrowser.h"
#include "LibraryDialog.h"
//#include "bookmarksdlg.h"
#include "optionsDialog.h"
#include "helpme.h"
#include "openetext.h"

#include <stdio.h>
#include <stdlib.h>
#include <qregion.h>
#include <qpaintdevicemetrics.h>
#include <qvaluelist.h>
#include <qlabel.h>
#include <qclipboard.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qobjectlist.h>
#include <qfontdialog.h>
#include <qtextview.h>
#include <qbrush.h>
#include <qfile.h>
#include <qfontinfo.h>
#include <qscrollview.h>

#if defined(Q_WS_WIN)
#include <windows.h>
#else
#include <unistd.h>
#include "sys/stat.h"
#endif

//#include "pix/gutenbrowser.png"

Gutenbrowser::Gutenbrowser()
        : loadCheck(false) {
    setCaption("Gutenbrowser "  VERSION);

#if defined(Q_WS_WIN)

    local_library = (QDir::homeDirPath ()) +"/.gutenbrowser/";
    if( local_library.find( "//", 0, true) != -1)
        local_library.replace( local_library.find( "//", 0, true) , 2, "/");
#else

    local_library = (QDir::homeDirPath ()) +"/.gutenbrowser";
#endif

    QDir dir(local_library);
    if( !QDir(local_library).exists())
        dir.mkdir( local_library, true);
#if defined(Q_WS_WIN)

    this->setIcon(QPixmap(local_library+"pix/gutenbrowser.png"));
#else

    this->setIcon(QPixmap("/usr/share/gutenbrowser/pix/gutenbrowser.png"));
#endif

    qDebug("local library is "+local_library);

    this->setUpdatesEnabled(true);
    iniFile = local_library + "/gutenbrowserrc";

    config = new CConfigFile( iniFile);
    bool firstTime = false;

    if( !QFile(iniFile).exists() ) {
        firstTime = true;
    }

    config->read();

    topLayout = new QVBoxLayout( this,0,0,"topLayout");
    topLayout->setSpacing( 2);
    topLayout->setMargin( 6);

    menu = new QHBoxLayout( 0,"menu");

    buttons = new QHBoxLayout( 0,"buttons");
    buttons->setSpacing( 4);
    buttons->setMargin( 6);

    edits = new QHBoxLayout(0,"edits");

    useSplitter = true;

    initConfig();

    initMenuBar();
    initButtonBar();
    initView();
    initStatusBar();
    initSlots();

    if( useIcons)
        toggleButtonIcons( true);
    else
        toggleButtonIcons( false);

    //    qDebug("toggleIcons");
    //    QString pix_dir = local_library+"/pix/marble.xpm";
    //parchment.png
    //parchment_3.png
    /*
        QColorGroup mypapcolgrp;
        QColorGroup papcolgrp;
        d->mypapcolgrp = palette().active();
        d->papcolgrp = d->mypapcolgrp;
     
    void QTextView::setPaper( const QBrush& pap)
    {
        d->mypapcolgrp.setBrush( QColorGroup::Base, pap );
        d->papcolgrp.setBrush( QColorGroup::Base, pap );
        d->ownpalette = true;
        viewport()->setBackgroundColor( pap.color() );
        viewport()->update();
    }
     
     
     */
    //           QColorGroup mypapcolgrp;
    //           Lview.mypapcolgrp=palette().active();
    //      QPalette p = Lview->palette();
    //        QBrush b;
    //        b.setPixmap( pix_dir);
    //setPaper(const QBrush & pap)
    //      p.setBrush(QColorGroup::Base, b);
    //      p.setColor(QColorGroup::Base, QColor(220,220,220));
    //       mypapcolgrp.setBrush(QColorGroup::Base, b);
    //      Lview->setPalette(p);
    //       Lview->setBackgroundColor(b.color());
    //      Lview->setBackgroundMode(FixedPixmap);
    //      Rview->setBackgroundMode(FixedPixmap);
    //      Lview->setForegroundPixmap( QPixmap( pix_dir ) );
    //      Rview->setBackgroundPixmap( QPixmap( pix_dir ) );
    //x       Lview->update();

    /// hmmmmppfffft the view must not be the background
    // I want setPaper() in this function!!

#if defined(Q_WS_X11_)

    chdir(local_library);
    QString gutenIndex = local_library + "/GUTINDEX.ALL";
    if( QFile( gutenIndex).exists() ) {
        indexLib.setName( gutenIndex);
    } else {

        QString localLibIndexFile = local_library + "/PGWHOLE.TXT";
        //       if( QFile( localLibIndexFile).exists() ) {
        newindexLib.setName( localLibIndexFile);
        //          } else {
        //              QString sysLibIndexFile="/usr/share/doc/gutenbrowser/PGWHOLE.TXT";

        //              if( QFile( sysLibIndexFile).exists() ) {
        //                  newindexLib.setName( sysLibIndexFile);
        //              } else
        //                  QMessageBox::message("Note","hey");
        //             switch( QMessageBox::warning( this, "Application name",
        //                                            "Install the library index?",
        //                                            QMessageBox::Yes,   QMessageBox::No)) {
        //                      case   QMessageBox::Yes: // yes
        //           {
        //               QString cmd;
        //                      cmd="cp "+sysLibIndexFile+" "+localLibIndexFile;
        //                      newindexLib.setName( localLibIndexFile);
        //                   QMessageBox::message("Note",cmd);
        //                   system(cmd);
        //           }
        //                      break;
        //                      case   QMessageBox::No: // No
        //                        // exit
        //                      break;
        //              }
        // }
    }
#endif
#if defined(Q_WS_WIN)
    newindexLib.setName( local_library + "/PGWHOLE.TXT");
#endif
  connect(qApp,SIGNAL(aboutToQuit()),this,SLOT(cleanUp()));

    qDebug("init finished.");
    //    if(firstTime)
    //        Bookmark();

}

Gutenbrowser::~Gutenbrowser()
{
    if(printer)
        delete printer;
}

void Gutenbrowser::cleanUp()
{
//   writeConfig();
}

void Gutenbrowser::InfoBarClick()
{
    title.replace( QRegExp("\\s"), "%20");
    QString s_lookup = "http://google.com/search?q="+title+"&num=30&sa=Google+Search";
    goGetit( s_lookup, false);
}

void Gutenbrowser::goGetit( QString url, bool showMsg) {
    int eexit = 0;
    QString cmd;
    config->read();
    config->setGroup( "Browser" );
    QString brow = config->readEntry("Preferred", "");
#ifdef Q_WS_QWS

    if(url.find(".zip",0,true)) {
        qDebug("found a zip file use wget");
        cmd="wget -q "+url+" &";
    } else {
        if( brow == "Konq") {
            cmd = "konqueror "+url+" &";
        }
        if( brow =="Lynx") {
            //        cmd = ""xterm -fg black -bg white -e lynx -source "+ s_lookup + " | cat >> ~/somefile.html";
            //        else
            cmd = "xterm -fg black -bg white -e lynx "+url+" &";
        }
        if( brow == "Opera")  {
            cmd = "opera "+url+" &";
        }
        if( brow == "Mozilla")  {
            cmd = "mozilla "+url+" &";
        }
        if(brow == "wget")
            cmd="wget -q "+url+" &";
    }
    chdir(local_library);
    qDebug("Issuing the system command: %s", cmd.latin1());
    system(cmd);
#else

    if ( showMsg)
        eexit=QMessageBox::information(this, "Note","<p>This part under construction. Do you want to use "
                                       +brow+" to download "+url
                                       +"? Please save it into the ~/.gutenbrowser directory.</p>"
                                       ,QMessageBox::Ok, QMessageBox::Cancel);
    if (eexit== 1 || eexit== 0) {
        QString cmd;
#if defined(Q_WS_X11_)

        if( brow == "Konq") {
            cmd = "konqueror "+url+" &";
        }
        if ( brow == "Netscape") {
            QString str = QDir::homeDirPath() + "/.netscape/lock";
            /*          //  struct stat *stat_p;
            //
            //  if ( -1 !=  lstat (str, stat_p))  { // if theres a lock file
            //      cmd = "netscape -remote 'openURL( "+url+" )'";
            //            KShellProcess proc("bash");
            //            proc << "netscape" <<"-remote" << "'openURL(" <<url << ")'";
            //            proc.start(KProcess::DontCare,KProcess::All);
            */
            //            }
            //  else {
            cmd = "netscape "+url+" &";
        }

        if( brow =="Lynx") {
            //      if( url.find(".zip", 0, true)
            //        cmd = ""xterm -fg black -bg white -e lynx -source "+ s_lookup + " | cat >> ~/somefile.html";
            //        else
            cmd = "xterm -fg black -bg white -e lynx "+url+" &";
        }
        if( brow == "Opera")  {
            cmd = "opera "+url+" &\n";
        }
        if( brow == "Mozilla")  {
            cmd = "mozilla "+url;
        }
        if(brow == "wget")
            cmd="wget -q "+url;
        //// http://www.encyclopedia.com/home.html
        chdir(local_library);
        qDebug("Issuing the system command: %s", cmd.latin1());
        system(cmd);
#endif

#if defined(Q_WS_WIN)

        QString ind=local_library.left(local_library.length()-1);
        QString m_Player,vip;
        if(!showMsg) {
            m_Player=local_library+"llkcrbrowser.exe";
            vip=" /"+url;
        } else {
            m_Player=local_library+"wget.exe";
            vip=" -q "+url;
        }
        if( !QFile(m_Player).exists() )
            QMessageBox::message("Note","please install llkcrbrowser");
        if( url.find("http://", 0, false))
            url=url.right( url.length()-7);
        //    vip=" "+url;
        //    vip=" "+url;
        m_Player+=vip;
        WinExec( m_Player, SW_SHOWNORMAL);
        //  WinExec( m_Player, SW_HIDE);
#endif

    } else {}
#endif
}

void Gutenbrowser::toggleButtonIcons( bool useEm)
{
    Q_UNUSED(useEm);
    QString pixDir;

#if defined(Q_WS_WIN)
    pixDir = local_library;
#else
    pixDir = "/usr/share/gutenbrowser";
    if(!QDir(pixDir).exists())
        pixDir = local_library;
#endif
	if(!QDir(pixDir).exists()) {
        QMessageBox::message("Note","<p>Could not find icon directory.</p>");
	}

    if( useIcons && QDir( pixDir+"/pix").exists() ) {

        PrintButton->setPixmap(  QPixmap( pixDir+"/pix/fileprint.png"));
        FontButton->setPixmap( QPixmap( pixDir+"/pix/text.png") );
        ClearButton->setPixmap(  QPixmap( pixDir+"/pix/eraser.png"));
        OptionsButton->setPixmap( QPixmap( pixDir+"/pix/configure.png") );
        HelpButton->setPixmap(  QPixmap( pixDir+"/pix/help.png"));

        LibraryButton->setPixmap(  QPixmap( pixDir+"/pix/home.png"));
        OpenButton->setPixmap(  QPixmap( pixDir+"/pix/openbook.png"));
        ForwardButton->setPixmap(  QPixmap( pixDir+"/pix/forward.png"));
        BackButton->setPixmap( QPixmap( pixDir+"/pix/back.png") );
        SearchButton->setPixmap( QPixmap( pixDir+"/pix/search.png") );
        lastBmkButton->setPixmap(  QPixmap( pixDir+"/pix/flag.png"));
        setBookmarkButton->setPixmap( QPixmap( pixDir+"/pix/tick.png") );
        dictionaryButton->setPixmap( QPixmap( pixDir+"/pix/spellcheck.png") );
    } else {

        LibraryButton->setText("&Library");
        OpenButton->setText("&Open" );
        ForwardButton->setText( "&Forward");
        BackButton->setText("&Back");
        PrintButton->setText("&Print");
        SearchButton->setText("&Search");
        lastBmkButton->setText("goto &Mark");
        setBookmarkButton->setText("setMa&rk");
        FontButton->setText("Fon&t");
        ClearButton->setText("Cle&ar");
        OptionsButton->setText( "Optio&ns" );
        HelpButton->setText("&About");
        dictionaryButton->setText("Loo&kup");
    }
}


bool Gutenbrowser::queryExit()
{// I hate this, is why its never called
    int exit=QMessageBox::information(this, "Quit...", "Do your really want to quit?"
                                      , QMessageBox::Ok, QMessageBox::Cancel);
    if (exit==1) {
        writeConfig();
        qApp->quit();
    } else {}
    ;
    return (exit==1);
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION

void Gutenbrowser::slotFilePrint()
{
    const int Margin = 10;
    int pageNo = 1;
    statusBar->message("Printing...");
    if (printer->setup(this)) {
        QPainter painter;
        if( !painter.begin( printer) )
            return;
        painter.setFont( Lview->font() );
        int yPos    = 0;            // y position for each line
        QFontMetrics fm = painter.fontMetrics();
        QPaintDeviceMetrics metrics( printer ); // need width/height
        // of printer surface
        for( int i = 0 ; i < Lview->numLines() ; i++ ) {
            if ( Margin + yPos > metrics.height() - Margin ) {
                QString msg( "Printing (page " );
                msg += QString::number( ++pageNo );
                msg += ")...";
                statusBar->message( msg );
                printer->newPage();     // no more room on this page
                yPos = 0;           // back to top of page
            }
            painter.drawText( Margin, Margin + yPos,
                              metrics.width(), fm.lineSpacing(),
                              ExpandTabs | DontClip, Lview->textLine( i ) );
            yPos = yPos + fm.lineSpacing();
        }

        painter.end();
    };
    statusBar->message(IDS_STATUS_DEFAULT);
}

/*exits the app*/
void Gutenbrowser::ByeBye() {
    if (b_queryExit)
        queryExit();
    else {
        writeConfig();
        qApp->quit();
    }
}

void Gutenbrowser::HelpBtn()
{
    statusBar->message("Help me...");
    statusBar->message(IDS_STATUS_DEFAULT);
    HelpMe* HelpDlg;
    HelpDlg = new HelpMe( this, "Help Dialog");
    HelpDlg->show();
}

void Gutenbrowser::DownloadIndex() {
    //    {
    switch( QMessageBox::information( 0, (tr("Download Library Index, or FTP sites?")),
                                      (tr("<p> Do you want to download the newest "
                                          "Project Gutenberg Library Index? "
                                          "or select an ftp site?</p>")),
                                      (tr("&Library Index")), (tr("&Ftp Site")), (tr("&Cancel"))
                                      , 2, 2 ) ) {
    case 0: // index clicked,
        downloadLibIndex();
        break;

    case 1: // ftp selected
        downloadFtpList();
        break;

    case 2: // Cancel
        break;
    };
    //            }
} // end DownloadIndex

void Gutenbrowser::downloadFtpList()
{
    setCursor( waitCursor );
    //  QString cmd="wget http://www.promo.net/pg/list.html");
    //system(cmd);
    optionsDialog* optDlg;
    optDlg = new optionsDialog( this,"Options_Dlg", true);
    optDlg->getSite();
    if(optDlg)
        delete optDlg;
    setCursor(arrowCursor);
}


void Gutenbrowser::downloadLibIndex()
{
    setCursor( waitCursor );
    QString outputFile = local_library+ "/GUTINDEX.ALL";
    config->setGroup( "FTPsite" );  // ftp server config
    ftp_host = config->readEntry("SiteName", "");
    ftp_base_dir = config->readEntry("base",  "");
    //   QString networkUrl= "ftp://"+ftp_host+ftp_base_dir+"/GUTINDEX.ALL";

    QString networkUrl = "http://www.gutenberg.org/dirs/GUTINDEX.ALL";

    QDir dir( local_library);
#if defined(Q_WS_WIN)

    if( local_library.find( "//", 0, true) != -1)
        local_library.replace( local_library.find( "//", 0, true) , 2, "/");
    local_library = dir.convertSeparators(local_library);
#endif

    dir.cd("", true);
    //    goGetit( "http://www.gutenberg.net/pgwhole.zip", true);
    // until ghttp works on binaries -qt3

   QStringList networkList;
   networkList.append((const char *)networkUrl); //host
   networkList.append("/"); //ftp base directory
   networkList.append((const char *)outputFile); //output filepath
   networkList.append("GUTINDEX.ALL"); //filename

   NetworkDialog *NetworkDlg;
   NetworkDlg = new NetworkDialog( this,"Network Protocol Dialog", true, 0, networkList);

   if( NetworkDlg->exec() != 0 ) {
   }
   setCursor(arrowCursor);
   cursor();
}

void Gutenbrowser::PrintBtn() {
    if( ! loadCheck) {
        QMessageBox::message("Note","<p>File is not open.</p>");
        return;
    }
    statusBar->message(IDS_STATUS_DEFAULT);
    slotFilePrint();
}

void Gutenbrowser::SearchBtn()
{
    if( loadCheck)
        Search();
    //  else
    //  QMessageBox::message("Note","Sorry, can't search. No etext is loaded");
}

void Gutenbrowser::ForwardBtn()
{
    if( ! loadCheck) {
        QMessageBox::message("Note","<p>File is not open.</p>");
        return;
    }
    if( !ForwardButton->autoRepeat() && !ForwardButton->isDown()) {

        QString s;
        QString insertString;
        int pageSize = Lview->PageSize();
        Lview->clear();
        Rview->clear();

        for(int fd=0; fd < pageSize - 1;fd++) {
            f.readLine(s, 256);
            if(useWrap)
                s.replace(QRegExp("\n"),"");
            Lview->insertLine( s, -1);
            currentLine++;
        }
        if(useSplitter) {
            for(int fd2 = 0; fd2 < pageSize - 1;fd2++) {
                f.readLine(s, 256);
                if(useWrap)
                    s.replace(QRegExp("\n"),"");
                Rview->insertLine( s, -1);
                currentLine++;
            }
        }
        currentFilePos = f.at();
        i_pageNum++;
        pageStopArray.resize(i_pageNum + 1);

        pageStopArray[i_pageNum ] = currentFilePos;
        //      qDebug( "%d current page is number %d, pagesize  %d, length  %d,  current %d",
        //                currentFilePos, i_pageNum, pageSize, Lview->length(), pageStopArray[i_pageNum]);
        setStatus();
    } else {
        qDebug("bal");
    }
    Lview->setFocus();

    //    qDebug("page number %d, line number %d ",i_pageNum,currentLine);

    /*
    	 QString topR;
        QString lastR;
        QString pageR;
        if(useSplitter) {
            int sizer =  Rview->lastRow() - Rview->topRow();
            int i_rLastRow = Rview->lastRow();
            int i_numbLines = Rview->numLines();
     
            if( i_pageNum != pages) {
                if( sizer > ( i_numbLines - i_rLastRow) ) {
                    //        if( Rview->lastRow() <= i_numbLines ) {
                    Lview->MultiLine_Ex::ScrollUp( i_numbLines - i_rLastRow);
                    Rview->MultiLine_Ex::ScrollUp( i_numbLines - i_rLastRow);
                } else {
                    for (int i = 0; i <2; i++) {
                        Lview->MultiLine_Ex::pageDown( false);
                        Rview->MultiLine_Ex::pageDown( false);
                    }
                    i_pageNum++;
                    status= title + (tr("  :page "));
                    setStatus();
                    Lview->setCursorPosition( Lview->Top(), 0, false);
                }
            } else {
                status = title+(tr(" End of book  "));
                setStatus();
            }
        } else { // using only one view
            if( i_pageNum != pages) {
                Lview->MultiLine_Ex::pageDown( false);
                i_pageNum++;
                status= title + (tr("  :page "));
                setStatus();
                Lview->setCursorPosition( Lview->Top(), 0, false);
            }
        }
    	 
    	 */
}

void Gutenbrowser::BackBtn()
{
    if( ! loadCheck) {
        QMessageBox::message("Note","<p>File is not open.</p>");
        return;
    }
    if( i_pageNum > 0) {
        int pageSize = Lview->PageSize();
        i_pageNum--;
        currentFilePos = f.at();
        //      qDebug( "%d current page is number %d, pagesize  %d, length  %d,  current %d",
        //                currentFilePos, i_pageNum, pageSize, Lview->length(), pageStopArray[i_pageNum]);

        if(  i_pageNum < 2) {
            f.at( 0);
        } else {
            if(!f.at( pageStopArray[i_pageNum - 1] ))
                qDebug("File positioned backward did not work");
        }
        QString s;
        Lview->clear();
        Rview->clear();
        QString insertString;
        for(int fd = 0; fd < pageSize ;fd++) {
            f.readLine(s, 256);
            if(useWrap)
                s.replace(QRegExp("\n"),"");
            currentLine++;
            insertString += s;
            Lview->insertLine( s, -1);
        }
        if(useSplitter) {
            for(int fd2 = 0; fd2 < pageSize ;fd2++) {
                f.readLine(s, 256);
                if(useWrap)
                    s.replace(QRegExp("\n"),"");
                currentLine++;
                insertString += s;
                Rview->insertLine( s, -1);
            }
        }
        if( !BackButton->autoRepeat() && !BackButton->isDown()) {
            QString topR;
            QString lastR;
            QString pageR;
            if( i_pageNum < 1)
                i_pageNum = 1;
            //            setCaption(QString::number(i_pageNum));
        } else {
            Lview->MultiLine_Ex::pageUp( false);
            if( i_pageNum < 1)
                i_pageNum = 1;
            setStatus();
        }
    }
    Lview->setFocus();
}

bool Gutenbrowser::UnZipIt(QString zipFile)
{
    if( QFile::exists( zipFile)) {      // TODO findsome other way of dealingwithzip files.
        bool isPgWhole=false;
        QString thatFile;
        if(zipFile.find("pgwhole",0,true)) {
            isPgWhole=true;
            thatFile= local_library +"/PGWHOLE.TXT";
        }
        //          else {
        //              thatFile=zipFile.left(4);
        //          }
        //      qDebug((const char*)local_library.latin1());
        QString cmd;
#if defined(Q_WS_X11_)

        if( chdir((const char*)local_library.latin1())!=0)
            qDebug("chdir failed.");
        cmd = "gunzip -S .zip " + local_library+zipFile;
        //cmd = "gunzip -d " + zipFile /*newestLibraryFile  */+" -d " + local_library;
#endif
#if defined(Q_WS_WIN)

        QString temp= QDir::convertSeparators(local_library);
        zipFile=QDir::convertSeparators( zipFile);
        cmd = temp+"unzip.exe -o " +zipFile/*newestLibraryFile  */+" -d " + temp;
#endif

        int exit=QMessageBox::information(this, "Ok to unzip?",
                                          "Ok to unnzip\n"+ zipFile+" ?",
                                          QMessageBox::Yes, QMessageBox::No);
        if (exit==QMessageBox::Yes) {
#if defined(Q_WS_X11_)//
            qDebug("Issuing the command "+cmd);
            system( cmd);
            if( QFile::exists(thatFile))
                remove
                    (thatFile);
            if(isPgWhole) {
                if( rename("pgwhole","PGWHOLE.TXT") !=0)
                    qDebug("rename failed");
            } else {
                if( rename(thatFile.left(4),thatFile.left(4)+".txt") !=0)
                    qDebug("rename failed");
            }
#endif
#if defined(Q_WS_WIN)
            qDebug("Issuing the command "+cmd);
            WinExec( cmd, SW_HIDE );
#endif
            //       remove( zipFile);
            return true;
        } else if(exit==QMessageBox::No) {
            //            qDebug("unzip");
            return false;
        }
    } else
        QMessageBox::message( "Note",( tr("Please install unzip in your PATH")) );
    return false;
}


/*
 Loads the selected exext into the view*/
bool Gutenbrowser::load( const char *fileName)
{
    qDebug("load %s", fileName);
    statusBar->message(IDS_STATUS_DEFAULT);
    QString o_file = fileName;

#if defined(Q_WS_WIN)

    if( o_file.find( "//", 0, true) != -1)
        o_file.replace( o_file.find( "//", 0, true) , 2, "/");
#else

    if( o_file.left(1) != "/") {
        o_file = local_library + o_file;
    }
#endif

    if (i_pageNum == 0) {
        i_pageNum = 1;
    }
    qDebug("trying to open " + o_file);

    if(f.isOpen())
        f.close();
    f.setName( o_file);

    if ( !f.open( IO_ReadOnly)) {
        QMessageBox::message( (tr("Note")) , (tr("<p>File not opened sucessfully. </p>" + o_file)) );
        return  false;
    }
    currentFilePos = 0;
    pageStopArray.resize(3);
    pageStopArray[0] = currentFilePos;

    fileHandle = f.handle();
    QString insertString;
    QTextStream t(&f);

    QString s, first, second;

    for(int fd = 0; fd < Lview->PageSize() ;fd++) {
        s = t.readLine();
        if(useWrap)
            s.replace(QRegExp("\n"),"");
        Lview->insertLine( s,-1);
        currentLine++;
    }
    if(useSplitter) {
        for(int fd2 = 0; fd2 < Rview->PageSize() ;fd2++) {
            s = t.readLine();
            if(useWrap)
                s.replace(QRegExp("\n"),"");
            Rview->insertLine( s,-1);
            currentLine++;
        }
    }
    currentFilePos = f.at();
    pageStopArray[1] = currentFilePos;

    setCaption(title);
    Lview->setAutoUpdate( true);

    //    if(useSplitter) {
    //        Rview->setText( s );
    //Rview->setAutoUpdate( true);
    //        Rview->setCursorPosition(0,1,false);
    //        Rview->MultiLine_Ex::pageDown(false);
    //        Rview->MultiLine_Ex::pageDown(false);
    //    }
    Lview->setCursorPosition(0,0,false);
    qDebug("numLines %d, editSize %d, pageSize %d",
           Lview->numLines(), Lview->editSize(), Lview->PageSize() );

    pages = (( Lview->numLines() / Lview->editSize() ) / 2 ) +1;

    status = title +(tr("  Page: "));

    setStatus();
    Lview->setCursor( arrowCursor);
    if(useSplitter)
        Rview->setCursor( arrowCursor);
    loadCheck = true;
    return false;
} // end load

/* searches opened etext for words*/
void Gutenbrowser::Search() {
    if(!searchDlg) {
        searchDlg = new SearchDialog( this, "Search", true);
        searchDlg->setCaption( tr( "Etext Search"  ) );
        searchDlg->setLabel( "searches etext.");
        connect( searchDlg,SIGNAL( search_signal()),this,SLOT( search_slot()));
        connect( searchDlg,SIGNAL( search_done_signal()),this,SLOT( searchdone_slot()));
    }
    QString resultString;
    //  // If we already searched /2replaced something before make sure it shows
    //  // up in the find dialog line-edit.
    //
    //searchDlg->getText();
    //  if(string.isEmpty())
    //  searchDlg->setText(pattern); //// FIXME
    QString string = searchDlg->searchString;
    Lview->deselect();
    //       QPoint point = Lview->mapToGlobal (QPoint (0,0));
    //     QRect pos = Lview->geometry();
    //          searchDlg->setGeometry( point.x() + pos.width()/2  -  searchDlg->width()/2,
    //                                  point.y() + pos.height()/2 -  searchDlg->height()/2,
    //                                  searchDlg->width(),
    //                                  searchDlg->height());

    searchDlg->show();
    searchDlg->result();
    AdjustStatus();
}

/*
  Starts the etext search work */
void Gutenbrowser::search_slot( )
{
    int line, col;
    if (!searchDlg /*&& !loadCheck */)
        return;
    Lview->getCursorPosition(&line,&col);
    QString to_find_string=searchDlg->get_text();

    // searchDlg->get_direction();// is true if searching backward
    if ( last_search != 0 && searchDlg->get_direction() ) {
        col = col  - pattern.length() - 1 ;
    }
again:
    int  result = doSearch( to_find_string , searchDlg->case_sensitive() , searchDlg->forward_search(), line, col);
    if(result == 0) {
        if(!searchDlg->get_direction()) { // forward search
            int query = QMessageBox::information( searchDlg, "Find",
                                                  "End of document reached.\nContinue from the beginning?",
                                                  "Yes", "No", "", 0,1);
            if (query == 0) {
                line = 0;
                col = 0;
                goto again;
            }
        } else { //backward search
            int query = QMessageBox::information( searchDlg, "Find",
                                                  "End of document reached.\nContinue from the beginning?",
                                                  "Yes", "No", "", 0,1);
            if (query == 0) {
                QString string = Lview->textLine( Lview->numLines() - 1 );
                line = Lview->numLines() - 1;
                lineCheck = line;
                col  = string.length();
                last_search = -1; //BACKWARD;
                goto again;
            }
        }
    } else {

        ////    emit CursorPositionChanged(); textLine
    }
}

/*
 Does the etext search work */
int Gutenbrowser::doSearch( QString s_pattern, bool case_sensitive,  bool forward, int line, int col )
{
    int i, length;
    int pos = -1;
    if(forward) {
        QString string;
        for(i = line; i < Lview->numLines(); i++) {
            string = Lview->textLine(i);
            pos = string.find(s_pattern, i == line ? col : 0, case_sensitive);
            if( pos != -1) {
                int top = Lview->Top();
                length = s_pattern.length();
                if( i > Lview->lastRow() ) {
                    Lview->setCursorPosition(i,pos,false);
                    for(int l = 0 ; l < length; l++) {
                        Lview->cursorRight(true);
                    }
                    Lview->setCursorPosition( i , pos + length, true );
                    int newTop = Lview->Top();
                    if(Lview->lastRow() > i)
                        Lview->ScrollUp( newTop - top);
                    AdjustStatus();
                } else {
                    Lview->setCursorPosition(i,pos,false);
                    for(int l = 0 ; l < length; l++) {
                        Lview->cursorRight(true);
                    }
                    Lview->setCursorPosition( i , pos + length, true );
                    AdjustStatus();
                }
                pattern = s_pattern;
                last_search = 1; //FORWARD;
                return 1;
            }
        }
    } else { //////////////// searching backwards
        QString string;
        for( i = line; i >= 0; i--) {
            string = Lview->textLine(i);
            int line_length = string.length();
            pos = string.findRev(s_pattern, line == i ? col : line_length , case_sensitive);
            if (pos != -1) {
                int top = Lview->Top();
                length = s_pattern.length();
                if( i <  Lview->Top() ) {
                    Lview->ScrollDown( Lview->PageSize() );
                    Lview->MultiLine_Ex::pageUp( false );
                    if( ! (line == i && pos > col ) ) {
                        Lview->setCursorPosition( i ,pos ,false );
                        for(int l = 0 ; l < length; l++) {
                            Lview->cursorRight(true);
                        }
                        Lview->setCursorPosition(i ,pos + length ,true );
                        int newTop = Lview->Top();
                        if(useSplitter)
                            Rview->ScrollUp( newTop - top);
                    }
                } else {
                    if( ! (line == i && pos > col ) ) {
                        Lview->setCursorPosition( i, pos, false );
                        for( int l = 0 ; l < length; l++) {
                            Lview->cursorRight( true);
                        }
                        Lview->setCursorPosition( i, pos + length, true );
                    }
                    pattern = s_pattern;
                    last_search = -1;
                    return 1;
                }
            }
        }
    }
    return 0;
}

void Gutenbrowser::LibraryBtn()
{
    setCursor(waitCursor);
    QString newestLibraryFile ="GUTINDEX.TXT";
    QString zipFile;
    //    qDebug("Local Library is %s ", local_library.latin1());
#if defined(Q_WS_X11_)
    zipFile ="/usr/bin/gunzip";
#endif
#if defined(Q_WS_WIN)
    zipFile = local_library+"unzip.exe";
#endif

    LibraryDialog* LibraryDlg;
    LibraryDlg = new LibraryDialog( this, "Library Index" /*, true */);
    if(useSplitter)
        LibraryDlg->useSmallInterface=false;
    if( LibraryDlg->exec() != 0 ) {
        listItemNumber = LibraryDlg->DlglistItemNumber;
        listItemFile =  LibraryDlg->DlglistItemFile;
        listItemYear = LibraryDlg->DlglistItemYear;
        listItemTitle = LibraryDlg->DlglistItemTitle;
        file_name = LibraryDlg->File_Name;
        title = listItemTitle;

        config->setGroup( "Proxy" );
        if( LibraryDlg->checked == 1) {
            config->writeEntry("IsChecked", "true");
        } else {
            config->writeEntry("IsChecked", "false");
        }
        config->write();

        if ( listItemNumber.isNull()) {
            setCursor(  arrowCursor);
        } else {
            setCursor(  arrowCursor);
            i_pageNum = 1;
            if( LibraryDlg->checkBox->isChecked()) {
                setTitle();
                load( file_name);
            } else {
                printf("Not opening the file.\n");
            }
        }
    }
    ///////////////////// ??????????????????
    //        if( LibraryDlg)
    //          delete LibraryDlg;
    setCursor(  arrowCursor);
}

void Gutenbrowser::OpenBtn()
{
    QString s_temp;
    s_temp = status;
    statusBar->message( tr("Opening File" ));
    statusBar->message(IDS_STATUS_DEFAULT);
    OpenEtext* OpenDlg;
    OpenDlg = new  OpenEtext(this,"OpenDlg");
    if( OpenDlg->exec() != 0) {
        title = OpenDlg->openFileTitle;
        file_name = OpenDlg->file;
        i_pageNum = 1;
        //        {
        //  if( file_name.find( local_library,0, true))
        //  file_name = local_library + file_name;
        setCursor( waitCursor );
        Lview->setCursor( waitCursor);
        if(useSplitter)
            Rview->setCursor( waitCursor);
        if( !file_name.isEmpty() || file_name.length() > 2 ) {
            load(file_name);
        }
        //        printf("Browser: "+brow+"\n");
        //        }
        //        else
        //        {
        // file presumable does not exist.
        //   printf( "Etext Error");
        // printf( file_name);
        // printf("\ndoes not exist.\n" );
        //       }
    }
    //    Rview->scrollBy(0 ,Rview->visibleHeight() );
    Lview->setCursor( arrowCursor);
    if(useSplitter)
        Rview->setCursor( arrowCursor);
    //    printf("Enjoy....\n");
    setCursor( arrowCursor);
    if( OpenDlg)
        delete OpenDlg;
    //    BeginBtn();
    AdjustStatus();
    //  setStatus();
}

void Gutenbrowser::ChangeFont()
{
    bool ok;

    weight = Lview->fontInfo().weight();
    italic = Lview->fontInfo().italic();
    bold = Lview->fontInfo().bold();
    pointSize = Lview->fontInfo().pointSize();
    fontStr = Lview->fontInfo().family();

    if(italic == true)
        italicStr = "true";
    else
        italicStr = "false";

    QFont currentfont( fontStr, pointSize, weight, italic );
    QFont font = QFontDialog::getFont( &ok ,currentfont, this);

    if (ok)  {
        QFontInfo fontInfo(font);
        fontStr = fontInfo.family();

        pointSize = fontInfo.pointSize();
        pointSizeStr.setNum( pointSize);
//        qWarning("pointSizeStr "+pointSizeStr);
        weight = fontInfo.weight();
        weightStr.setNum( weight);
        italic = fontInfo.italic();
        bold = fontInfo.bold();

        if(italic == true)
            italicStr = "true";
        else
            italicStr = "false";
        if(bold == true)
            boldStr = "true";
        else
            boldStr="false";

        pointSizeStr.setNum( pointSize);
        config->setGroup( "Font" );
        config->writeEntry("Family", fontStr );
        config->writeEntry("Size", pointSizeStr );
        config->writeEntry("Weight", weightStr );
        config->writeEntry("Italic", italicStr );
        config->writeEntry("Bold", boldStr );
        config->write();

        Lview->setFont(font);
        QRect lRect;
        QRect rRect;
        lRect = Lview->rect();
        if(useSplitter) {
            Rview->setFont(font);
            rRect = Rview->rect();
        }
        update();
        //  Lview->setFocus();
    }
}

/*goes to last set bookmark*/
bool Gutenbrowser::Bookmark()
{
    config->setGroup( "Bookmarks" );
    QString itemString, tempTitle, s_Bmrkrow, s_pageNum;
    int Bmrkrow = 0;
    int tmpPageNum = 0;
    int bookmarkPosition = 0;

    config->setGroup( "Bookmarks" );
    title = config->readEntry("Title", "");
    file_name = config->readEntry("File Name", "");
    i_pageNum = config->readNumEntry("Page Number", 0);
    tmpPageNum = i_pageNum;
    bookmarkPosition = config->readNumEntry( "PagePosition",0);
    Bmrkrow = config->readNumEntry("LineNumber",0);
    if( !file_name.contains("/")) {
        file_name = local_library + file_name;
    }

    qWarning("Page at %d, position %d", i_pageNum, bookmarkPosition);
    this->setFocus();

    if(!load(file_name))
        return false;

    i_pageNum = tmpPageNum;
    Lview->clear();
    int pageSize = Lview->PageSize();
    f.at(0);
    QString s;
    f.at( bookmarkPosition);

    for(int fd = 0; fd < pageSize - 1;fd++) {
        f.readLine(s, 256);
        if(useWrap)
            s.replace(QRegExp("\n"),"");
        Lview->insertLine( s, -1);
    }
    qWarning("Bookmark set");

    //     if(showMainList) {
    //         showMainList = false;
    //         mainList->hide();
    //         Lview->show();
    //     }

    pageStopArray.resize(i_pageNum);
    currentFilePos = bookmarkPosition;
    pageStopArray[i_pageNum ] = currentFilePos;

    qDebug("bookmark loaded");
    setCaption(title);

    /*
    	 QString s_pageNum = config->readEntry("Page Number", "0");
        QString s_Bmrkrow;
        s_Bmrkrow = config->readEntry("LineNumber","0");
        bool ok;
        int Bmrkrow=s_Bmrkrow.toInt( &ok, 10);
        i_pageNum=s_pageNum.toInt( &ok, 10);
     
        if( !file_name.contains("/")) {
            file_name = local_library + file_name;
        }
     
        getTitle(file_name);
        if(QFile(file_name).exists())
            load(file_name);
        if( Bmrkrow >  Lview->topRow() ) {
            //      //  if editview is smaller
            Lview->MultiLine_Ex::ScrollUp( Bmrkrow  -  Lview->topRow() );
        } else if( Bmrkrow <  Lview->topRow() ) {
            //      // if editview is larger
            Lview->MultiLine_Ex::ScrollDown( Lview->topRow() - Bmrkrow );
            AdjustStatus();
        }
    	 
    */

    AdjustStatus();
    return true;
}

void Gutenbrowser::setBookmark()
{
    if( ! loadCheck) {
        QMessageBox::message("Note","<p>File is not open.</p>");
        return;
    }
    //  bookMarksDlg* bookDlg;
    //        bookDlg = new  bookMarksDlg(this,"bookMarkDlg");
    //        if(bookDlg->exec() != 0)
    //        {
    //    }

    int  eexit = QMessageBox::information(this, "Note",
                                          "<P>Do you really want to set this bookmark?.</P>"
                                          ,QMessageBox::Yes, QMessageBox::No);
    if (eexit == 3) {


        if( file_name.contains(local_library) ) {
            QFileInfo f1( file_name);
            QString file = f1.fileName();
            file_name = file;
        }

        currentFilePos = f.at();

        config->setGroup("General");
        file_name = config->readEntry("Current","");
        qApp->processEvents();
        qDebug( "Setting book mark "+file_name);

        config->setGroup("Titles");
        title = config->readEntry(file_name,"");
        qDebug("title is "+ title);

        config->setGroup( "Bookmarks" );

        config->writeEntry("File Name",file_name);
        config->writeEntry("Page Number",QString::number(i_pageNum) );
        config->writeEntry( "PagePosition", QString::number( pageStopArray[i_pageNum - 1]));
        config->writeEntry("Title", title);

        int row =  Lview->topRow();// Lview->Top();
        config->writeEntry("LineNumber",QString::number(row) );

        config->setGroup(title);
        config->writeEntry("File Name",file_name);
        config->writeEntry( "LineNumber", QString::number( row));
        config->writeEntry( "PagePosition", QString::number( pageStopArray[i_pageNum - 1]));
        config->writeEntry( "Page Number", QString::number( i_pageNum) );
        config->write();
        bookmarksMenu->insertItem( title);
        config->write();
    }

    /*
        QString temp;
        temp.setNum(i_pageNum);
        config->setGroup( "Bookmarks" );
        config->writeEntry("File Name",file_name);
        config->writeEntry("Page Number",temp);
     
        int row =  Lview->topRow();// Lview->Top();
        QString numb;
        numb.setNum( row);
        config->writeEntry("LineNumber",numb);
    */
}

/*
performs dictionary look ups on the web */
void Gutenbrowser::LookupBtn()
{
    QString text;
    if( Lview->hasSelectedText()) {
        Lview->copy();
    } else if( useSplitter) {
        if(Rview->hasSelectedText())
            Rview->copy();
    }
    QClipboard *cb = QApplication::clipboard();
    text = cb->text();

    QString cmd; // using system(), until we have qprocess
    QString s_lookup = "http://www.m-w.com/cgi-bin/dictionary?" + text;
    // this link for sale!!
#if defined(Q_WS_WIN)

    goGetit( s_lookup, true);
#else

    if( brow == "Konq") {
        cmd = "konqueror "+s_lookup;
    }
#if defined(Q_WS_X11_)
    if ( brow == "Netscape") {
        QString str = QDir::homeDirPath() + "/.netscape/lock";
        //  struct stat *stat_p;
        //
        //  if ( -1 !=  lstat (str, stat_p))  { // if theres a lock file
        //      cmd = "netscape -remote 'openURL( "+s_lookup+" )'";
        //  }
        //  else {
        cmd = "netscape "+s_lookup;
    }

    if( brow =="Lynx") {
        cmd = "xterm -fg black -bg white -e lynx "+s_lookup;
        //    cmd = "lynx -source "+ s_lookup + " | cat >> ~/somefile.html";
    }
    if( brow == "Mozilla")  {
        cmd = "mozilla "+s_lookup;
    }
#endif
    if( brow == "Opera")  {
        cmd = "opera "+s_lookup;
    }
#ifdef Q_WS_QWS
    if( brow == "Nanozilla")  {
        cmd = "nanozilla "+s_lookup;
    }
#endif
    //// http://www.encyclopedia.com/home.html
    system(cmd);
#endif
}

void Gutenbrowser::ClearEdit()
{
    Lview->setText("");
    if(useSplitter)
        Rview->setText("");
    loadCheck = false;
    status = ( tr("Gutenbrowser"));
    InfoBar->setText( "");
    setCaption( tr("Gutenbrowser"));
    i_pageNum = 0;
    statusBar->message( status);
}


bool Gutenbrowser::getTitle( const char *file )
{
    QString s_file;
    QString filer = file;
    if( filer.contains(local_library, true))  {
        QFileInfo f(file);
        s_file =  f.fileName();
    } else {
        s_file = filer;
    }

    config->setGroup( "Files" );
    QString s_numofFiles = config->readEntry("NumberOfFiles", "0" );
    int  i_numofFiles = s_numofFiles.toInt();

    for (int i = 1; i <= i_numofFiles; i++) {
        QString temp;
        temp.setNum(i);
        QString ramble = config->readEntry(temp, "" );

        if( strcmp(ramble, s_file) == 0) {
            config->setGroup( "Titles" );
            title = config->readEntry(ramble, "");
        }
    }
    return true;
}

void Gutenbrowser::searchdone_slot()
{
    // if (!searchDlg)
    //   return;
    // searchDlg->hide();
    //    Lview->setFocus();
    this->setFocus();
    last_search = 0;
}

/*
sets the status message */
bool Gutenbrowser::setStatus()
{
    QString s_pages;

    //s_pages.setNum( ((Lview->numLines() / Lview->editSize() ) / 2 ) +1);

    QString chNum, statusTmp;
    statusTmp ="  Page: ";
    statusTmp.append(chNum.setNum(i_pageNum));
    //    statusTmp.append(" out of " + s_pages);
    status = statusTmp;

    if(loadCheck) {
        statusBar->message( status);
        InfoBar->setText( title);
    } else {}
    return true;
}

void Gutenbrowser::keyReleaseEvent( QKeyEvent *e)
{
    switch ( e->key() ) {

    case Key_M:
        Bookmark();
        break;
    case Key_D:
        DownloadIndex();
        break;
    case Key_L:
        LibraryBtn();
        break;
    case Key_O:
        OpenBtn();
        break;
    case Key_F:
        ForwardBtn();
        break;
    case Key_B:
        BackBtn();
        break;
    case Key_P:
        PrintBtn();
        break;
    case Key_S:
        SearchBtn();
        break;
    case Key_E:
        ByeBye();
        break;
    case Key_R:
        setBookmark();
        break;
    case Key_T:
        ChangeFont();
        break;
    case Key_C:
        ClearEdit();
        break;
    case Key_H:
        HelpBtn();
        break;
    case Key_K:
        LookupBtn();
        break;
    case Key_U:// hide menu
        if(menubar->isHidden() )
            menubar->show();
        else
            menubar->hide();
        break;

    case Key_I:
        hideButtons();
        break;

    case Key_Down:
        if( !e->isAutoRepeat() )
            AdjustStatus();
        break;
    case Key_Up:
        if( !e->isAutoRepeat() )
            AdjustStatus();
        break;
    case Key_Home:
        BeginBtn();
        break;
    case Key_F12:
        BeginBtn();
        break;
    case Key_Right: // move splitter here
        OpenBtn();
        //          moveSplitter(1);
        break;
    case Key_Left: // move splitter here
        LibraryBtn();
        //          moveSplitter(-1);
        break;
    };
}

void Gutenbrowser::keyPressEvent( QKeyEvent *e)
{
    switch ( e->key() ) {
    case Key_Next:
        ForwardBtn();
        break;
    case Key_Prior:
        BackBtn();
        break;
    case Key_Space:
        ForwardBtn();
        break;
    case Key_Down:
        Lview->MultiLine_Ex::ScrollUp( 1);
        if(useSplitter)
            Rview->MultiLine_Ex::ScrollUp( 1);
        break;
    case Key_Up:
        if( Lview->Top() != 0) {
            Lview->MultiLine_Ex::ScrollDown( 1);
            if(useSplitter)
                Rview->MultiLine_Ex::ScrollDown( 1);
        }
        break;
    }
}

void Gutenbrowser::resizeEvent( QResizeEvent *)
{

//    if(  loadCheck == true) {
//	qDebug("resize event");   
//	AdjustStatus();
//    }
}

/*
  adjusts the status bar to reflect new pages*/
void Gutenbrowser::AdjustStatus()
{//////////////////// TODO fix this for one view
    if(useSplitter) {
        int linesPerPage = Rview->lastRow() - Lview->topRow();
        if (0 == linesPerPage) // Avoid FPE crash
            linesPerPage = 1;
        pages = ((Lview->numLines() / Lview->PageSize() ) / 2 ) +1;
        if(linesPerPage > 0)
            i_pageNum = (( Lview->topRow() - 1) / linesPerPage) +1;
        if( i_pageNum < 1)
            i_pageNum = 1;
        status = title +(tr("  Page: "));
        setStatus();
        Rview->repaint( true);
    }
}

void Gutenbrowser::doOptions()
{
    optionsDialog* optDlg;
    optDlg = new optionsDialog( this,"Options_Dlg", true);
    if( optDlg->exec() !=0) {
        brow=optDlg->browserName;
        toggleButtonIcons( optDlg->useIcon);
        ftp_host= optDlg->ftp_host;
        ftp_base_dir= optDlg->ftp_base_dir;
        brow=optDlg->browserName;
        s_Wrap=optDlg->s_Wrap;
        if(s_Wrap=="true") {
            Lview->setWordWrap(QtMultiLineEdit::WidgetWidth);
            //          repaint(QRegion(0,0,240,320,QRegion::Rectangle),true);
        } else {
            Lview->setWordWrap(QtMultiLineEdit::NoWrap);
            //              if(loadCheck) {
            //                  int i_top= Lview->topRow();
            //                  load( file_name);
            //                  Lview->MultiLine_Ex::ScrollDown(i_top);
            //                  AdjustStatus();
            //              }
            //        repaint(QRegion(0,0,240,320,QRegion::Rectangle),true);
        }
        /*TODO:  need to save place, and reload etext so the scroll bar disappears when going
        from non word wrapped to word wrapped */

        /*        if(optDlg->styleChanged)
                    setStyle( optDlg->styleInt); */
        if(optDlg->b_qExit==true)
            b_queryExit=true;
        else
            b_queryExit=false;
    }

    // if(optDlg)
    //   delete optDlg;
}

/*
 Sets the correct title/name/filename
 of the etext, in the config file*/
bool Gutenbrowser::setTitle()
{
    if( file_name.contains( local_library)) {
        QFileInfo f( file_name);
        QString s_file =  f.fileName();
        file_name = s_file;
    }

    int test = 0;
    config->setGroup( "Files" );
    QString s_numofFiles = config->readEntry("NumberOfFiles", "0" );
    int  i_numofFiles = s_numofFiles.toInt();

    for (int i = 1; i <= i_numofFiles; i++) {
        QString temp;
        temp.setNum(i);
        QString ramble = config->readEntry(temp, "" );

        if( strcmp(ramble, file_name) == 0) {
            test = 1;
        }
    }
    if (test == 0) {
        config->writeEntry("NumberOfFiles",i_numofFiles +1 );
        QString interger;
        interger.setNum( i_numofFiles +1);
        config->writeEntry(interger, file_name);

        config->setGroup( "Titles" );
        config->writeEntry(file_name,listItemTitle);
    }
    test = 0;
    config->write();
    return true;
}

/*
  This scrolls the etext past the intro stuff,
   directly to the start of the book. */
void Gutenbrowser::BeginBtn()
{
    if( ! loadCheck) {
        QMessageBox::message("Note","<p>File is not open.</p>");
        return;
    }
    i_pageNum = 1;
    currentLine = 0;
    QString s_pattern="*END*THE SMALL PRINT";
    QString sPattern2 = "*END THE SMALL PRINT";

    int pageSize = Lview->PageSize();
    Lview->clear();

    //    int lines = Lview->numLines();
    int pos = 0;//, i = 0;
    int i_topRow = Lview->topRow();

    QString LeftText;// = Lview->text();

    //		int linesPerPage = Lview->lastRow() - Lview->topRow();
    //    int pages = (( linesPerPage / Lview->editSize() ) ) +1;
    //    int pageN = 0;
    i_pageNum = 1;
    int lastPage=1;
    int lineNo=0;
    QString s;
    f.at( 0);

    while ( !f.atEnd() ) {
        f.readLine(s, 256);
        lineNo++;
        LeftText = s;
        currentFilePos = f.at();

        i_pageNum = lineNo/pageSize;
        if(lastPage < i_pageNum) {
            pageStopArray.resize(i_pageNum + 1);
            pageStopArray[i_pageNum ] = currentFilePos;
//            qDebug("<<<<<< FOUND IT!! new page number %d , found at %d",
//                   i_pageNum, currentFilePos );
        }
        //         lastPage =  i_pageNum;
        if(  LeftText.find( s_pattern, 0 , true) != -1 || LeftText.find( sPattern2, 0 , true) != -1 ) {
//            qDebug("<<<<<< FOUND IT!! new page number %d , found at %d",
//                   i_pageNum, currentFilePos );
            break;
        }
    }
    if(f.atEnd()) //in case we didnt find anything, we need to show something
        f.at(0);
    Lview->clear();
    Rview->clear();
    for(int fd=0; fd < pageSize - 1;fd++) {
        f.readLine(s, 256);
        if(useWrap)
            s.replace(QRegExp("\n"),"");
        Lview->insertLine( s, -1);
        currentLine++;
    }
    if(useSplitter) {
        for(int fd2 = 0; fd2 < pageSize - 1;fd2++) {
            f.readLine(s, 256);
            if(useWrap)
                s.replace(QRegExp("\n"),"");
            Rview->insertLine( s, -1);
            currentLine++;
        }
    }

    //  i_pageNum = lineNo/pageSize;
    pageStopArray.resize(i_pageNum + 1);
    //    int length = Lview->length();

    qApp->processEvents();

    if( pos > i_topRow ) {
        //    Lview->setCursorPosition( pos+linesPerPage+2/* - i_topRow+3 */,0, false);
    } else {
        //    Lview->setCursorPosition( pos+2 , 0, false );
    }

    Lview->deselect();
    //    AdjustStatus();
    Lview->setFocus();


    /*
    	 i_pageNum = 1;
        status= title + ( tr("  :page "));
        QString s_pattern="*END*";
        //    int i;//, col =0;
        int line=0;
        int pos, i;
        int i_topRow = Lview->topRow();
        QString LeftText;// = Lview->text();
        for(i=line; i < Lview->numLines(); i++) {
            LeftText = Lview->textLine(i);
            pos = LeftText.find( s_pattern, 0 , true);
            if( pos != -1) {
                if( i > i_topRow ) {
                    Lview->MultiLine_Ex::ScrollUp( (i-i_topRow)+1);
                } else {
                    Lview->MultiLine_Ex::ScrollDown( (i_topRow-i)-1);
                }
            }
        }
    	 
    	 */
    AdjustStatus();
}

/*Calls new fangled network dialog */
void Gutenbrowser::OnNetworkDialog( QString networkUrl, QString output)
{
   NetworkDialog *NetworkDlg;
   if( networkUrl.length() < 4 )
      networkUrl= "http://sailor.gutenberg.org/mirror.sites.html";

   QStringList networkList;
   networkList.append((const char *)networkUrl); //host
   networkList.append("/"); //ftp base directory
   networkList.append((const char *)output); //output filepath
   networkList.append("MIRRORS.ALL"); //filename

   NetworkDlg = new NetworkDialog( this,"Network Protocol Dialog", true, 0, networkList);
   if( NetworkDlg->exec() != 0 ) {}
   if(NetworkDlg)
      delete NetworkDlg;
}

void Gutenbrowser::moveSplitter(  int pos )
{
    //int jargon;
    //typedef QValueList<jargon> splitterPos;
    //
    if (pos < 0 ) {//is negative, so we want to move the splitter left
        QValueList<int> jargon;
        QValueList<int> jargon2;
        jargon= splitter->sizes();
        //int count= jargon.count();
        QString cheese;
        //  QValueListIterator::Iterator it;

        //    jargon2.append( end );
        //    jargon2.append( begin);
        //
        //    for(int i=0; i<2;i++) {
        //
        //for( it = jargon.begin(); it != jargon.end(); ++it ) {
        //   cheese.sprintf( "%d\n",  jargon.begin() );
        //             QMessageBox::message("Note", cheese);
        //             cheese.sprintf( "%d\n",  jargon.end() );
        //             QMessageBox::message("Note", cheese);
        //           QSplitter::moveSplitter(120,splitter->idAfter(Lview));
        //           //splitter.idAfter(QWidget*w)
        //                       Lview
        //}
        // splitter->setSizes( jargon2);
    }
    //int jcount = jargon.count();


    //uintQValueList::count()

    //   }
    /// else { // is positive, so we want to move the splitter right

    /*
       _itemListWidth=_itemList->width();
        QValueList<int> sizes;
        sizes.append(_mainWidget->width());
        _itemList->hide();
        move(x()+_itemListWidth,y());
        resize(width()-_itemListWidth, height());
        _splitter->setSizes(sizes);
     */
    //        }

}


void Gutenbrowser::writeConfig()
{
    config->read();
    config->setGroup( "Geometry" );
    QString s;
    QString globalPosition;
    QPoint point;
    point = mapToGlobal(QPoint(0,0) );
    int posiX, posiY;
    posiX = point.x();
    posiY = point.y();
    globalPosition.sprintf("%i,%i", posiX, posiY);

    QRect frameRect;
    frameRect = geometry();
    s.sprintf("%i,%i", frameRect.width(), frameRect.height());
    config->writeEntry("Frame", s);
    config->writeEntry("Position", globalPosition);

    if( useIcons==true)
        config->writeEntry("Icons", "true");
    else
        config->writeEntry("Icons", "false");
    config->setGroup( "FTPsite" );  // ftp server config
    if(ftp_host.find( "SiteName",0,true) !=-1) {
        ftp_host="sailor.gutenberg.org";
        ftp_base_dir= "/pub/gutenberg";
    }

    config->writeEntry("SiteName", ftp_host);
    config->writeEntry("base", ftp_base_dir);

    config->setGroup( "Browser" );

    if(brow.length() > 2)
        config->writeEntry("Preferred", brow);


    //  config->setGroup( "Proxy" ); // use ftp/http config
    //  if( config->readEntry("IsChecked", "false") == "true")
    //    {
    //    Http_CheckBox->setChecked( true);
    //    Ftp_CheckBox->setChecked( false);
    //    }
    //    else
    //    {
    //    Http_CheckBox->setChecked( false);
    //    Ftp_CheckBox->setChecked( true);
    //    }

    /////////// fonts
    weight= Lview->fontInfo().weight();
    italic = Lview->fontInfo().italic();
    bold=Lview->fontInfo().bold();
    pointSize= Lview->fontInfo().pointSize();
    fontStr=Lview->fontInfo().family();

    if(italic == true)
        italicStr = "true";
    else
        italicStr = "false";
    if(bold == true)
        boldStr = "true";
    else
        boldStr = "false";

    pointSizeStr.setNum( pointSize);
    weightStr.setNum( weight);
    config->setGroup( "Font" );
    config->writeEntry("Family", fontStr );
    config->writeEntry("Size", pointSizeStr );
    config->writeEntry("Weight", weightStr );
    config->writeEntry("Italic", italicStr );
    config->writeEntry("Bold", boldStr );
    config->write();
}

void Gutenbrowser::annotations()
{
    QMessageBox::message("Note","hi annotate");
    lastBmkButton->setDown(false);
}

void Gutenbrowser::hideButtons()
{

    if( !buttonsHidden) {
        buttonsHidden=true;
        LibraryButton->hide();
        SearchButton->hide();
        InfoBar->hide();
        OpenButton->hide();
        BackButton->hide();
        ForwardButton->hide();
        setBookmarkButton->hide();
        lastBmkButton->hide();
        dictionaryButton->hide();
        if(useSplitter) {
            ClearButton->hide();
            PrintButton->hide();
            beginButton->hide();
            HelpButton->hide();
            FontButton->hide();
            OptionsButton->hide();
        }
    } else {
        buttonsHidden=false;

        LibraryButton->show();
        SearchButton->show();
        InfoBar->show();
        OpenButton->show();
        BackButton->show();
        ForwardButton->show();
        setBookmarkButton->show();
        lastBmkButton->show();
        dictionaryButton->show();
        if(useSplitter) {
            ClearButton->show();
            PrintButton->show();
            beginButton->show();
            HelpButton->show();
            FontButton->show();
            OptionsButton->show();
        }
    }
}


/*!
    \fn Gutenbrowser::TopBtn()
 scrolls text to the very top = 0
 
 */
void Gutenbrowser::TopBtn()
{
    if( ! loadCheck) {
        QMessageBox::message("Note","<p>File is not open.</p>");
        return;
    }
    if( i_pageNum != 0) {
        qDebug("top");
        qApp->processEvents();
        currentLine = 0;
        i_pageNum = 1;
        int pageSize = Lview->PageSize() ;
        Lview->clear();
        if(useSplitter )
            Rview->clear();
        QString s;
        f.at(0);
        for(int fd=0; fd < pageSize ;fd++) {
            f.readLine(s, 256);
            if(useWrap)
                s.replace(QRegExp("\n"),"");
            Lview->insertLine(s ,-1);
            currentLine++;
        }
        if(useSplitter ) {
            for(int fd2 = 0; fd2 <  pageSize ;fd2++) {
                f.readLine(s, 256);
                if(useWrap)
                    s.replace(QRegExp("\n"),"");
                Rview->insertLine(s ,-1);
                currentLine++;
            }

        }
        Lview->setCursorPosition( 0,0, false);
        i_pageNum = 1;
        setStatus();
    }
    Lview->setFocus();

}
