/***************************************************************************
                          NetworkDialog.cpp  -  description
                             -------------------
    begin                : Sun Aug 27 2000
    copyright            : (C) 2000 by llornkcor
    email                : ljp@llornkcor.com
 ***************************************************************************/
/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
// half-assed attempt at providing a network dialog.
/* Created: Sun Aug 27 15:24:52 2000*/
#include "NetworkDialog.h"
#include "gutenbrowser.h"
#include "http.h"
//#include <qhttp.h>

#if defined(_WS_X11_)
#include <unistd.h>
#endif

#include <qvaluelist.h>
#include <qapplication.h>
#include <qnetwork.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qlabel.h>
#include <qprogressbar.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qurl.h>
#include <qurloperator.h>
// :)~
NetworkDialog::NetworkDialog( QWidget* parent,  const char* name, bool modal, WFlags fl, const QStringList netL)
// NetworkDialog::NetworkDialog( QWidget* parent,  const char* name, bool modal,
//                               WFlags fl, const QString & UrlStr, const QString & fileStr, const QString & psrtialFile)
        : QDialog( parent, name, modal, fl )
{
#ifdef Q_WS_QWS
        resize(240,208);
#else
    resize(500,208); 
#endif 
#if defined(_WS_WIN_)
  this->setIcon(QPixmap(local_library+"pix/gutenbrowser.png"));
#endif
#if defined(_WS_X11_)
    this->setIcon(QPixmap("/usr/share/gutenbrowser/pix/gutenbrowser.png"));
#endif
#ifdef Q_WS_QWS
    QString local_library = (QDir::homeDirPath ()) +"/gutenbrowser/";
#else
    QString local_library = (QDir::homeDirPath ()) +"/.gutenbrowser/";
#endif    

    this->setUpdatesEnabled(true);

  	ftp_host = netL[0];
    networkUrl = strUrl = netL[0];
    dir = ftp_base_dir = netL[1];
    localFileName = netL[2];
    s_partialFileName = netL[3];

    if (netL.count() > 4)
       newstyletext = true;
    
    if( networkUrl.find("ftp",0,false)== -1 ) {
       if ( !name )
            setName( "HTTP NetworkDialog" );
        setCaption( tr( "HTTP Network Download Dialog"  ) );
//      qInitNetworkProtocols();  // registers ftp protocol // for now
        //      QNetworkProtocol::registerNetworkProtocol( "http", new QNetworkProtocolFactory<Http> );

    } else {
        if ( !name )
            setName( "FTP NetworkDialog" );
        setCaption( tr( "FTP Network Download Dialog"  ) );
    }
    
//    localFileName = fileStr;
//    s_partialFileName = psrtialFile;
    initDialog(); //opens file to be written
 {
// if new data comes in, do something with it
     connect( &op, SIGNAL(data( const QByteArray &, QNetworkOperation*)),this, SLOT(newData(const QByteArray&)));
     connect( &op, SIGNAL(finished(QNetworkOperation*)),this, SLOT(fileFinished()));
     connect( &op, SIGNAL(dataTransferProgress(int,int,QNetworkOperation*)),this,SLOT(transfering(int,int,QNetworkOperation*)));
     connect( &op, SIGNAL(newChildren(const QValueList<QUrlInfo>&,QNetworkOperation*)),this,SLOT(slotDirectoryList(const QValueList<QUrlInfo>&,QNetworkOperation*)));
     connect( &op, SIGNAL(start(QNetworkOperation*)),this,SLOT(slotStart(QNetworkOperation*)));
     connect( &op, SIGNAL(finished(QNetworkOperation*)),this,SLOT(slotFinished(QNetworkOperation*)));

     setCursor( waitCursor );
     QString loginStr;
     loginStr = "gutenbrowser";
     op.setUser( "anonymous");
     op.setPassword( loginStr + "@llornkcor.com" );

     if ( !strUrl.isEmpty() )   {
         if( strUrl.find( "/",  strUrl.length()-1, TRUE)!=-1  &&  strUrl.find("ftp://",0, TRUE) != -1) {
             buttonOk->setDisabled( TRUE);
             TextLabel1->setText( tr( "List remote dir: " + networkUrl  ) );
//    TextLabel2->setText( tr( "local file to download into: " +localFileName ) );

             ListDir( strUrl);
         } else
             downloadFile( strUrl);
     }
 }
}

NetworkDialog::~NetworkDialog() {

}

void NetworkDialog::initDialog() {

    totalBytesDownloaded=0;
    warnLabel = new QLabel( this, "TextLabel" );
    warnLabel ->setText( tr( "Please wait...." ) );
    TextLabel1 = new QLabel( this, "TextLabel1" );
    TextLabel2 = new QLabel( this, "TextLabel2" );
    TextLabel3 = new QLabel( this, "TextLabel3" );
    TextLabel3->setText( tr( "") );
    QWidget* Layout1 = new QWidget( this, "Layout1" );

    hbox = new QHBoxLayout(Layout1);
//    hbox->setSpacing(1);
    hbox->setMargin(4);
    buttonHelp = new QPushButton( Layout1, "buttonHelp" );
    buttonHelp->setText( tr( "&Help"  ) );
    buttonHelp->setAutoDefault( TRUE );
    hbox->addWidget(buttonHelp,0,AlignLeft );

#ifndef Q_WS_QWS
    QSpacerItem* spacer = new QSpacerItem(2,20,QSizePolicy::Expanding, QSizePolicy::Expanding);
    hbox->addItem(spacer);
#endif
    hbox->addStretch(1);
    buttonOk = new QPushButton( Layout1, "buttonOk" );
    buttonOk->setText( tr( "&OK"  ) );
    hbox->addWidget(buttonOk,0,AlignRight);
    hbox->addSpacing(5);
    buttonCancel = new QPushButton( Layout1, "buttonCancel" );
    buttonCancel->setText( tr( "&Cancel"  ) );
    buttonCancel->setAutoDefault( TRUE );
    buttonCancel->setDefault( TRUE );
    hbox->addWidget(buttonCancel,0,AlignRight);

    ProgressBar1 = new QProgressBar( this, "ProgressBar1" );
    ProgressBar1->setProgress(0);

#ifdef Q_WS_QWS
    buttonHelp->setFixedSize(35,22);
    buttonOk->setFixedSize(35,22);
    buttonCancel->setFixedSize(35,22);
    warnLabel ->setGeometry( QRect( 5,10,50,30));
    TextLabel1->setGeometry( QRect( 5,31,230,30));
    TextLabel2->setGeometry( QRect( 5,62,230,30));
    TextLabel3->setGeometry( QRect( 5,90,230,30));
    Layout1->setGeometry( QRect( 1,170,235,30)); //TODO check these!!
    ProgressBar1->setGeometry( QRect( 5,130,235,23)); //TODO check these!!
#else
    warnLabel ->setGeometry( QRect( 10,10,150,30));
    TextLabel1->setGeometry( QRect( 10,31,500,30));
    TextLabel2->setGeometry( QRect( 10,62,500,30));
    TextLabel3->setGeometry( QRect( 10,90,500,30));
    Layout1->setGeometry( QRect(10,170,485,30));
    ProgressBar1->setGeometry( QRect(10,130,480,23));
#endif
//    ProgressBar1->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)7 ) );

// signals and slots connections
    connect(buttonOk,SIGNAL(clicked()),this,SLOT(accept()));
    connect(buttonCancel,SIGNAL(clicked()),this,SLOT(reject()));

    fiole.setName( localFileName);
    fileFound = false;
    fiole.open( IO_ReadWrite | IO_Truncate );
}

void NetworkDialog::ListDir( QString networkUrl )
{
 qDebug("Getting directory list from: %s",networkUrl.latin1());
 op = networkUrl;
    op.listChildren();
}

/*
downloads the file networkUrl */
bool NetworkDialog::downloadFile( QString networkUrl ) {
    setCursor( waitCursor );
    buttonOk->setDisabled( TRUE);
    ProgressBar1->setProgress ( 0);
#ifndef Q_WS_QWS
    TextLabel1->setText( tr( "Download: " + networkUrl  ) );
    TextLabel2->setText( tr( "into: " + localFileName ) );
#else
    TextLabel1->setText( tr( "Download: " + networkUrl.right(networkUrl.findRev("/",0,TRUE))));
    TextLabel2->setText( tr( "into: " + localFileName.right(localFileName.findRev("/",0,TRUE))));
    
#endif    
qDebug("Downloading from1:  %s", networkUrl.latin1());
qDebug("Into: %s",localFileName.latin1());

if( networkUrl.length() > 5) {
        op = networkUrl;        // download the data
        op.get();
        return true;
    }
    return false;
}

void NetworkDialog::slotStart( QNetworkOperation *) {

//    qDebug( "Start reading '%s'", op.toString().latin1() );
}

/* */
void NetworkDialog::slotFinished( QNetworkOperation * operation)
{
    QString debugger;
    if ( operation->state() == QNetworkProtocol::StFailed ) {
        debugger.sprintf( "Couldn't read '%s'\nFollowing error occurred:\n%s",
                          op.toString().latin1(), operation->protocolDetail().latin1() );
        QMessageBox::message("Note", debugger);
    }
      //  else
//        qDebug( "Finished reading '%s'", op.toString().latin1() );
}

/*
get a diirectory list on the remote*/
void NetworkDialog::slotDirectoryList(const QValueList<QUrlInfo> & info, QNetworkOperation *newOp ) {

    if(! newOp)
        return;
    QValueList<QUrlInfo>::ConstIterator it = info.begin();
    QString temp;
    for ( ; it != info.end(); ++it ) {
        const QUrlInfo &inf = *it;
        s_finally= temp.sprintf( "%s \t%d \t%s\n\n", /*op.path() */  inf.name().latin1(),inf.size(),inf.lastModified().toString().latin1());
        if( fiole.writeBlock( s_finally, qstrlen(s_finally)) == -1)
            QMessageBox::message("Note", "A serious write error occured");
    }
}

/*
file download is finished */
void NetworkDialog::fileFinished()
{
   qWarning("fileFinished()");
  buttonOk->setEnabled( TRUE);
    ok = true;
    TextLabel1->setText( tr( "Downloaded: " + networkUrl  ) );
    s_finally.setNum(fiole.size());
    TextLabel2->setText( tr( "local file: " + localFileName + " : " + s_finally + " bytes"  ) );
    fiole.close();
    if( fiole.size() > 2) {
        setCursor( arrowCursor);
// special case is here
        qWarning( s_partialFileName);
        
        if(!newstyletext)
        if( s_partialFileName.length() > 4 && !fileFound ) {
            if ( findFileName( s_partialFileName ) ) {
            }
        }
    }
    if( ok)
        accept();
}

/* handles the incoming data stream */
void NetworkDialog::newData( const QByteArray &ba ) {

    if( fiole.writeBlock( ba) == -1)
        QMessageBox::message("Error", "A serious write error occured");
}

void NetworkDialog::transfering(  int bytesDone, int bytesTotal,  QNetworkOperation *  operation ) {

   if( !operation)
        return;
    QString  s_bytesDone, s_bytesTotal;
    s_bytesTotal.setNum( bytesDone);
    s_bytesDone.setNum( bytesTotal);
    if( bytesTotal == -1)
        s_bytesTotal="Not Known";
    TextLabel1->setText( tr( "Downloading: " +networkUrl  ) );
    TextLabel2->setText( tr( "local file: " +localFileName+" : "+ s_bytesTotal+" bytes"  ) );
    ProgressBar1->setProgress( bytesDone);
  //    qDebug( "bytesDone: % sbytesTotal: %s",s_bytesTotal,s_bytesDone);
}

/*
finds a remote file, when only a partial filename is supplied */
bool NetworkDialog::findFileName( const QString & filenameToSearch) {
// special case
    QString local_library = (QDir::homeDirPath ()) +"/.gutenbrowser/";
    QString outputFile = local_library+".guten_temp"; // .guten_temp contains the directory listing TODO: move to memory
    QFile tmp( outputFile);
    QString s_size, s;
    if (tmp.open(IO_ReadOnly)) {
        QTextStream t( &tmp );   // use a text stream
        while ( !t.eof() )   {
            s = t.readLine();
            if (s.contains(filenameToSearch, FALSE)) { // the real file search
//                qDebug("Found:%s", filenameToSearch.latin1());
//              QString str = s.right( ( s.length()) - (s.find(NewlistItemFile, FALSE)) );
                int foundTab = s.find(" \t", 0, true) ;
                QString str = s.left( foundTab) ;
                s_size = s.mid( foundTab, s.find(" \t", 0, true) -2);
                bool ok;
                ProgressBar1->setTotalSteps( s_size.toInt( &ok, 10) );
                TextLabel3->setText( tr( "Size of file to download: " + s_size) );

                if (str.contains(".txt")) {
                    fileFound = true;
                    localFileName = str;

//                    qDebug("Gutenbrowser found the filename:"+str);
                    break;
                } else {
                    tmp.close();
                    QMessageBox::message("Note","warning... text file not found.");
//                    qDebug("Gutenbrowser DID NOT find the filename:"+str);
                    return false;
                }
            }  //end of while loop
        }
    } else {
        QMessageBox::message("Error ", outputFile+" could not be opened");
    }
      //if(tmp)
    tmp.close();

//////////////  got the file name, now download
    outputFile = local_library + localFileName;
    networkUrl += localFileName;
    localFileName = outputFile;
    fiole.setName( outputFile);
    if( fiole.open( IO_ReadWrite | IO_Truncate ) ) {
        ok = false;
        downloadFile( networkUrl);
        return true;
    }
    return false;
}
