/*
 * Common environment for most program functions
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#define APPNAME PACKAGE
#else
#warning No config.h found: using fallback values
#define APPNAME "missing appname"
#define VERSION "unknown"
#endif

#include "Environment.h"

#include <cstdio>
#include <cstdarg>
#include <cstdlib>

using namespace std;


static Environment* instance = 0;

void Environment::init(Environment* instance) throw ()
{
	::instance = instance;
}

Environment& Environment::get() throw ()
{
	if (!instance)
		instance = new Environment();
	return *instance;
}

// Initialize the environment with default values
Environment::Environment() throw ()
	: _iface("eth0"), _defprof("none"), _timeout(5), _init_timeout(3) {}

// vim:set ts=4 sw=4:
