using System;
using System.IO;

namespace gtwitter
{
	
	
	public class ReadInfo
	{
		public string[] name = {null, null, null, null, null, null, null, null, null, null, null, null};
		//public string[] time = {null, null, null, null, null, null, null, null, null, null, null, null};
		public string[] text = {null, null, null, null, null, null, null, null, null, null, null, null};
		public string[] image = {null, null, null, null, null, null, null, null, null, null, null, null};
		public string[] screenName = {null, null, null, null, null, null, null, null, null, null, null, null};
		public string[] relative_time = {null, null, null, null, null, null, null, null, null, null, null, null};
		public string[] location = {null, null, null, null, null, null, null, null, null, null, null, null};
		public string[] description = {null, null, null, null, null, null, null, null, null, null, null, null};
		public string[] url = {null, null, null, null, null, null, null, null, null, null, null, null};
		
		public string[] direct_text = {null, null, null, null, null, null, null, null, null, null, null, null};
		public string[] direct_screenName = {null, null, null, null, null, null, null, null, null, null, null, null};
		public string[] direct_relative_time = {null, null, null, null, null, null, null, null, null, null, null, null};

		public int statusCount = 0;
		public int direct_statusCount = 0;
		
		string activeFilename = "friendsXML";
		
		public ReadInfo()
		{
			
		}
		
		public bool ReadInfoNow()
		{
			
			try {

				int source = 0;
				source = (int) MainWindow.client.Get (MainWindow.SOURCE_KEY);
				
				if (source == 0) {
					
					activeFilename = "friendsXML";
					ReadData(activeFilename);
				}
				if (source == 1) {
					
					activeFilename = "publicXML";
					ReadData(activeFilename);
				}
				if (source == 2) {
					
					activeFilename = "directXML";
					ReadDirectData(activeFilename);
				}
				
				return true;
			}
			catch (Exception ex) {
				if (MainClass.debug) {
					Console.WriteLine("Read source from config exception: ReadInfo.cs - ReadInfoNow()");
					Console.WriteLine(ex.Message +  ex.StackTrace);
				}
				
				return false;
			}

		}
		
		public void ReadData(string filename)
		{
			try {
				
				string temp = "";
				statusCount = 0;
				int a = 0;
				bool textEnd = true;

				//read xml
				using (TextReader textread = File.OpenText(gtwitter.MainWindow.configDir + filename)) {
				//using (TextReader textread = File.OpenText("/home/ghaefb/friendsXML")) {

					while ( !temp.Trim().StartsWith("</statuses>") && statusCount < 12 ) {
						
						temp = textread.ReadLine();
						
						//counting entries
						if (temp.Trim().StartsWith("</status>")) {
							
							statusCount++;
							//Console.WriteLine(statusCount);
						}
						
						//get name
						if (temp.Trim().StartsWith("<name>")) {
							
							temp = temp.Remove(0, temp.IndexOf("<name>") + 6);
							temp = temp.Remove(temp.IndexOf("</name>"), 7);
							
							name[statusCount] = temp;
							//Console.WriteLine(temp);
						}
						
						//get text
						if (temp.Trim().StartsWith("<text>")) {
							
							textEnd = false;
							a = statusCount;
							temp = temp.Remove(0, temp.IndexOf("<text>") + 6);
							
							try {
								temp = temp.Remove(temp.IndexOf("</text>"), 7);
								textEnd = true;
							} catch (Exception) {}
							
							text[statusCount] = temp;
							//Console.WriteLine(temp);
						}//if text is in the next lines
						else if (temp.Trim().EndsWith("</text>") && a == statusCount) {
							textEnd = true;
							temp = temp.Remove(temp.IndexOf("</text>"), 7);
							text[statusCount] = text[statusCount]+ "\n" + temp;
						}
						else if (a == statusCount && !textEnd) {
							text[statusCount] = text[statusCount]+ "\n" + temp;
						}
						
						//get time
						if (temp.Trim().StartsWith("<created_at>")) {
							
							temp = temp.Remove(0, temp.IndexOf("<created_at>") + 12);
							temp = temp.Substring(0, temp.IndexOf("</created_at>"));
							
							//time[statusCount] = temp;
							//Console.WriteLine(temp);
							
							relative_time[statusCount] = RelativeTime(temp, statusCount);
						}
						
						//get image
						if (temp.Trim().StartsWith("<profile_image_url>")) {
							
							temp = temp.Remove(0, temp.IndexOf("<profile_image_url>") + 19);
							temp = temp.Remove(temp.IndexOf("</profile_image_url>"), 20);
							
							image[statusCount] = temp;
							//Console.WriteLine(temp);
						}
						
						//get screen name
						if (temp.Trim().StartsWith("<screen_name>")) {
							
							temp = temp.Remove(0, temp.IndexOf("<screen_name>") + 13);
							temp = temp.Remove(temp.IndexOf("</screen_name>"), 14);
							
							screenName[statusCount] = temp;
							//Console.WriteLine(temp);
						}
						
						//get location
						if (temp.Trim().StartsWith("<location>")) {
							
							temp = temp.Remove(0, temp.IndexOf("<location>") + 10);
							temp = temp.Remove(temp.IndexOf("</location>"), 11);
							
							location[statusCount] = temp;
							//Console.WriteLine(temp);
						}
						
						//get description
						if (temp.Trim().StartsWith("<description>")) {
							
							temp = temp.Remove(0, temp.IndexOf("<description>") + 13);
							temp = temp.Remove(temp.IndexOf("</description>"), 14);
							
							description[statusCount] = temp;
							//Console.WriteLine(temp);
						}
						
						//get url
						if (temp.Trim().StartsWith("<url>")) {
							
							temp = temp.Remove(0, temp.IndexOf("<url>") + 5);
							temp = temp.Remove(temp.IndexOf("</url>"), 6);
							
							url[statusCount] = temp;
							//Console.WriteLine(temp);
						}
						
						//Console.WriteLine(temp);
					}
				}
			}
			catch (Exception ex) {
				if (MainClass.debug) {
					Console.WriteLine("Read data exception: ReadInfo.cs - ReadData()");
					Console.WriteLine(ex.Message + ex.StackTrace);
				}	
			}
		}
		
		public void ReadDirectData(string filename)
		{
			try {
				
				string temp = "";
				direct_statusCount = 0;
			
				using (TextReader textread = File.OpenText(gtwitter.MainWindow.configDir + filename)) {

					while ( !temp.Trim().StartsWith("</direct-messages>") && direct_statusCount < 12 ) {
							
						temp = textread.ReadLine();
						
						//counting entries
						if (temp.Trim().StartsWith("</direct_message>")) {
							
							direct_statusCount++;
							//Console.WriteLine(statusCount);
						}
						
						//get text
						if (temp.Trim().StartsWith("<text>")) {
							
							temp = temp.Remove(0, temp.IndexOf("<text>") + 6);
							temp = temp.Remove(temp.IndexOf("</text>"), 7);
							
							direct_text[direct_statusCount] = temp;
							//Console.WriteLine(temp);
						}
						
						//get screen name
						if (temp.Trim().StartsWith("<sender_screen_name>")) {
							
							temp = temp.Remove(0, temp.IndexOf("<sender_screen_name>") + 20);
							temp = temp.Remove(temp.IndexOf("</sender_screen_name>"), 21);
							
							direct_screenName[direct_statusCount] = temp;
							//Console.WriteLine(temp);
						}
						
						//get time
						if (temp.Trim().StartsWith("<created_at>")) {
							
							temp = temp.Remove(0, temp.IndexOf("<created_at>") + 12);
							temp = temp.Substring(0, temp.IndexOf("</created_at>"));
							
							//Console.WriteLine(temp);
							direct_relative_time[direct_statusCount] = RelativeTime(temp, direct_statusCount);
						}
						
					}
				}
			
			}
			catch (Exception ex) {
				if (MainClass.debug) {
					Console.WriteLine("Read data exception: ReadInfo.cs - ReadDirectData()");
					Console.WriteLine(ex.Message + ex.StackTrace);
				}	
			}
		}
		
		public string RelativeTime(string time, int count)
		{
			// What we've got look like this
			// Tue Apr 03 19:07:06 +0000 2007
			
			// removing the day
			time = time.Substring(4);
			
			// fixing the months bug (shouldn't be present anymore)
			// http://bugzilla.ximian.com/show_bug.cgi?id=80094
			string[] months = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
		
			for(int i=0; i<months.Length; i++) {
				time = time.Replace(months[i], String.Format("{0:00}", i+1));
			}
			
			DateTime relativeTime = DateTime
				.ParseExact(time, "MM dd HH:mm:ss +0000 yyyy", null)
				.ToLocalTime();

			//substract relative time from current time
			TimeSpan diffTime = DateTime.Now.Subtract(relativeTime);
			
			int diff = (int) diffTime.TotalSeconds;
			
			if (diff < 60)
				return "less than a minute ago";
			else if (diff < 120)
				return "about a minute ago";
			else if (diff < (45*60))
				return String.Format("{0} minutes ago", diff/60);
			else if (diff < (120*60))
				return "about an hour ago";
			else if (diff < (24*60*60))
				return String.Format("about {0} hours ago", diff/3600);
			else if (diff < (48*60*60))
				return String.Format("1 day ago");
			else
				return String.Format("{0} days ago", diff/86400);
			 
		}
		
	}
}

//ghaefb
