
using System;
using System.Net;
using System.IO;
using System.Text;
using System.Web;
using System.Xml;

namespace gtwitter
{
	
	
	public class PostToTwitter
	{
		
		public PostToTwitter()
		{
		}
		
		//posting to twitter
		public bool PostDataToTwitter(string TwitterPostUrl, string TwitterName, string TwitterPass, string post)
		{		
			if (MainWindow.directM)
				post = "D " + MainWindow.screenName + " " + post;
			
			//Console.WriteLine(post);
			post = HttpUtility.UrlEncode(post);
			HttpWebRequest request = GeneratePostRequest(TwitterPostUrl, "POST", string.Format("status={0}", post), TwitterName, TwitterPass);
			string returnString = string.Empty;			
			HttpWebResponse response = null;

			try
			{
				response = (HttpWebResponse)request.GetResponse();
				Stream responseStream = response.GetResponseStream();
				StreamReader reader = new StreamReader(responseStream,Encoding.UTF8);

				try
				{
					returnString = reader.ReadToEnd();
				}
				catch (Exception ex)
				{
					if (MainClass.debug) {
						Console.WriteLine("Post to twitter 'return string' exception: PostToTwitter.cs - PostDataToTwitter()");
						Console.WriteLine(ex.StackTrace);
					}
					return false;
				}
				finally
				{
					if (reader != null)
						reader.Close();
				}
				returnString.Trim();
			}
			catch (Exception ex)
			{
				if (MainClass.debug) {
					Console.WriteLine("Post to twitter 'web request' exception: PostToTwitter.cs - PostDataToTwitter()");
					Console.WriteLine(ex.StackTrace);
				}
				return false;
			}
			finally
			{
				if (response != null)
					response.Close();
			}

			return true;
		}
		
		public static HttpWebRequest GeneratePostRequest(string uriString, string method, string postData, string user, string pass)
	    {
			HttpWebRequest httpRequest = (HttpWebRequest)WebRequest.Create(uriString);
			httpRequest.Method = method;

			if (method.ToUpper() =="POST")
			{
				if ( (user != null) && (pass != null) )
				{
					httpRequest.Credentials = new NetworkCredential(user, pass);
				}

				byte[] bytes = Encoding.UTF8.GetBytes(postData);
				httpRequest.ContentType = "application/x-www-form-urlencoded";

				httpRequest.ContentLength = bytes.Length;

				Stream requestStream = httpRequest.GetRequestStream();
				requestStream.Write(bytes,0,bytes.Length);
				
				requestStream.Close();
			}
	            
			return httpRequest;
	    }
	}
}

//ghaefb