// project created on 3/4/2007 at 10:19 AM
// Author: Nil Gradisnik: ghaefb@gmail.com
// Project page: http://code.google.com/p/gtwitter

using System;
using Gtk;
using GConf;

namespace gtwitter
{
	class MainClass
	{
		public const string version = "1.0beta";
		public static bool composite = false;
		public static bool debug = false;
	      
		static MainWindow win;

		public static void Main (string[] args)
		{
		    
			try {
			       
				if (args[0] == "--composite") {
				     
					composite = true;
					MainWindowInit();
				}
				else if (args[0] == "--debug" || args[0] == "-d") {
				     
					debug = true;
					MainWindowInit();
				}
				else if (args[0] == "--version" || args[0] == "-v") {
					
				     Console.WriteLine("gTwitter {0}", version);
				}
				else if (args[0] == "--help" || args[0] == "-h") {
					
				     Usage();                                        
				}
				else if (args[0] == "--tweet" || args[0] == "-t") {
					
					if (args.Length > 1) {
						
						PostToTwitter postToTwitter = new PostToTwitter();
						GConf.Client client = new GConf.Client();
						string username = (string) client.Get (MainWindow.USERNAME_KEY);
						string password = (string) client.Get (MainWindow.PASSWORD_KEY);
						if (postToTwitter.PostDataToTwitter("http://twitter.com/statuses/update.xml", username, password, args[1])) {
							Console.WriteLine("Successfully Posted!");
						} else {
							Console.WriteLine("Posting Failed");
						}
					} else {
						Console.WriteLine("Refusing to post an empty message...");
					}
				}
				else {
					Usage();        
				}

			}
			catch (IndexOutOfRangeException) {
			       
				MainWindowInit();
			}
		}

		public static void Usage()
		{

			Console.WriteLine("gTwitter {0}", version);
			Console.WriteLine("Usage: gtwitter [OPTION]...\n");

			//Console.WriteLine("  --composite | -c\tenable composite interface");
			Console.WriteLine("  -d, --debug\t\t\tprint debugging messages to stdout");
			Console.WriteLine("  -h, --help\t\t\tdisplay this help and exit");
			Console.WriteLine("  -t, --tweet \"message\"\t\tpost message to twitter and exit");
			Console.WriteLine("  -v, --version\t\t\tdisplay the current version and exit");
		}

		public static void MainWindowInit()
		{
			Application.Init ();
			win = new MainWindow ();

			if (composite) 
				win.ButtonPressEvent += OnWindowButtonPress;

			win.KeyPressEvent += OnWindowKeyPress;

			//hidden on startup
			try {
			    if ((bool) MainWindow.client.Get (MainWindow.HIDDEN_KEY)) {
			    	
			    	win.Hide ();
			    }
			}
			catch (NoSuchKeyException) {}

			Application.Run ();
		}

		//quit with q or escape key
		static void OnWindowKeyPress (object obj, Gtk.KeyPressEventArgs e)
		{
		    
			switch (e.Event.Key) {
			       
				case Gdk.Key.Escape :
					win.Hide();
					win.GetPosition(out MainWindow.x, out MainWindow.y);
				break;
			}

			e.RetVal = false;
		}

		//drag, resize events
		static void OnWindowButtonPress (object obj, Gtk.ButtonPressEventArgs e) {

			if (e.Event.Button == 1) {
			       
				win.BeginMoveDrag (1, (int) e.Event.XRoot, (int) e.Event.YRoot, e.Event.Time);
			}

			if (e.Event.Button == 3) {
			       
				win.BeginResizeDrag (Gdk.WindowEdge.SouthEast, 3, (int) e.Event.XRoot, (int) e.Event.YRoot, e.Event.Time);
			}

			e.RetVal = false;
		}
	      
	}
}

//ghaefb
