#!/bin/bash

echo "AUTOGEN.SH : `date`" > autogen.log

autogen_do () {
	echo -n "autogen.sh: \"${AUTOGEN_DO_CMD}\" -->  "
	echo -e "\n--> ${AUTOGEN_DO_CMD} <--" >> autogen.log 2>&1
	${AUTOGEN_DO_CMD} >> autogen.log 2>&1 && {
		echo -e "SUCCESS"
	} || {
		echo -e "\aFAILED! see autogen.log for details"
		exit -1
	}
}

AUTOGEN_DO_CMD=`which autoheader`
autogen_do

AUTOGEN_DO_CMD=`which aclocal`
autogen_do

AUTOGEN_DO_CMD=`which glib-gettextize`\ --force\ --copy
autogen_do

AUTOGEN_DO_CMD=`which intltoolize`\ --copy\ --force\ --automake
autogen_do

AUTOGEN_DO_CMD=`which libtoolize`\ -c
autogen_do

AUTOGEN_DO_CMD=`which automake`\ -ac
autogen_do

AUTOGEN_DO_CMD=`which autoconf`
autogen_do

AUTOGEN_DO_CMD="./configure ${*}"
autogen_do

echo -e "\n---\nautogen.sh completed successfully.\nNow either re-run ./configure with your desired arguments (if you didn't pass them to autogen)\nor make && make install as normal.\n"
