/* Copyright 2006 Fluendo S.L. 
 * Author: Jan Schmidt <jan@fluendo.com>
 * See the COPYING file in the top-level directory.
 */

#ifndef __FLUTSMUX_H__
#define __FLUTSMUX_H__

#include <gst/gst.h>
#include <gst/base/gstcollectpads.h>

G_BEGIN_DECLS

#include <tsmux/tsmux.h>

#define FLU_TYPE_TSMUX  (flutsmux_get_type())
#define FLU_TSMUX(obj)  (G_TYPE_CHECK_INSTANCE_CAST((obj), FLU_TYPE_TSMUX, FluTsMux))

typedef struct FluTsMux FluTsMux;
typedef struct FluTsMuxClass FluTsMuxClass;
typedef struct FluTsPadData FluTsPadData;

struct FluTsMux {
  GstElement parent;

  GstPad *srcpad;

  GstCollectPads *collect;

  TsMux *tsmux;
  TsMuxProgram *program;

  gboolean first;
  TsMuxStream *pcr_stream;
  GstFlowReturn last_flow_ret;
};

struct FluTsMuxClass  {
  GstElementClass parent_class;
};

struct FluTsPadData {
  GstCollectData collect; /* Parent */

  gint pid;
  TsMuxStream *stream;

  GstBuffer *queued_buf; /* Currently pulled buffer */
  GstClockTime cur_ts; /* Adjusted TS for the pulled buffer */
  GstClockTime last_ts; /* Most recent valid TS for this stream */

  gboolean eos;
};

GType flutsmux_get_type (void);

#define CLOCK_BASE 9LL
#define CLOCK_FREQ (CLOCK_BASE * 10000)

#define MPEGTIME_TO_GSTTIME(time) (gst_util_uint64_scale ((time), \
                        GST_MSECOND/10, CLOCK_BASE))
#define GSTTIME_TO_MPEGTIME(time) (gst_util_uint64_scale ((time), \
                        CLOCK_BASE, GST_MSECOND/10))

G_END_DECLS

#endif
