//*****************************************************************************
//                              CmdNgSpicePR.hpp                              *
//                             ------------------                             *
//  Description : This class contains values associated with the NG-Spice     *
//                AC command. It inherits from the class CmdBase.             *
//  Started     : 16/10/2007                                                  *
//  Last Update : 18/10/2007                                                  *
//  Copyright   : (C) 2007 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CMDNGSPICEPR_HPP
#define CMDNGSPICEPR_HPP

// System Includes

#include <iostream>
#include <climits>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "TypeDefs.hpp"
#include "base/CmdBase.hpp"
#include "utility/ConvertType.hpp"

// Local Macro and Constant Declarations

//*****************************************************************************

class CmdNgSpicePR : public CmdBase
{
  protected :

    virtual  bool  bParse ( void );
    virtual  bool  bFormat( void );

  public :

    eAnaType       m_eAnaType;
    wxArrayString  m_osaNodes;
    wxArrayString  m_osaCpnts;
    bool           m_bParmtrs[ ePAR_LST+1 ];
    bool           m_bCpxPrts[ eCPX_LST+1 ];

    float       m_fStart;  // The sweep start value
    float       m_fStop;   // The sweep stop  value
    int         m_iStep;   // The sweep step  value
    eScaleType  m_eScale;  // The sweep scale type

              CmdNgSpicePR( void );
    virtual  ~CmdNgSpicePR( );

    bool  bClear( void );
};

//*****************************************************************************

#endif // CMDNGSPICEPR_HPP
