//*****************************************************************************
//                              CmdNgSpiceOPT.cpp                             *
//                             -------------------                            *
//  Started     : 23/08/2006                                                  *
//  Last Update : 16/10/2007                                                  *
//  Copyright   : (C) 2006 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "ngspice/commands/CmdNgSpiceOPT.hpp"

//*****************************************************************************
// Constructor.

CmdNgSpiceOPT::CmdNgSpiceOPT( void )
{
  bClear( );
}

//*****************************************************************************
// Destructor.

CmdNgSpiceOPT::~CmdNgSpiceOPT( )
{
}

//*****************************************************************************
// Parse the command string.
//
// Eg.s : .OPTIONS NOPAGE
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  CmdNgSpiceOPT::bParse( void )
{
  wxStringTokenizer  ostk1;
  wxString           os1, os2;
  size_t             sz1;
  long               li1;
  double             df1;

  // Tokenize the command string
  ostk1.SetString( *this );
  if( ostk1.CountTokens( ) < 2 ) return( FALSE );

  // Clear object attributes but keep the command string
  bClear( );
  *((wxString *) this) = ostk1.GetString( );

  // Check command type
  os1 = ostk1.GetNextToken( ).Left( 8 ).Upper( );
  if( os1 != wxT(".OPTIONS") )   return( FALSE );
  m_osName = wxT("OPTIONS");

  m_bIsOk = TRUE;

  // Extract each parameter value
  while( ostk1.HasMoreTokens( ) )
  {
    // Extract the field name and the associated value
    os1 = ostk1.GetNextToken( );
    os2 = wxT("");
    if( (sz1=os1.find( wxT("=") )) != wxString::npos )
    {
      os2 = os1.Right( os1.Length( )-sz1-1 );
      os1 = os1.Left( sz1 );
      ConvertType::bStrToInt( os2, &li1 );
      ConvertType::bStrToFlt( os2, &df1 );
    }

    // Set the display control value
    if(      os1 == wxT("ABSTOL")  ) m_fABSTOL  = (float) df1;
    else if( os1 == wxT("BADMOS3") ) m_bBADMOS3 = TRUE;
    else if( os1 == wxT("CHGTOL")  ) m_fCHGTOL  = (float) df1;
    else if( os1 == wxT("DEFAD")   ) m_fDEFAD   = (float) df1;
    else if( os1 == wxT("DEFAS")   ) m_fDEFAS   = (float) df1;
    else if( os1 == wxT("DEFL")    ) m_fDEFL    = (float) df1;
    else if( os1 == wxT("DEFW")    ) m_fDEFW    = (float) df1;
    else if( os1 == wxT("GMIN")    ) m_fGMIN    = (float) df1;
    else if( os1 == wxT("ITL1")    ) m_iITL1    = (int)   li1;
    else if( os1 == wxT("ITL2")    ) m_iITL2    = (int)   li1;
    else if( os1 == wxT("ITL4")    ) m_iITL4    = (int)   li1;
    else if( os1 == wxT("METHOD")  ) m_osMETHOD = os2;
    else if( os1 == wxT("PIVREL")  ) m_fPIVREL  = (float) df1;
    else if( os1 == wxT("PIVTOL")  ) m_fPIVTOL  = (float) df1;
    else if( os1 == wxT("RELTOL")  ) m_fRELTOL  = (float) df1;
    else if( os1 == wxT("TEMP")    ) m_fTEMP    = (float) df1;
    else if( os1 == wxT("TNOM")    ) m_fTNOM    = (float) df1;
    else if( os1 == wxT("TRTOL")   ) m_fTRTOL   = (float) df1;
    else if( os1 == wxT("VNTOL")   ) m_fVNTOL   = (float) df1;
    else m_bIsOk = FALSE;
  }

  m_bIsOk = TRUE;

  return( TRUE );
}

//*****************************************************************************
// Format the command string.
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  CmdNgSpiceOPT::bFormat( void )
{
  wxString  os1;

  m_bIsOk = FALSE;

  os1 = wxT(".OPTIONS NOPAGE");

  if( m_fABSTOL  != NG_ABSTOL )
    os1 << wxT(" ABSTOL=") << wxString::Format( wxT("%.2E"), m_fABSTOL );
  if( m_bBADMOS3 != NG_BADMOS3 )
    os1 << wxT(" BADMOS3");
  if( m_fCHGTOL  != NG_CHGTOL )
    os1 << wxT(" CHGTOL=") << wxString::Format( wxT("%.2E"), m_fCHGTOL );
  if( m_fDEFAD   != NG_DEFAD )
    os1 << wxT(" DEFAD=")  << wxString::Format( wxT("%.2E"), m_fDEFAD );
  if( m_fDEFAS   != NG_DEFAS )
    os1 << wxT(" DEFAS=")  << wxString::Format( wxT("%.2E"), m_fDEFAS );
  if( m_fDEFL    != NG_DEFL )
    os1 << wxT(" DEFL=")   << wxString::Format( wxT("%.2E"), m_fDEFL );
  if( m_fDEFW    != NG_DEFW )
    os1 << wxT(" DEFW=")   << wxString::Format( wxT("%.2E"), m_fDEFW );
  if( m_fGMIN    != NG_GMIN )
    os1 << wxT(" GMIN=")   << wxString::Format( wxT("%.2E"), m_fGMIN );
  if( m_iITL1    != NG_ITL1 )
    os1 << wxT(" ITL1=")   << m_iITL1;
  if( m_iITL2    != NG_ITL2 )
    os1 << wxT(" ITL2=")   << m_iITL2;
  if( m_iITL4    != NG_ITL4 )
    os1 << wxT(" ITL4=")   << m_iITL4;
  if( m_osMETHOD != NG_METHOD )
    os1 << wxT(" METHOD=") << m_osMETHOD.Upper( );
  if( m_fPIVREL  != NG_PIVREL )
    os1 << wxT(" PIVREL=") << wxString::Format( wxT("%.4f"), m_fPIVREL );
  if( m_fPIVTOL  != NG_PIVTOL )
    os1 << wxT(" PIVTOL=") << wxString::Format( wxT("%.2E"), m_fPIVTOL );
  if( m_fRELTOL  != NG_RELTOL )
    os1 << wxT(" RELTOL=") << wxString::Format( wxT("%.4f"), m_fRELTOL );
  if( m_fTEMP    != NG_TEMP )
    os1 << wxT(" TEMP=")   << wxString::Format( wxT("%.2f"), m_fTEMP );
  if( m_fTNOM    != NG_TNOM )
    os1 << wxT(" TNOM=")   << wxString::Format( wxT("%.2f"), m_fTNOM );
  if( m_fTRTOL   != NG_TRTOL )
    os1 << wxT(" TRTOL=")  << wxString::Format( wxT("%.2E"), m_fTRTOL );
  if( m_fVNTOL   != NG_VNTOL )
    os1 << wxT(" VNTOL=")  << wxString::Format( wxT("%.2E"), m_fVNTOL );

  m_bIsOk = TRUE;
  *((wxString *) this) = os1;

  return( TRUE );
}

//*****************************************************************************
// Clear the object attributes.
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  CmdNgSpiceOPT::bClear( void )
{
  CmdBase::bClear( );

  m_fABSTOL  = NG_ABSTOL;
  m_bBADMOS3 = NG_BADMOS3;
  m_fCHGTOL  = NG_CHGTOL;
  m_fDEFAD   = NG_DEFAD;
  m_fDEFAS   = NG_DEFAS;
  m_fDEFL    = NG_DEFL;
  m_fDEFW    = NG_DEFW;
  m_fGMIN    = NG_GMIN;
  m_iITL1    = NG_ITL1;
  m_iITL2    = NG_ITL2;
  m_iITL4    = NG_ITL4;
  m_osMETHOD = NG_METHOD;
  m_fPIVREL  = NG_PIVREL;
  m_fPIVTOL  = NG_PIVTOL;
  m_fRELTOL  = NG_RELTOL;
  m_fTEMP    = NG_TEMP;
  m_fTNOM    = NG_TNOM;
  m_fTRTOL   = NG_TRTOL;
  m_fVNTOL   = NG_VNTOL;

  return( TRUE );
}

//*****************************************************************************
