//*****************************************************************************
//                                HelpTasks.cpp                               *
//                               ---------------                              *
//  Started     : 03/06/2005                                                  *
//  Last Update : 08/10/2007                                                  *
//  Copyright   : (C) 2005 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "main/HelpTasks.hpp"
#include "main/FrmMain.hpp"

// The application icon
#if defined( __WXGTK__ ) || defined( __WXMOTIF__ ) || defined( __WXMAC__ ) || \
    defined( __WXMGL__ ) || defined( __WXX11__ )
  #include "icons/gspiceui-32x32.xpm"
  #include "icons/html-close.xpm"
  #include "icons/html-back.xpm"
#endif

//*****************************************************************************
// Implement an event table in which the events are routed to their respective
// handler functions in the class. If -1 is given as the ID, the given handler
// will be invoked for any event of the specified type.

BEGIN_EVENT_TABLE( HelpTasks, wxFrame )

  EVT_TOOL( ID_TBR_BACK,  HelpTasks::OnBack  )
  EVT_TOOL( ID_TBR_CLOSE, HelpTasks::OnClose )

END_EVENT_TABLE( )

//*****************************************************************************
// Constructor.
//
// Argument List:
//   poFrmMain - A pointer to the parent frame

HelpTasks::HelpTasks( FrmMain * poFrmMain ) :
                  wxFrame( poFrmMain, -1, wxT(""), wxDefaultPosition,
                           wxDefaultSize, wxDEFAULT_FRAME_STYLE&~wxCLOSE_BOX ),
                  m_oHtmlWin( this )
{
  // Set the pointer to the parent frame
  m_poFrmMain = poFrmMain;

  // Get the global configuration object
  m_poConfig = (wxConfig *) wxConfig::Get( );

  // Initialize the help viewer
  Initialize( );
}

//*****************************************************************************
// Destructor.

HelpTasks::~HelpTasks( )
{
}

//*****************************************************************************
// Initialize the main frame.

void  HelpTasks::Initialize( void )
{
  // Set the frame icon
  SetIcon( wxICON( gspiceui ) );

  // Set the frame title
  SetTitle( );

  // Call all the initialization functions
  InitToolBar( );
  InitStatBar( );
  InitHtmlWin( );
  InitPosnSize( );
}

//*****************************************************************************
// Initialize the tool bar.

void  HelpTasks::InitToolBar( void )
{
  wxBitmap  * poPixMap[ 2 ];
  wxToolBar * poToolBar;

  // Create the tool bar
  poToolBar = CreateToolBar( wxHORIZONTAL | wxTB_FLAT );

  // Create the bitmaps for the tools
  poPixMap[ 0 ] = new wxBitmap( html_close_xpm );
  poPixMap[ 1 ] = new wxBitmap( html_back_xpm );

  // Add the tools to the toolbar
  poToolBar->AddTool( ID_TBR_CLOSE, wxT(""), *(poPixMap[ 0 ]),
                      wxT("Close") );
  poToolBar->AddTool( ID_TBR_BACK,  wxT(""), *(poPixMap[ 1 ]),
                      wxT("Back") );

  // Realize the toolbar
  poToolBar->Realize( );

  // Can delete the bitmaps since they're reference counted
  for( int i1=0; i1<2; i1++ ) delete poPixMap[ i1 ];
}

//*****************************************************************************
// Initialize the status bar.

void  HelpTasks::InitStatBar( void )
{
  // Create the status bar
  CreateStatusBar( 1 );

  // Set status bar text
  SetStatusText( wxT(" Welcome to the GNU Spice GUI Manual") );
}

//*****************************************************************************
// Initialize the frames position amd size.

void  HelpTasks::InitHtmlWin( void )
{
  // Enable display of image types
  wxInitAllImageHandlers( );

  // Set suitable wxHtmlWindow font sizes
  int  ia[ 7 ]={ 9,10,11,14,16,18,20 };
  m_oHtmlWin.SetFonts( wxT(""), wxT(""), ia );
}

//*****************************************************************************
// Initialize the frames position amd size.

void  HelpTasks::InitPosnSize( void )
{
  int  ix, iy, iw, ih;

  // Set the position and size from the configuration object
  ix = m_poConfig->Read( wxT("/Help/PosnX"), ix );
  iy = m_poConfig->Read( wxT("/Help/PosnY"), iy );
  iw = m_poConfig->Read( wxT("/Help/SizeW"), iw );
  ih = m_poConfig->Read( wxT("/Help/SizeH"), ih );

  if( ix>0 && iy>0 ) Move( ix, iy );
  if( iw>0 && ih>0 ) SetClientSize( iw, ih );
}

//*****************************************************************************
// Determine the path to the applications base installation point.
//
// Return Values:
//   Success - The path to the installation point
//   Failure - An empty string

wxString & HelpTasks::rosGetInstallPath( void )
{
  static  wxString  osPath;
  wxPathList  opl1;
  wxFileName  ofn1;
  wxString    os1;

  osPath.Empty( );

  // Get the command used to envoke this process
  ofn1 = wxTheApp->argv[ 0 ];

  if( ! ofn1.GetPath( ).IsEmpty( ) )
  { // Extract the desired part of the path
    ofn1.Normalize( );  // Expand abbreviations eg. "..", "~', etc.
  }
  else
  { // Search env. var. PATH for the first occurrence of the app. name
    opl1.AddEnvList( wxT("PATH") );
    os1 = opl1.FindAbsoluteValidPath( ofn1.GetFullName( ) );
    ofn1 = os1;
  }

  osPath = ofn1.GetPath( );
  if( osPath.AfterLast( wxT('/') ) == wxT("bin") )
    osPath = osPath.BeforeLast( wxT('/') );

  return( osPath );
}

//*****************************************************************************
// Set the help frame title.

void  HelpTasks::SetTitle( void )
{
  wxString  os1;

  os1 = wxT("GNU Spice GUI Manual");

  if( ! m_oHtmlWin.GetOpenedPage( ).IsEmpty( ) )
    os1 << wxT("  -  ") << m_oHtmlWin.GetOpenedPage( );

  wxFrame::SetTitle( os1 );
}

//*****************************************************************************
// Display the gSpiceUI manual.

void  HelpTasks::Manual( void )
{
  wxFileName  ofn1, ofn2;
  wxString    os1;

  // Check if the manual has been loaded into memory
  if( m_oHtmlWin.GetOpenedPage( ).IsEmpty( ) )
  {
    // Specify the two locations to search
    os1 = rosGetInstallPath( );
    if( os1.IsEmpty( ) ) return;
    ofn1 = os1 + wxT("/share/gspiceui/html/gSpiceUI.html");
    ofn2 = os1 + wxT("/html/gSpiceUI.html");

    // Search for the manual
    if(      ofn1.FileExists( ) ) os1 = ofn1.GetFullPath( );
    else if( ofn2.FileExists( ) ) os1 = ofn2.GetFullPath( );
    else
    {
      // Display an error message
      os1.Empty( );
      os1 << wxT("\nThe base manual page \"") << ofn1.GetFullName( ) << wxT('\"')
          << wxT(" couldn't be found in either of the following locations :\n\n")
          << wxT("     ") << ofn1.GetPath( ) << wxT("/\n")
          << wxT("     ") << ofn2.GetPath( ) << wxT("/\n");
      wxMessageBox( os1, wxT("gSpiceUI Manual"), wxOK | wxCENTRE, m_poFrmMain );
      return;
    }

    // Load the manual
    m_oHtmlWin.LoadPage( os1 );
    SetTitle( );
  }

  // Show the manual
  Show( TRUE );
}

//*****************************************************************************
// Display the about message dialog.

void  HelpTasks::About( void )
{
  wxString  os1;
  long      lStyle;

  os1 << wxT("\n      " ) << APP_NAME << wxT("  -  ") << APP_VERSION << wxT("\n")
      << wxT("                      Copyright (c) Mike Waters 2003\n\n")
      << wxT("This application is intended to provide a GUI for various freely\n")
      << wxT("available SPICE electronic circuit simulation engines:\n\n")
      << wxT("               GNU-Cap\n")
      << wxT("               NG-Spice\n\n")
      << wxT("It is based on the ") << wxVERSION_STRING << wxT(" library and uses gNetList\n")
      << wxT("to import schematic files and gWave to plot waveform data.\n\n")
      << APP_NAME << wxT(" comes with ABSOLUTELY NO WARRANTY.\n")
      << wxT("This is Free Software, and you are welcome to distribute it\n")
      << wxT("under the terms of the GNU General Public License.\n");

  lStyle = wxOK | wxICON_INFORMATION;

  wxMessageBox( os1, wxT("About ") APP_NAME, lStyle, m_poFrmMain );
}

//*****************************************************************************
// Go to the previous page in the history store.
//
// Argument List:
//   roEvtCmd - The event to be processed

void  HelpTasks::OnBack( wxCommandEvent & roEvtCmd )
{
  if( m_oHtmlWin.HistoryCanBack( ) )
    m_oHtmlWin.HistoryBack( );
}

//*****************************************************************************
// Close the help viewer frame.
//
// Argument List:
//   roEvtCmd - The event to be processed

void  HelpTasks::OnClose( wxCommandEvent & roEvtCmd )
{
  int  ix, iy, iw, ih;

  // Save the frame size and position
  GetPosition( &ix, &iy );
  GetClientSize( &iw, &ih );
  m_poConfig->Write( wxT("/Help/PosnX"), (long) ix );
  m_poConfig->Write( wxT("/Help/PosnY"), (long) iy );
  m_poConfig->Write( wxT("/Help/SizeW"), (long) iw );
  m_poConfig->Write( wxT("/Help/SizeH"), (long) ih );
  m_poConfig->Flush( );

  Show( FALSE );  // Hide the frame

  // Reset the HTML Window settings
  while( m_oHtmlWin.HistoryCanBack( ) )
    m_oHtmlWin.HistoryBack( );
  m_oHtmlWin.HistoryClear( );
  m_oHtmlWin.Scroll( 0, 0 );
}

//*****************************************************************************
