/*		
 *		GRAMophone II, a grammar based algorithmic musical composition tool
 *		--------------------------------------------------------------------
 *		
 *		hash.c
 *
 *		Copyright (c) 2007, Giovanni Ferranti <giovanni@giovanniferranti.it>
 *
 * 		GRAMophone II is free software; you can redistribute it and/or modify
 * 		it under the terms of the GNU General Public License as published by
 * 		the Free Software Foundation; either version 2 of the License, or
 * 		(at your option) any later version.
 *
 * 		This program is distributed in the hope that it will be useful,
 * 		but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * 		GNU Library General Public License for more details.
 *
 *		You should have received a copy of the GNU General Public License along
 *		with this program; if not, write to the Free Software Foundation, Inc.,
 *		51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *		-------------------------------------------------------------------
 */

// Funzione di Hash unversale. Viene utilizzata per calcolare gli
// indici nelle tabelle dei simboli

#include <string.h>
#include "global.h"

#define A	31415
#define B	27183
#define C	97

unsigned M=NUM_VARS;
extern int ctrl[];

unsigned int hashU(char *v) {
  unsigned int h, a=A;
  for(h=0; *v!='\0'; v++, a=a*B%(M-1))
    h=(a*h+*v)%M;
  return h;
}

unsigned char hashTwo(char *v) {
  return (*v%C)+1;
}

//sentinel:
//0 - local variables
//1 - global variables
//2 - macros
//3 - memory allocation for a single production

void dhInsert(pnote_var noteVar, char *text, unsigned char sentinel, unsigned char created_by_body) {
  unsigned int i;
  unsigned char k;

  switch(sentinel) {
    case 1:
      i=hashU(noteVar->name);
      k=hashTwo(noteVar->name);
      while(global_vars[i].name!=NULL) {
        if(!strcmp(global_vars[i].name, noteVar->name))
          sntx_err(ALREADY, "variable ");
        i=(i+k)%M;
      }  
      if(!(global_vars[i].name=(char *)malloc((1+VAR_LENGTH)*sizeof(char))))
        sntx_err(MEMORY_ERR, "");
      strcpy(global_vars[i].name, noteVar->name);
      global_vars[i].type=noteVar->type;
      global_vars[i].value=noteVar->value;
      break;
    case 0: 
      i=hashU(noteVar->name);
      k=hashTwo(noteVar->name);
      while(players[playerCount]->local_vars[i].name!=NULL) {
        if(!strcmp(players[playerCount]->local_vars[i].name, noteVar->name))
          sntx_err(ALREADY, "variable ");
        i=(i+k)%M;
      }
      if(!(players[playerCount]->local_vars[i].name=(char *)
			               		    malloc((1+VAR_LENGTH)*sizeof(char))))
        sntx_err(MEMORY_ERR, "");
      strcpy(players[playerCount]->local_vars[i].name, noteVar->name);
      players[playerCount]->local_vars[i].type=noteVar->type;
      players[playerCount]->local_vars[i].value=noteVar->value;
      break;
    case 2:
      i=hashU(text);
      k=hashTwo(text);
      while(macros[i].name!=NULL)
        i=(i+k)%M;
      if(!(macros[i].name=(char *)malloc((1+VAR_LENGTH)*sizeof(char))))
        sntx_err(MEMORY_ERR, "");
      strcpy(macros[i].name, text);
      if(!(macros[i].data=(char *)malloc((1+strlen(string_buf))*sizeof(char))))
	    sntx_err(MEMORY_ERR, "");
      strcpy(macros[i].data, string_buf);
      break;
    case 3:
      i=hashU(text);
      k=hashU(text);
      while((players[playerCount]->productions[i])!=NULL) {
		if(!strcmp(players[playerCount]->productions[i]->name, text)) {
		  if(players[playerCount]->productions[i]->created_by_body) {
			players[playerCount]->productions[i]->created_by_body=0;
			return;
		  }
		  else {
			gen_code(_PRD, ++players[playerCount]->productions[i]->numOr);
			return;
		  }
	    }
	    i=(i+k)%M;      
      }
      if(!(players[playerCount]->productions[i]=(pProd)malloc(sizeof(production))))
	    sntx_err(MEMORY_ERR, "");
      strcpy(players[playerCount]->productions[i]->name, text);
      players[playerCount]->productions[i]->ec=
      players[playerCount]->productions[i]->cc=
      players[playerCount]->productions[i]->terminal=
      players[playerCount]->productions[i]->idTerminal=0;
	  created_by_body==1?(players[playerCount]->productions[i]->created_by_body=1):(players[playerCount]->productions[i]->created_by_body=0);
      players[playerCount]->productions[i]->numOr=1;
      players[playerCount]->productions[i]->exp=NULL;
	  memset(players[playerCount]->productions[i]->midicode, 0, 10*DIM_MIDI_CODE);	
      break;
  }
}

pnote_var dhSearch(char *v, unsigned char sentinel) {
  unsigned int i=hashU(v);
  unsigned char k=hashTwo(v);

  switch(sentinel) {
    case 1:	  
      while(global_vars[i].name!=NULL)
        if(!strcmp(global_vars[i].name, v))
          return &global_vars[i];
        else
          i=(i+k)%M;
      return NULL;
    case 0:
      while(players[playerCount]->local_vars[i].name!=NULL)
        if(!strcmp(players[playerCount]->local_vars[i].name, v))
          return &players[playerCount]->local_vars[i];
        else
          i=(i+k)%M;
      return NULL;
  }
}

//search for macros

char *dhSearch2(char *v) {
  unsigned int i=hashU(v);
  unsigned char k=hashTwo(v);

  while(macros[i].name!=NULL)
   if(!strcmp(macros[i].name, v))
     return macros[i].data;
   else
     i=(i+k)%M;
  return '\0';
}

unsigned int hash(char *v, unsigned char sentinel) {
  unsigned int i=hashU(v);
  unsigned char k=hashTwo(v);

  switch(sentinel) {
    case 0:	  
      while(players[playerCount]->productions[i]!=NULL)
        if(!strcmp(players[playerCount]->productions[i]->name, v))
          return i;
        else
          i=(i+k)%M;
      break;
    case 1:
      while(players[playerCount]->local_vars[i].name!=NULL)
	if(!strcmp(players[playerCount]->local_vars[i].name, v)) {
	  if(!ctrl[3])
	    ctrl[3]=players[playerCount]->local_vars[i].type;
	  else
	    if(players[playerCount]->local_vars[i].type!=ctrl[3])
	      sntx_err(TYPE_ERR, "");
	  return i;
	}  
	else
	  i=(i+k)%M;
      while(global_vars[i].name!=NULL)
	    if(!strcmp(global_vars[i].name, v)) {
	      if(!ctrl[3])
	        ctrl[3]=global_vars[i].type;
	      else
	        if(global_vars[i].type!=ctrl[3])
	          sntx_err(TYPE_ERR, "");	    
	    return i;
	    }  
	    else
	      i=(i+k)%M;
	  sntx_err(VAR_NOT_DECLARED, "");
    break;
  }
}
