/* All Rights reserved */

#include <AppKit/AppKit.h>
#include "Todo.h"

@interface Backend : NSObject
{
	id text;
	id imageView;
	int aktTodo;
	id todos;
	id timer;
	id progress;
	id button;
	id preferences;
	id prf_tableView;
	id prf_buttonText;
	id prf_imageText;
	id prf_durationText;
	id prf_image;
}
- (id) init;
- (void) tick;
- (void) StartWashing: (id)sender;
- (void) clickedButton: (id)sender;
- (void) showPreferences: (id)sender;
+ (NSString *) secondsToDuration: (long) seconds;
-(void) savePreferences;

// actions of the preferences panel
- (void) prf_save: (id)sender;
- (void) prf_add:  (id)sender;
- (void) prf_del: (id)sender;

// Delegate functions for preferences table view
-(void)tableViewSelectionDidChange:(NSNotification *) noty;


- (void)textDidChange:(NSNotification *)tnot;

-(void) applicationDidFinishLaunching: (NSNotification *) not;


// tableview data source methods:
- (int)numberOfRowsInTableView:(NSTableView *)aTableView;
- (id)tableView:(NSTableView *)aTableView 
objectValueForTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex;



// Delegate functions for NSApp

@end
