/* gnome-rdp
 * Copyright (C) 2005-2006 Balazs Varkonyi
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using Gtk;
using Glade;
using System.Collections;
using Mono.Unix;

namespace GnomeRDP
{
	public class CategoryDialog : GladeDialog
	{
		[Widget]ScrolledWindow scrolledwindow4;
		[Widget]Entry eCategory;
		[Widget]Button btOk;
		private SessionTreeStore categoryTreeStore;
		private SessionTreeView categoryTreeView;
		private Configuration config;
		private TreeIter iterSelected;
		
		public CategoryDialog(Configuration Config) : base("dlgCategory")
		{
			this.config = Config;
			categoryTreeStore = new SessionTreeStore();
			categoryTreeView = new SessionTreeView(categoryTreeStore, true);
			scrolledwindow4.Add(categoryTreeView);
			scrolledwindow4.ShowAll();
			this.RefreshCategoryList();
			categoryTreeView.ExpandAll();
			categoryTreeView.Selection.SelectIter(iterSelected);
			eCategory.Text = config.SessionName;
			eCategory.Changed += OnCategoryChanged;
			categoryTreeView.WidgetEvent += OnCategoryChanged;
			this.RefreshControlsSensitivity();
		}
		
		private void RefreshCategoryList()
		{
			Configuration category = new Configuration();
			
			categoryTreeStore.Clear();
			category.ParentId = 0;
			category.SessionName = Catalog.GetString("<ROOT>");
			category.Protocol = 99;

			TreeIter iter = categoryTreeStore.AppendValuesSession(category);
			iterSelected = iter;
			RefreshCategoryListRecursive(0, iter);
		}
		
		private void RefreshCategoryListRecursive(int parentId, TreeIter parentIter)
		{
			ArrayList catList;
			Configuration cf = new Configuration();
			
			catList = cf.LoadCategories();
			foreach (Configuration cfg in catList)
			{
				if ((cfg.ParentId == parentId) && (config.Id != cfg.Id))
				{
					TreeIter iter = categoryTreeStore.AppendValuesSession(parentIter, cfg);
					if (config.ParentId == cfg.Id)
					{
						this.iterSelected = iter;
					}										
					this.RefreshCategoryListRecursive(cfg.Id, iter);
				}
			}
		}		
		
		public int Run()
		{
			int retval = this.Dialog.Run();
			this.Dialog.Destroy();
			if (retval == (int)Gtk.ResponseType.Ok)
			{
				config.SessionName = eCategory.Text;
				config.Protocol = 99;
				config.IsCategory = true;
				config.ParentId = categoryTreeView.config.Id;
				if (config.Id > 0)
				{
					config.UpdateSession(false);
				}
				else
				{
					config.SaveSession(false, false);
				}
			}
			return retval;
		}

		private void RefreshControlsSensitivity()
		{
			if ((eCategory.Text.Trim().Length > 0) &&
				(categoryTreeView.config != null))
			{
				this.btOk.Sensitive = true;				
			}
			else
			{
				this.btOk.Sensitive = false;
			}		
		}
		
		private void OnCategoryChanged(object sender, EventArgs a)
		{
			this.RefreshControlsSensitivity();
		}
	}
}