------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2004 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-binds-lob.ads,v 1.4 2004/06/28 04:57:05 vagul Exp $

with OCI.Thick.Lobs;

package OCI.Thick.Binds.Lob is

   type Bind_Lob is new Abstract_Bind with private;

   procedure Bind
     (Stmt  : in     Statement;
      Var   : in out Bind_Lob;
      Value : in     Lobs.Lob;
      Name  : in     String);

   function Get_Lob (Var : Bind_Lob) return Lobs.Lob;

private

   type Bind_Lob is new Abstract_Bind with record
      Loc : Lobs.Lob;
   end record;

end OCI.Thick.Binds.Lob;
