.TH PSTEXT l "1 Apr 2007" "GMT4.2.0" "GMT4.2.0"
.SH NAME
pstext \- To plot text on maps
.SH SYNOPSIS
\fBpstext\fP \fItextfile\fP \fB\-J\fP\fIparameters\fP \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] 
[ \fB\-B\fP[\fBp\fP|\fBs\fP]\fIparameters\fP ] [ \fB\-C\fP\fIdx/dy\fP ]  
[ \fB\-D\fP[\fBj\fP]\fIdx\fP/\fIdy\fP[\fBv\fP[\fIcolor\fP] ] [ \fB\-E\fP\fIazimuth\fP/\fIelevation\fP ] 
[ \fB\-G\fP\fIcolor\fP ] [ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-Jz\fP|\fBZ\fP\fIparameters\fP ] [ \fB\-K\fP ] [ \fB\-L\fP ] [ \fB\-M\fP[\fIflag\fP] ] [ \fB\-N\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ] 
[ \fB\-S\fP\fIpen\fP ] [ \fB\-U\fP[/\fIdx\fP/\fIdy\fP/][\fIlabel\fP] ] [ \fB\-V\fP ] [ \fB\-W\fP[\fIcolor\fP,][\fBo\fP|\fBO\fP|\fBc\fP|\fBC\fP[\fIpen\fP]] ] 
[ \fB\-X\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIx-shift\fP[\fBu\fP]] ] [ \fB\-Y\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIy-shift\fP[\fBu\fP]] ] [ \fB\-Z\fP\fIzlevel\fP ] [ \fB\-c\fP\fIcopies\fP ] [ \fB\-:\fP[\fBi\fP|\fBo\fP] ]
.SH DESCRIPTION
\fBpstext\fP plots textstrings of variable size, font type, and orientation.
Various map projections are provided, with the option to draw and annotate the
map boundaries. \fIPostScript\fP code is written to standard output.  Greek
characters, subscript, superscript, and small caps are supported as follows:
The sequence @~ toggles between the selected font and Greek (Symbol).
@%\fIno\fP% sets the font to \fIno\fP; @%% resets the font to the starting font,
@- toggles subscripts on/off, @+ toggles superscript on/off, and @# toggles small
caps on/off.  @@ prints the @ sign.  @e, @o, @a, @E, @O, @A give the accented
Scandinavian characters.  Composite characters (overstrike) may be indicated with
the @!<char1><char2> sequence, which will print the two characters on top of
each other.  To learn the octal codes for symbols not available on the keyboard
and some accented European characters, see Section 4.16 and Appendix F in the
\fBGMT\fP Technical Reference and Cookbook.  Note that \fBCHAR_ENCODING\fP must be
set to and extended character set in your \.gmtdefaults4 file in order to use the accented characters.
Using the \fB\-W\fP option, a colored rectangle underlying the text may
be plotted  (Does not work for strings with sub/super scripts, symbols, or composite
characters, except in paragraph mode (\fB\-M\fP)).
.TP
\fItextfile\fP
This file contains 1 or more records with (\fIx, y, size, angle, fontno, justify, text\fP).
If no file is given, \fBpstext\fP will read standard input.
\fIsize\fP is text size in points, \fIangle\fP is measured in degrees counter-clockwise from horizontal, 
\fIfontno\fP sets the font type, \fIjustify\fP sets the alignment. 
If \fIfontno\fP is not an integer, then it is taken to be a textstring with the desired fontname.  See the \fBgmtdefaults\fP man page
for names and numbers of available fonts (or run \fBpstext \-L\fP).  The alignment refers to the
part of the textstring that will be mapped onto the (\fIx,y\fP) point.  Choose a 2 character combination
of L, C, R (for left, center, or right) and T, M, B for top, middle, or bottom. e.g., BL for lower left.
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the \fBMEASURE_UNIT\fP setting in \.gmtdefaults4, but this can be
overridden on the command line by appending \fBc\fP, \fBi\fP, or \fBm\fP to the scale/width value.
For map height, max dimension, or min dimension, append \fBh\fP, \fB+\fP, or \fB-\fP to the width,
respectively.
.br
More details can be found in the \fBpsbasemap\fP man pages.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert)
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant)
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic)
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic)
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP][\fBr\fP|\fBz\fP] (Polar coordinates (theta,r))
.br
\fB\-Jx\fP\fIx-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP][\fI/y-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP]] (Linear, log, and power scaling)
.br
.TP
.B \-Jz
Sets the vertical scaling (for 3-D maps).  Same syntax as \fB\-Jx\fP.
.TP
.B \-R
\fIxmin\fP, \fIxmax\fP, \fIymin\fP, and \fIymax\fP specify the Region of interest.  For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg\fP and \fB\-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected \fBTIME_EPOCH\fP and in the selected \fBTIME_UNIT\fP; append \fBt\fP to
\fB\-JX\fP|\fBx\fP), or absolute time of the form [\fIdate\fP]\fBT\fP[\fIclock\fP]
(append \fBT\fP to \fB\-JX\fP|\fBx\fP).  At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required.  The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx].  The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible). 
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-B
Sets map boundary annotation and tickmark intervals; see the
\fBpsbasemap\fP man page for all the details.
.TP
.B \-C
Sets the clearance between the text and the surrounding box [15%].
Only used if \fB\-W\fP is specified.  Append the unit you want (\fBc\fPm, \fBi\fPnch, \fBm\fPeter.
or \fBp\fPoint; if not given we consult \fBMEASURE_UNIT\fP) or % for a percentage of the font size.
.TP
.B \-D
Offsets the text from the projected (\fIx,y\fP) point by \fIdx,dy\fP [0/0].
Use \fB-Dj\fP to offset the text away from the point instead (i.e. the text's justification\"'
will determine the direction of the shift).  Optionally, append \fBv\fP which will draw a line
from the original point to the shifted point; append a \fIpen\fP to change the attributes for this line.
.TP
.B \-E
Sets the viewpoint's azimuth and elevation (for perspective view) [180/90].\"'
(Not implemented for paragraph mode).
.TP
.B \-G
Sets the gray-shade (0-255) or color (r/g/b, each 0-255) used for drawing the text.  [Default is BASEMAP_FRAME_RGB, the current frame color (by default black)]
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
Lists the font-numbers and font-names available, then exits.
.TP
.B \-M
Paragraph mode.  Files must be multiple segment files.  Segments are separated by
a special record whose first character must be \fIflag\fP [Default is '>'].
Starting in the 3rd column, we expect to find information pertaining to the
typesetting of a text paragraph (the remaining lines until next segment header).
The information expected is (x y size angle fontno justify linespace parwidth parjust),
where \fIx y size angle fontno justify\fP are defined above, while \fIlinespace\fP
and \fIparwidth\fP are the linespacing and paragraph width, respectively.  The justification
of the text paragraph is governed by \fIparjust\fP which may be \fBl\fP(eft), \fBc\fP(enter),
\fBr\fP(ight), or \fBj\fP(ustified).  The segment header is followed by one or more lines
with paragraph text.  Text may contain the escape sequences discussed above as well as three
more: @;\fIr/g/b\fP; changes the font color (@;; resets it), @:\fIsize\fP: changes the
font size (@:: resets it), and @_ toggles underline on/off.  Separate paragraphs with a blank line.
.TP
.B \-N
Do NOT clip text at map boundaries [Default will clip].
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see \fBgmtdefaults\fP to change this].
.TP
.B \-S
Draw text outline. Append pen attributes.
(Not implemented for paragraph mode).
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot.  Optionally,
append a label, or \fBc\fP (which will plot the command string.).  The \fBGMT\fP parameters
\fBUNIX_TIME\fP and \fBUNIX_TIME_POS\fP can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Paint a rectangle beneath the text string.  Set color [Default is no fill].
Append \fBo\fP to draw rectangle outline, add a \fIpen\fP to specify pen attributes [width = 1, color = black,
texture = solid].  use a comma to separate the fill information from the outline information if both are present.
Choose upper case \fBO\fP to get a rounded rectangle.
Choose lower case \fBc\fP to get a concave rectangle (only in paragraph mode).
Choose upper case \fBC\fP to get a convex rectangle (only in paragraph mode).
.TP
.B \-X \-Y
Shift plot origin relative to the current origin by (\fIx-shift,y-shift\fP) and
optionally append the length unit (\fBc\fP, \fBi\fP, \fBm\fP, \fBp\fP).
You can prepend \fBa\fP to shift the origin back to the original position after plotting,
or prepend  \fBr\fP [Default] to reset the current origin to the new location.
If \fB\-O\fP is used then the default (\fIx-shift,y-shift\fP) is (0,0), otherwise it is
(r1i, r1i) or (r2.5c, r2.5c).
Alternatively, give \fBc\fP to align the center coordinate (x or y) of the plot with the center of the page
based on current page size.
.TP
.B \-Z
For 3-D projections:  Sets the z-level of the basemap [0].
(Not implemented for paragraph mode).
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output.  [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only.  [Default affects both].
.TP
.B \-c
Specifies the number of plot copies. [Default is 1].
.SH EXAMPLES
To plot the outlines of the textstrings stored in the file text.d on a Mercator plot with
the given specifications, use
.br
.sp
\fBpstext\fP text.d \fB\-R\fP-30/30/-10/20 \fB\-Jm\fP0.1\fBi\fP \fB\-P \-B\fP5 \fB\-S\fP0.5\fBp\fP > plot.ps
.br
.sp
To add a typeset figure caption for a 3-inch wide illustration, use
.br
.sp
\fBpstext\fP \fB\-R\fP0/3/0/5 \fB\-JX\fP3\fBi\fP \fB\-O \-H \-M \-N\fP << EOF >> figure.ps
.br
This is an optional header record
.br
> 0 -0.5 12 0 4 LT 13p 3i j
.br
@%5%Figure 1.@%%  This illustration shows nothing useful, but it still needs
.br
a figure caption.  Highlighted in @;255/0/0;red@;; you can see the locations
.br
of cities where it is @_impossible@_ to get any good Thai food; these are to
be avoided.
.br
EOF
.br
.SH WINDOWS REMARKS
Note that under Windows, the percent sign (%) is a variable indicator (like $ under Unix).
To indicate a plain percentage sign in a batch script you need to repeat it (%%);
hence the font switching mechanism (@%\fIfont\fP% and @%%) may require twice the
number of percent signs.  This only applies to text inside a script or that otherwise
is processed by DOS.  Data files that are opened and read by \fBpstext\fP do not need such duplication.
.SH BUGS
In paragraph mode, the presence of composite
characters and other escape sequences may lead to unfortunate word splitting. 
.br
The \fB\-N\fP option does not adjust the BoundingBox information so you may
have to post-process the PostScript outout with epstool or ps2epsi to obtain
a correct BoundingBox.
.br
The color change operation in paragraph mode can only handle r/g/b triplets.
.SH "SEE ALSO"
.IR GMT (l),
.IR psbasemap (l)
