/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "gtkrootpointbutton.h"

#include <gtk/gtkmain.h>


enum {
  POINTING_BEGIN,
  POINTING_END,
  POINTED,
  LAST_SIGNAL
};


static void gtk_root_point_button_class_init	 (GtkRootPointButtonClass *klass);
static void gtk_root_point_button_init		 (GtkRootPointButton	  *root_point_button);
static void gtk_root_point_button_pointing_begin (GtkRootPointButton	  *root_point_button);
static void gtk_root_point_button_pointing_end	 (GtkRootPointButton	  *root_point_button);
static void gtk_root_point_button_pointed	 (GtkRootPointButton	  *root_point_button);
static void gtk_root_point_button_clicked	 (GtkButton		  *button);

static gboolean gtk_root_point_button_button_press (GtkWidget	   *widget,
						    GdkEventButton *event);


static GtkButtonClass *parent_class = NULL;
static guint root_point_button_signals[LAST_SIGNAL] = { 0 };


GType
gtk_root_point_button_get_type (void)
{
  static GType root_point_button_type = 0;

  if (!root_point_button_type)
    {
      static const GTypeInfo root_point_button_info =
      {
	sizeof (GtkRootPointButtonClass),
	NULL,		/* base_init */
	NULL,		/* base_finalize */
	(GClassInitFunc) gtk_root_point_button_class_init,
	NULL,		/* class_finalize */
	NULL,		/* class_data */
	sizeof (GtkRootPointButton),
	0,		/* n_preallocs */
	(GInstanceInitFunc) gtk_root_point_button_init,
	NULL,		/* value_table */
      };

      root_point_button_type
	= g_type_register_static (GTK_TYPE_BUTTON,
				  "GtkRootPointButton",
				  &root_point_button_info, 0);
    }

  return root_point_button_type;
}

static void
gtk_root_point_button_class_init (GtkRootPointButtonClass *klass)
{
  GObjectClass	 *gobject_class;
  GtkObjectClass *object_class;
  GtkWidgetClass *widget_class;
  GtkButtonClass *button_class;
  GtkRootPointButtonClass *root_point_button_class;


  gobject_class = G_OBJECT_CLASS (klass);
  object_class = (GtkObjectClass*) klass;
  widget_class = (GtkWidgetClass*) klass;
  button_class = (GtkButtonClass*) klass;
  root_point_button_class = (GtkRootPointButtonClass*) klass;

  parent_class = g_type_class_peek_parent (klass);


  root_point_button_signals[POINTING_BEGIN]
     = g_signal_new ("pointing_begin",
		     G_OBJECT_CLASS_TYPE (object_class),
		     G_SIGNAL_RUN_FIRST,
		     G_STRUCT_OFFSET (GtkRootPointButtonClass, pointing_begin),
		     NULL, NULL,
		     g_cclosure_marshal_VOID__VOID,
		     G_TYPE_NONE, 0);

  root_point_button_signals[POINTING_END]
     = g_signal_new ("pointing_end",
		     G_OBJECT_CLASS_TYPE (object_class),
		     G_SIGNAL_RUN_FIRST,
		     G_STRUCT_OFFSET (GtkRootPointButtonClass, pointing_end),
		     NULL, NULL,
		     g_cclosure_marshal_VOID__VOID,
		     G_TYPE_NONE, 0);

  root_point_button_signals[POINTED]
     = g_signal_new ("pointed",
		     G_OBJECT_CLASS_TYPE (object_class),
		     G_SIGNAL_RUN_FIRST,
		     G_STRUCT_OFFSET (GtkRootPointButtonClass, pointed),
		     NULL, NULL,
		     g_cclosure_marshal_VOID__VOID,
		     G_TYPE_NONE, 0);

  widget_class->button_press_event = gtk_root_point_button_button_press;
  button_class->clicked = gtk_root_point_button_clicked;
  root_point_button_class->pointing_begin = gtk_root_point_button_pointing_begin;
  root_point_button_class->pointing_end = gtk_root_point_button_pointing_end;
  root_point_button_class->pointed = gtk_root_point_button_pointed;
}

static void
gtk_root_point_button_init (GtkRootPointButton *root_point_button)
{
  GdkCursor *grab_cursor;


  grab_cursor = gdk_cursor_new (GDK_CROSSHAIR);
  {
    /* XXX */
    g_object_set_data_full (G_OBJECT (root_point_button),
			    "grab-cusror",
			    grab_cursor,
			    (GDestroyNotify)gdk_cursor_unref);
  }


  root_point_button->in_grab = FALSE;
  root_point_button->grab_cursor = grab_cursor;
}

GtkWidget*
gtk_root_point_button_new (void)
{
  GtkRootPointButton *root_point_button;


  root_point_button = g_object_new (GTK_TYPE_ROOT_POINT_BUTTON,
				    NULL);


  return GTK_WIDGET (root_point_button);
}

GtkWidget*
gtk_root_point_button_new_with_label (gchar *label)
{
  GtkRootPointButton *root_point_button;

  root_point_button = g_object_new (GTK_TYPE_ROOT_POINT_BUTTON,
				    "label", label,
				    NULL);

  return GTK_WIDGET (root_point_button);
}


static void
gtk_root_point_button_pointing_begin (GtkRootPointButton *root_point_button)
{
}

static void
gtk_root_point_button_pointing_end (GtkRootPointButton *root_point_button)
{
}

static void
gtk_root_point_button_pointed (GtkRootPointButton *root_point_button)
{
}


static void
gtk_root_point_button_clicked (GtkButton *button)
{
  GtkRootPointButton *root_point_button;


  root_point_button = GTK_ROOT_POINT_BUTTON (button);

  if (root_point_button->in_grab != TRUE)
    {
      gint r;

      r = gdk_pointer_grab (GTK_WIDGET (root_point_button)->window,
			    FALSE,
			    GDK_BUTTON_PRESS_MASK,
			    NULL,
			    root_point_button->grab_cursor,
			    GDK_CURRENT_TIME);

      if (r == 0)
	{
	  root_point_button->in_grab = TRUE;

	  gtk_grab_add (GTK_WIDGET (button));

	  g_signal_emit (root_point_button,
			 root_point_button_signals[POINTING_BEGIN],
			 0);
	}
    }
}

static gint
gtk_root_point_button_button_press (GtkWidget	   *widget,
				    GdkEventButton *event)
{
  GtkRootPointButton *root_point_button;
  gint r;


  root_point_button = GTK_ROOT_POINT_BUTTON (widget);

  if (root_point_button->in_grab == TRUE)
    {
      g_signal_emit (root_point_button,
		     root_point_button_signals[POINTING_END],
		     0);

      gdk_pointer_ungrab (GDK_CURRENT_TIME);
      gtk_grab_remove (widget);
      root_point_button->in_grab = FALSE;
      
      if (event->button == 1)
	{
	  g_signal_emit (root_point_button,
			 root_point_button_signals[POINTED],
			 0);
	}

      r = TRUE;
    }
  else
    {
      if (GTK_WIDGET_CLASS (parent_class)->button_press_event)
	{
	  r = GTK_WIDGET_CLASS (parent_class)->button_press_event (widget,
								   event);
	}
      else
	{
	  r = FALSE;
	}
    }

  return r;
}
