/*
 *  Copyright (C) 2005  Maarten de Boer <maarten@resorama.com>
 * 
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 *  02110-1301, USA.
 * 
 */

#ifndef __TextureMap__
#define __TextureMap__

#include "Point.hxx"
#include "Texture.hxx"

class TextureMap
{
protected:
   Texture * texture;
public:
   Rect rect;
   TextureMap(Texture * _texture, const Rect& _rect)
         :texture(_texture), rect(_rect)
   {
   }
   ~TextureMap()
   {
   }

   void Draw(const Point& pos,float angle)
   {
      Rect dst(pos.x, pos.y, rect.w, rect.h);
      Draw(dst,angle);
   }
   void Draw(const Rect & dst,float angle)
   {
      texture->Draw(rect, dst, angle);
   }
   void Draw(const Point& pos)
   {
      Rect dst(pos.x, pos.y, rect.w, rect.h);
      Draw(dst);
   }
   void Draw(const Rect & dst)
   {
      texture->Draw(rect, dst);
   }
};

#endif

