// $Id: widget.hh,v 1.24 2004/05/10 14:08:21 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1999  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef WRITER_WIDGET_HH
#define WRITER_WIDGET_HH
#include "WriterBase.hh"

class Gtk_Widget : public WriterBase
{public:
	typedef WriterBase Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	virtual const std::string SignalHandlerArgs(const Widget &w,const std::string &signal,std::string &rettype,std::string &scope) const;
	void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	void Configure_show(const Widget &w, CxxFile &f,const std::string &instance) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
	virtual void ApplyPreferences(Tag &t) const;
	virtual bool isInternalMethod(const Widget &w,std::string &method,const std::string &args,std::string &scope,bool &is_signal) const;
	virtual bool default_can_focus() const
	{  return false; }
	virtual bool isProxySignal(const Widget &w,std::string &method,bool after)const;

//	Gtk_Widget(bool base_class_init=true);
};
#endif
