/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspectorelementtree.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"

#include "ginspector-ui-dnd.h"
#if 0
#include <gtk/gtkdnd.h>
#endif


enum {
  UPDATE,
  LAST_SIGNAL
};

enum {
  PROP_0,
  PROP_VALUE,
};


static void g_inspector_element_tree_set_property (GObject      *object,
						   guint         prop_id,
						   const GValue *value,
						   GParamSpec   *pspec);
static void g_inspector_element_tree_get_property (GObject      *object,
						   guint         prop_id,
						   GValue       *value,
						   GParamSpec   *pspec);
static gboolean g_inspector_element_tree_button_press	  (GtkWidget	    *widget,
							   GdkEventButton   *event);
static gboolean g_inspector_element_tree_button_release	  (GtkWidget	    *widget,
							   GdkEventButton   *event);
static gboolean g_inspector_element_tree_motion_notify	  (GtkWidget	    *widget,
							   GdkEventMotion   *event);
static gboolean g_inspector_element_tree_leave_notify	  (GtkWidget	    *widget,
							   GdkEventCrossing *event);
static void	g_inspector_element_tree_drag_begin	  (GtkWidget	    *widget,
							   GdkDragContext   *context);
static void	g_inspector_element_tree_drag_end	  (GtkWidget	    *widget,
							   GdkDragContext   *context);
static void	g_inspector_element_tree_drag_data_get	  (GtkWidget	    *widget,
							   GdkDragContext   *context,
							   GtkSelectionData *selection_data,
							   guint	     info,
							   guint	     time);
static void	g_inspector_element_tree_drag_data_delete (GtkWidget	    *widget,
							   GdkDragContext   *context);

static void     g_inspector_element_tree_set_prelight_node_widget
						(GInspectorElementTree *element_tree,
						 GtkWidget             *prelight_node_widget);
static void     g_inspector_element_tree_unset_prelight_node_widget
						(GInspectorElementTree *element_tree);
static void     g_inspector_element_tree_set_button_press
						(GInspectorElementTree *element_tree,
						 gint	                button,
						 gint	                x,
						 gint	                y,
						 GtkWidget             *node_widget);
static void     g_inspector_element_tree_unset_button_press
						(GInspectorElementTree *element_tree);

static void element_tree_popup_menu (GInspectorElementTree *element_tree,
				     GdkEventButton        *event);
static void node_widget_popup_menu  (GtkWidget             *node_widget,
				     GdkEventButton        *event);
static void node_widget_clicked     (GtkWidget	           *node_widget,
				     GdkEventButton        *event);

#define ELEMENT_HOLDER "element-holder"




static guint inspector_element_tree_signals[LAST_SIGNAL] = { 0 };


G_DEFINE_TYPE (GInspectorElementTree, g_inspector_element_tree, GTK_TYPE_TREE_CONTAINER);


static void
g_inspector_element_tree_class_init (GInspectorElementTreeClass *klass)
{
  GObjectClass *gobject_class;
  GtkWidgetClass *widget_class;
  GtkTreeContainerClass *tree_container_class;
  GInspectorElementTreeClass *inspector_element_tree_class;

  gobject_class = G_OBJECT_CLASS (klass);
  widget_class = (GtkWidgetClass*) klass;
  tree_container_class = (GtkTreeContainerClass*) klass;
  inspector_element_tree_class = (GInspectorElementTreeClass*) klass;

  gobject_class->set_property = g_inspector_element_tree_set_property;
  gobject_class->get_property = g_inspector_element_tree_get_property;

  widget_class->button_press_event = g_inspector_element_tree_button_press;
  widget_class->button_release_event = g_inspector_element_tree_button_release;
  widget_class->motion_notify_event = g_inspector_element_tree_motion_notify;  
  widget_class->leave_notify_event = g_inspector_element_tree_leave_notify;  
  widget_class->drag_begin = g_inspector_element_tree_drag_begin;  
  widget_class->drag_end = g_inspector_element_tree_drag_end;  
  widget_class->drag_data_get = g_inspector_element_tree_drag_data_get;
  widget_class->drag_data_delete = g_inspector_element_tree_drag_data_delete;


  inspector_element_tree_signals[UPDATE] =
    g_signal_new ("update",
                  G_TYPE_FROM_CLASS (gobject_class),
                  G_SIGNAL_RUN_FIRST,
                  G_STRUCT_OFFSET (GInspectorElementTreeClass, update),
                  NULL, NULL,
                  g_cclosure_marshal_VOID__VOID,
                  G_TYPE_NONE, 0);
}

static void
g_inspector_element_tree_init (GInspectorElementTree *inspector_element_tree)
{
  gtk_widget_set_events (GTK_WIDGET (inspector_element_tree),
			 (gtk_widget_get_events (GTK_WIDGET (inspector_element_tree)) |
			  GDK_POINTER_MOTION_MASK |
			  GDK_BUTTON_PRESS_MASK |
			  GDK_BUTTON_RELEASE_MASK |
			  GDK_LEAVE_NOTIFY_MASK));

  inspector_element_tree->prelight_node_widget = NULL;
  inspector_element_tree->press_button = 0;
  inspector_element_tree->press_x = -1;
  inspector_element_tree->press_y = -1;
  inspector_element_tree->press_node_widget = NULL;
  inspector_element_tree->dnd_element = NULL;
}

static void
g_inspector_element_tree_set_property (GObject      *object,
				       guint         prop_id,
				       const GValue *value,
				       GParamSpec   *pspec)
{
  switch (prop_id)
    {
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

static void
g_inspector_element_tree_get_property (GObject    *object,
				       guint       prop_id,
				       GValue     *value,
				       GParamSpec *pspec)
{
  switch (prop_id)
    {
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

GtkWidget*
g_inspector_element_tree_new (void)
{
  GInspectorElementTree *element_tree;

  element_tree = g_object_new (G_TYPE_INSPECTOR_ELEMENT_TREE,
			       NULL);

  return (GtkWidget *)element_tree;
}




static gboolean
g_inspector_element_tree_button_press (GtkWidget      *widget,
				       GdkEventButton *event)
{
  GInspectorElementTree *element_tree;
  GtkWidget *press_node_widget;

  element_tree = G_INSPECTOR_ELEMENT_TREE (widget);


  press_node_widget
    = gtk_tree_container_get_node_widget_at_pos (GTK_TREE_CONTAINER (element_tree),
						 event->x,
						 event->y);

  if (press_node_widget != NULL)
    {
      if (event->button == 3)
	{
	  node_widget_popup_menu (press_node_widget, event);
	}
      else
	{
	  g_inspector_element_tree_set_button_press (element_tree,
						     event->button,
						     event->x,
						     event->y,
						     press_node_widget);
	}
    }
  else
    {
      element_tree_popup_menu (element_tree, event);
    }

  return FALSE;
}

static gboolean
g_inspector_element_tree_button_release (GtkWidget      *widget,
					 GdkEventButton *event)
{
  GInspectorElementTree *element_tree;
  GtkWidget *press_node_widget;

  element_tree = G_INSPECTOR_ELEMENT_TREE (widget);


  press_node_widget = element_tree->press_node_widget;

  if ((event->button == element_tree->press_button) &&
      (press_node_widget != NULL))
    {
      GtkWidget *release_node_widget;

      release_node_widget
	= gtk_tree_container_get_node_widget_at_pos (GTK_TREE_CONTAINER (element_tree),
						     event->x,
						     event->y);

      if (release_node_widget == press_node_widget)
	{
	  node_widget_clicked (press_node_widget, event);
	}
    }

  g_inspector_element_tree_unset_button_press (element_tree);


  return FALSE;
}

static gboolean
g_inspector_element_tree_motion_notify (GtkWidget      *widget,
					GdkEventMotion *event)
{
  GInspectorElementTree *element_tree;

  element_tree = G_INSPECTOR_ELEMENT_TREE (widget);

  
  if (element_tree->press_button > 0)
    {
      GtkWidget *press_node_widget;

      press_node_widget = element_tree->press_node_widget;

      if ((press_node_widget != NULL) &&
	  (gtk_drag_check_threshold (GTK_WIDGET (element_tree),
				     element_tree->press_x,
				     element_tree->press_y,
				     event->x,
				     event->y)))
	{
	  g_inspector_dnd_drag_begin (GTK_WIDGET (element_tree),
				      (GDK_ACTION_COPY | GDK_ACTION_MOVE),
				      element_tree->press_button,
				      (GdkEvent*)event);

	  element_tree->press_button = 0;
	}
    }
  else
    {
      gint x;
      gint y;
      GtkWidget *node_widget;


      gdk_window_get_pointer (GTK_WIDGET (element_tree)->window,
			      &x, &y, NULL);

      node_widget
	= gtk_tree_container_get_node_widget_at_pos (GTK_TREE_CONTAINER (element_tree),
						     x, y);

      g_inspector_element_tree_set_prelight_node_widget (element_tree,
							 node_widget);
    }

  return FALSE;
}

static gboolean
g_inspector_element_tree_leave_notify (GtkWidget	*widget,
				       GdkEventCrossing *event)
{
  GInspectorElementTree *element_tree;

  element_tree = G_INSPECTOR_ELEMENT_TREE (widget);


  g_inspector_element_tree_unset_prelight_node_widget (element_tree);


  return FALSE;
}


static void
g_inspector_element_tree_drag_begin (GtkWidget	    *widget,
				     GdkDragContext *context)
{
  GInspectorElementTree *element_tree;

  element_tree = G_INSPECTOR_ELEMENT_TREE (widget);


  g_print ("%s()\n", __FUNCTION__);

  {
    gpointer dnd_element;
    GInspectorElementHolder *element_holder;

    element_holder = g_object_get_data (G_OBJECT (element_tree->press_node_widget),
					ELEMENT_HOLDER);

    dnd_element = element_holder;

    element_tree->dnd_element = dnd_element;

    g_inspector_dnd_set_drag_widget_element (context,
					     element_holder);
  }
}

static void
g_inspector_element_tree_drag_end (GtkWidget	  *widget,
				   GdkDragContext *context)
{
  GInspectorElementTree *element_tree;

  element_tree = G_INSPECTOR_ELEMENT_TREE (widget);


  g_print ("%s()\n", __FUNCTION__);


  {
    element_tree->dnd_element = NULL;

    {
      gint x;
      gint y;
      GtkWidget *node_widget;
    
      gdk_window_get_pointer (GTK_WIDGET (element_tree)->window,
			      &x, &y, NULL);

      node_widget
	= gtk_tree_container_get_node_widget_at_pos (GTK_TREE_CONTAINER (element_tree),
						     x, y);
      
      g_inspector_element_tree_set_prelight_node_widget (element_tree, node_widget);
    }
  }
}

static void
g_inspector_element_tree_drag_data_get  (GtkWidget	  *widget,
					 GdkDragContext	  *context,
					 GtkSelectionData *selection_data,
					 guint		   info,
					 guint		   time)
{
  GInspectorElementTree *element_tree;

  element_tree = G_INSPECTOR_ELEMENT_TREE (widget);


  g_print ("%s()\n", __FUNCTION__);


  {
    gpointer dnd_element;

    dnd_element = element_tree->dnd_element;

    g_inspector_dnd_selection_data_set_element (selection_data,
						dnd_element);
  }
}

static void  
g_inspector_element_tree_drag_data_delete  (GtkWidget	   *widget,
					    GdkDragContext *context)
{
  GInspectorElementTree *element_tree;

  element_tree = G_INSPECTOR_ELEMENT_TREE (widget);


  g_print ("%s()\n", __FUNCTION__);
}









static void
g_inspector_element_tree_set_prelight_node_widget (GInspectorElementTree *element_tree,
						   GtkWidget             *prelight_node_widget)
{
  if (prelight_node_widget != element_tree->prelight_node_widget)
    {
      if (element_tree->prelight_node_widget != NULL)
	{
	  gtk_widget_set_state (GTK_WIDGET (element_tree->prelight_node_widget),
				GTK_STATE_NORMAL);

	  element_tree->prelight_node_widget = NULL;
	}

      if (prelight_node_widget != NULL)
	{
	  gtk_widget_set_state (GTK_WIDGET (prelight_node_widget),
				GTK_STATE_PRELIGHT);

	  element_tree->prelight_node_widget = prelight_node_widget;
	}
    }
}

static void
g_inspector_element_tree_unset_prelight_node_widget (GInspectorElementTree *element_tree)
{
  g_inspector_element_tree_set_prelight_node_widget (element_tree, NULL);
}

static void
g_inspector_element_tree_set_button_press (GInspectorElementTree *element_tree,
					   gint	                  button,
					   gint	                  x,
					   gint	                  y,
					   GtkWidget             *node_widget)
{
  element_tree->press_button      = button;
  element_tree->press_x	          = x;
  element_tree->press_y	          = y;
  element_tree->press_node_widget = node_widget;
}

static void
g_inspector_element_tree_unset_button_press (GInspectorElementTree *element_tree)
{
  element_tree->press_button      = 0;
  element_tree->press_x	          = -1;
  element_tree->press_y	          = -1;
  element_tree->press_node_widget = NULL;
}





void
g_inspector_element_tree_update (GInspectorElementTree *element_tree)
{
  g_return_if_fail (element_tree != NULL);
  g_return_if_fail (G_IS_INSPECTOR_ELEMENT_TREE (element_tree));


  g_signal_emit (element_tree, inspector_element_tree_signals[UPDATE], 0);
}

void
g_inspector_element_tree_clear (GInspectorElementTree *element_tree)
{
  g_return_if_fail (element_tree != NULL);
  g_return_if_fail (G_IS_INSPECTOR_ELEMENT_TREE (element_tree));


  gtk_container_foreach (GTK_CONTAINER (element_tree),
			 (GtkCallback)gtk_widget_destroy,
			 NULL);
}


/***/
static void
menu_item_activate_update (GtkMenuItem *menu_item,
			   gpointer     user_data)
{
  GInspectorElementTree *element_tree;

  element_tree = G_INSPECTOR_ELEMENT_TREE (user_data);

  g_inspector_element_tree_update (element_tree);
}

static void
menu_item_activate_style (GtkMenuItem *menu_item,
			  gpointer     user_data)
{
  GInspectorElementTree *element_tree;
  GtkTreeStyle tree_style;

  element_tree = G_INSPECTOR_ELEMENT_TREE (user_data);
  

  tree_style = GPOINTER_TO_INT (g_object_get_data (G_OBJECT (menu_item), "tree_style"));

  gtk_tree_container_set_style (GTK_TREE_CONTAINER (element_tree),
				tree_style);
}

static void
menu_item_activate_depth_align (GtkMenuItem *menu_item,
				gpointer     user_data)
{
  GInspectorElementTree *element_tree;

  element_tree = G_INSPECTOR_ELEMENT_TREE (user_data);

  gtk_tree_container_set_depth_align
		(GTK_TREE_CONTAINER (element_tree),
		 gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM (menu_item)));
}



static void
element_tree_popup_menu (GInspectorElementTree *element_tree,
			 GdkEventButton        *event)
{
  GtkWidget *menu;

  {
    menu = gtk_menu_new ();
    g_inspector_tag_to_widget (gtk_widget_get_toplevel (menu));
  }

  {
    g_object_ref (menu);
    gtk_object_sink (GTK_OBJECT (menu));
    g_signal_connect (G_OBJECT (menu),
                      "selection-done",
                      G_CALLBACK (g_object_unref),
                      NULL);
  }

  {
    GtkWidget *menu_item_update;
    GtkWidget *menu_item_sep1;
    GtkWidget *menu_item_stepwise;
    GtkWidget *menu_item_spray;
    GtkWidget *menu_item_sep2;
    GtkWidget *menu_item_depth_align;

    {
      menu_item_update       = gtk_menu_item_new_with_label       ("Update");
      menu_item_sep1         = gtk_separator_menu_item_new ();
      menu_item_stepwise     = gtk_radio_menu_item_new_with_label (NULL,
								   "GTK__TREE__STYLE__STEPWISE");
      menu_item_spray        = gtk_radio_menu_item_new_with_label (gtk_radio_menu_item_get_group
								     (GTK_RADIO_MENU_ITEM (menu_item_stepwise)),
								   "GTK__TREE__STYLE__SPRAY");
      menu_item_sep2         = gtk_separator_menu_item_new ();
      menu_item_depth_align  = gtk_check_menu_item_new_with_label ("Depth Align");
    }
    {
      GtkTreeStyle tree_style;
      gboolean depth_align;
      tree_style  = (GTK_TREE_CONTAINER (element_tree)->tree_style);
      depth_align = (GTK_TREE_CONTAINER (element_tree)->depth_align);

      if (tree_style == GTK_TREE_STYLE_STEPWISE)
	{
	  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (menu_item_stepwise), TRUE);
	  gtk_widget_set_sensitive (GTK_WIDGET (menu_item_depth_align), FALSE);
	}
      else
	{
	  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (menu_item_spray), TRUE);
	  gtk_widget_set_sensitive (GTK_WIDGET (menu_item_depth_align), TRUE);
	}

      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (menu_item_depth_align), depth_align);
    }

    {
      g_signal_connect (menu_item_update,
			"activate",
			G_CALLBACK (menu_item_activate_update),
			element_tree);

      g_object_set_data (G_OBJECT (menu_item_stepwise),
			 "tree_style", GINT_TO_POINTER (GTK_TREE_STYLE_STEPWISE));
      g_object_set_data (G_OBJECT (menu_item_spray),
			 "tree_style", GINT_TO_POINTER (GTK_TREE_STYLE_SPRAY));
      g_signal_connect (menu_item_stepwise,
			"activate",
			G_CALLBACK (menu_item_activate_style),
			element_tree);
      g_signal_connect (menu_item_spray,
			"activate",
			G_CALLBACK (menu_item_activate_style),
			element_tree);

      g_signal_connect (menu_item_depth_align,
			"activate",
			G_CALLBACK (menu_item_activate_depth_align),
			element_tree);
    }

    {
      gtk_menu_shell_append (GTK_MENU_SHELL (menu), menu_item_update);
      gtk_menu_shell_append (GTK_MENU_SHELL (menu), menu_item_sep1);
      gtk_menu_shell_append (GTK_MENU_SHELL (menu), menu_item_stepwise);
      gtk_menu_shell_append (GTK_MENU_SHELL (menu), menu_item_spray);
      gtk_menu_shell_append (GTK_MENU_SHELL (menu), menu_item_sep2);
      gtk_menu_shell_append (GTK_MENU_SHELL (menu), menu_item_depth_align);
    }
  }

  {
    gtk_widget_show_all (menu);
    gtk_menu_popup (GTK_MENU (menu),
                    NULL,
                    NULL,
                    NULL,
                    NULL,
                    event->button,
                    event->time);
  }
}




/*****/
static void
node_widget_clicked (GtkWidget	    *node_widget,
		     GdkEventButton *event)
{
  GInspectorElementHolder *element_holder;

  element_holder = g_object_get_data (G_OBJECT (node_widget),
				      ELEMENT_HOLDER);

  if (event->button == 1)
    {
      g_inspector_invoke_procedure_by_name ("invoke-default-procedure-for-element",
					    element_holder,
					    NULL);
    }
  if (event->button == 2)
    {
#if 0
      if (GTK_TREE_NODE_IS_EXPANDED (tree_node))
	{
	  gtk_tree_node_collapse (tree_node);
	}
      else
	{
	  gtk_tree_node_expand (tree_node);
	}
#endif
    }
}

static void
node_widget_popup_menu (GtkWidget      *node_widget,
			GdkEventButton *event)
{
  GInspectorElementHolder *element_holder;

  element_holder = g_object_get_data (G_OBJECT (node_widget),
				      ELEMENT_HOLDER);

  if (element_holder != NULL)
    {
      g_inspector_invoke_procedure_by_name ("popup-menu-for-element",
					    element_holder,
					    event);
    }
}


/*****/
void
g_inspector_element_tree_node_widget_set_element_holder	(GtkWidget               *node_widget,
							 GInspectorElementHolder *element_holder)
{
  g_object_ref (G_OBJECT (element_holder));

  g_object_set_data_full (G_OBJECT (node_widget),
			  ELEMENT_HOLDER,
			  element_holder,
			  g_object_unref);
}

GInspectorElementHolder*
g_inspector_element_tree_node_widget_get_element_holder	(GtkWidget *node_widget)
{
  GInspectorElementHolder *element_holder;

  element_holder = g_object_get_data (G_OBJECT (node_widget),
				      ELEMENT_HOLDER);

  return element_holder;
}
