/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-builtin.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"

#include "gtktreecontainer.h"

#include "glrr-glib.h"
#include "glrr-gobject.h"



static void builtin_module_init (void);

static gpointer create_object_detail_window (gpointer data,
					     gpointer func_data,
					     gpointer invoke_data);



void
g_inspector_builtin_register_module_window_object_detail (void)
{
  {
    static GInspectorBuiltinModuleInfo builtin_module_info;

    builtin_module_info.name       = "builtin-window-object-detail";
    builtin_module_info.data       = NULL;
    builtin_module_info.init       = builtin_module_init;
    builtin_module_info.activate   = NULL;
    builtin_module_info.deactivate = NULL;

    g_inspector_builtin_register_module (&builtin_module_info);
  }
}

static void
builtin_module_init (void)
{
  g_inspector_register_procedure ("view-object-detail",
				  "View Object Detail",
				  G_INSPECTOR_PROCEDURE_TYPE_WINDOW,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE,
				  G_TYPE_OBJECT,
				  create_object_detail_window,
				  NULL);
}



static void weak_notify          (gpointer   data,
				  GObject   *where_the_object_was);
static void close_button_clicked (GtkButton *button,
				  gpointer   user_data);



static gpointer
create_object_detail_window (gpointer data,
			     gpointer func_data,
			     gpointer invoke_data)
{
  GObject *object;

  GtkWidget *top;
  GtkWidget *dialog;
#if 0
  GtkWidget *top_hbox;
#else
  GtkWidget *top_hpaned;
#endif


  object = G_OBJECT (data);


  {
    dialog = gtk_dialog_new ();
    g_inspector_tag_to_widget (dialog);
    top = dialog;
  }

  {
    gchar     *window_title;

    window_title = g_strdup_printf ("GObject Detail: %s: %p",
				    g_get_prgname (), object);
    gtk_window_set_title (GTK_WINDOW (dialog), window_title);
    g_free (window_title);
  }

  {
    g_object_weak_xref (object, weak_notify,
			G_OBJECT (top), NULL);
  }

  {
    gtk_window_set_default_size (GTK_WINDOW (dialog),
				 -1, 400);
  }


  {
    GtkWidget *close_button;

    close_button = gtk_button_new_with_label ("Close");
    g_signal_connect (close_button,
		      "clicked",
		      G_CALLBACK (close_button_clicked),
		      (gpointer)dialog);
    gtk_box_pack_start_defaults (GTK_BOX (GTK_DIALOG (dialog)->action_area),
				 close_button);
  }


#if 0
  top_hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), top_hbox,
		      FALSE, FALSE, 0);
#else
  top_hpaned = gtk_hpaned_new ();
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), top_hpaned,
		      TRUE, TRUE, 0);
#endif

  {
    GtkWidget *vbox;

    vbox = gtk_vbox_new (FALSE, 0);
#if 0
    gtk_box_pack_start (GTK_BOX (top_hbox), vbox,
			FALSE, FALSE, 0);
#else
    gtk_paned_pack1 (GTK_PANED (top_hpaned), vbox,
		     FALSE, TRUE);
#endif

    {
      GtkWidget *w;
      w = g_inspector_invoke_procedure_by_name ("create-panel-object-instance-general-info",
						object,
						NULL);
      gtk_box_pack_start (GTK_BOX (vbox), w, FALSE, FALSE, 0);
    }

    {
#if 0
      GtkWidget *hbox;

      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (vbox), hbox,
			  FALSE, FALSE, 0);
#endif

      {
	GtkWidget *w;
	w = g_inspector_invoke_procedure_by_name ("create-panel-object-instance-qdata-list",
						  object,
						  NULL);
	gtk_box_pack_start (GTK_BOX (vbox), w, FALSE, FALSE, 0);
      }

      {
	GtkWidget *w;
	w = g_inspector_invoke_procedure_by_name ("create-panel-object-instance-property-list",
						  object,
						  NULL);
	gtk_box_pack_start (GTK_BOX (vbox), w, TRUE, TRUE, 0);
      }
    }
  }


  gtk_widget_show_all (top);


  return top;
}

static void
weak_notify (gpointer  data,
	     GObject  *where_the_object_was)
{
  GtkWidget *property_edit_window;

  property_edit_window = GTK_WIDGET (data);

  gtk_widget_destroy (property_edit_window);
}

#if 0
static void
edit_properties_button_clicked (GtkButton *button,
				gpointer   user_data)
{
  GObject *object;

  object = G_OBJECT (user_data);

  g_inspector_create_property_edit_window (object);
}
#endif

static void
close_button_clicked (GtkButton *button,
		      gpointer   user_data)
{
  gtk_widget_destroy (GTK_WIDGET (user_data));
}
