/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-builtin.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"
#include "ginspector-ui.h"

#include "gtkloupe.h"

#include "glrr-glib.h"



static void builtin_module_init (void);

static gpointer create_window_loupe (gpointer data,
				     gpointer func_data,
				     gpointer invoke_data);



void
g_inspector_builtin_register_module_window_loupe (void)
{
  {
    static GInspectorBuiltinModuleInfo builtin_module_info;

    builtin_module_info.name       = "builtin-window-loupe";
    builtin_module_info.data       = NULL;
    builtin_module_info.init       = builtin_module_init;
    builtin_module_info.activate   = NULL;
    builtin_module_info.deactivate = NULL;

    g_inspector_builtin_register_module (&builtin_module_info);
  }
}

static void
builtin_module_init (void)
{
  g_inspector_register_procedure ("create-window-loupe",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_WINDOW,
				  G_INSPECTOR_ELEMENT_TYPE_NONE,
				  G_TYPE_NONE,
				  create_window_loupe,
				  NULL);
}



#define LOUPE_MAGNIFICATION "loupe-magnification"



static void
menu_item_mag_activate (GtkMenuItem *menu_item,
			gpointer     user_data)
{
  GtkLoupe *loupe;
  gint magnification;

  loupe         = GTK_LOUPE (user_data);
  magnification = GPOINTER_TO_INT (g_object_get_data (G_OBJECT (menu_item),
						      LOUPE_MAGNIFICATION));

  gtk_loupe_set_magnification (loupe,
			       magnification,
			       magnification);
}

static void
menu_item_close_activate (GtkMenuItem *menu_item,
			  gpointer     user_data)
{
  GtkWidget *loupe_window;

  loupe_window = GTK_WIDGET (user_data);

  gtk_widget_destroy (loupe_window);
}

static void
loupe_button_press (GtkWidget      *widget,
		    GdkEventButton *event,
		    gpointer        user_data)
{
  GtkLoupe *loupe;
  GtkWidget *menu;


  loupe = GTK_LOUPE (widget);


  {
    menu = gtk_menu_new ();
    g_inspector_tag_to_widget (gtk_widget_get_toplevel (menu));

    g_object_ref (menu);
    gtk_object_sink (GTK_OBJECT (menu));
    g_signal_connect (menu,
		      "selection-done",
		      G_CALLBACK (g_object_unref),
		      NULL);
  }

  {
    GList *menu_item_list;

    menu_item_list = NULL;
    
    {
      GList *mag_list;
      GList *tmp;
      gint magnification;
      GtkWidget *menu_item;
      gchar *label_str;

      mag_list = g_list_new (GINT_TO_POINTER (16),
			     GINT_TO_POINTER (8),
			     GINT_TO_POINTER (4),
			     GINT_TO_POINTER (2),
			     NULL);

      tmp = mag_list;
      while (tmp != NULL)
	{
	  magnification = GPOINTER_TO_INT (tmp->data);
	  tmp = g_list_next (tmp);

	  label_str = g_strdup_printf ("%d:1", magnification);

	  menu_item = gtk_menu_item_new_with_label (label_str);
	  menu_item_list = g_list_append (menu_item_list, menu_item);

	  g_free (label_str);


	  g_object_set_data (G_OBJECT (menu_item),
			     LOUPE_MAGNIFICATION,
			     GINT_TO_POINTER (magnification));

	  g_signal_connect (menu_item,
			    "activate",
			    G_CALLBACK (menu_item_mag_activate),
			    loupe);
	}

      g_list_free (mag_list);
    }

    {
      GList *tmp;
      GtkWidget *menu_item;

      tmp = menu_item_list;
      while (tmp != NULL)
	{
	  menu_item = tmp->data;
	  tmp = g_list_next (tmp);

	  gtk_menu_shell_append (GTK_MENU_SHELL (menu),
				 menu_item);
	}
    }

    g_list_free (menu_item_list);
  }

  gtk_widget_show_all (menu);


  gtk_menu_popup (GTK_MENU (menu),
		  NULL,
		  NULL,
		  NULL,
		  NULL,
		  event->button,
		  event->time);
}

static gpointer
create_window_loupe (gpointer data,
		     gpointer func_data,
		     gpointer invoke_data)
{
  GtkWidget *top;
  GtkWidget *window;
  GtkWidget *loupe;

  window = g_inspector_window_new ();
  top = window;
  gtk_window_set_title (GTK_WINDOW (window), "Loupe");

  loupe = gtk_loupe_new ();
  gtk_container_add (GTK_CONTAINER (window), loupe);

  gtk_widget_add_events (loupe, GDK_BUTTON_PRESS_MASK);
  gtk_widget_set_size_request (loupe, 128, 128);

  {
    g_signal_connect (loupe,
		      "button_press_event",
		      G_CALLBACK (loupe_button_press),
		      (gpointer)window);
  }

  gtk_widget_show_all (window);


  gtk_loupe_start_auto_update (GTK_LOUPE (loupe));


  return top;
}
