/*  GFC-Core: GTK+ Foundation Classes (Core Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/// @file gfc/stackobject.hh
/// @brief A C++ base class for automatic (or stack) objects.
///
/// Provides StackObject, a base class that declares 'operator new' and 'operator delete'
/// private, thereby forcing dervied objects to be created on the stack.

#ifndef GFC_STACK_OBJECT_HH
#define GFC_STACK_OBJECT_HH

#ifndef _CPP_CSTDDEF
#include <cstddef>
#endif

namespace GFC {

/// @class StackObject stackobject.hh gfc/stackobject.hh
/// @brief A C++ base class for automatic (or stack) objects.
///
/// StackObject is a base class for automatic (or stack) objects. The purpose
/// of this class is to declare 'operator new' and 'operator delete' private,
/// thereby forcing derived objects to be created on the stack.

class StackObject
{
	StackObject(const StackObject&);
	StackObject& operator=(const StackObject&);

	static void *operator new(size_t size);
	static void *operator new[](size_t size);

	static void operator delete(void *ptr);
	static void operator delete[](void *ptr);

protected:
/// @name Constructors
/// @{

	StackObject();
	///< Construct a new stack object.

/// @}

public:
/// @name Constructors
/// @{

	~StackObject();
	///< Destructor.

/// @}
};

} // namespace GFC

#endif // GFC_STACK_OBJECT_HH


