/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.29
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC)
#   if (__SUNPRO_CC <= 0x560)
#     define SWIGTEMPLATEDISAMBIGUATOR template
#   else
#     define SWIGTEMPLATEDISAMBIGUATOR 
#   endif
# else
#   define SWIGTEMPLATEDISAMBIGUATOR 
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__)) 
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__)) 
# else
#   define SWIGUNUSED 
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER)
# define _CRT_SECURE_NO_DEPRECATE
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTELC__)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else


#include <iostream>
using namespace std;

#include "cpl_port.h"
#include "cpl_string.h"

#include "gdal.h"
#include "gdal_priv.h"
#include "gdal_alg.h"
#include "gdalwarper.h"

typedef void GDALMajorObjectShadow;
typedef void GDALDriverShadow;
typedef void GDALDatasetShadow;
typedef void GDALRasterBandShadow;

typedef int FALSE_IS_ERR;



#if defined(SWIG_NOINCLUDE) || defined(SWIG_NOARRAYS)


int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input);
void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input);
jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz);


int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input);
void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input);
jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz);


int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input);
void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input);
jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz);


int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input);
void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input);
jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz);


int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input);
void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input);
jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz);


int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input);
void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input);
jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz);


int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input);
void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz);


int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input);
void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input);
jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz);


int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input);
void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz);


int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input);
void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz);


int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input);
void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input);
jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz);


int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input);
void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input);
jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz);


#else


/* bool[] support */
int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetBooleanArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new bool[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = ((*jarr)[i] != 0);
  return 1;
}

void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jboolean)carr[i];
  jenv->ReleaseBooleanArrayElements(input, jarr, 0);
}

jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz) {
  jboolean *arr;
  int i;
  jbooleanArray jresult = jenv->NewBooleanArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetBooleanArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jboolean)result[i];
  jenv->ReleaseBooleanArrayElements(jresult, arr, 0);
  return jresult;
}


/* signed char[] support */
int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetByteArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new signed char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (signed char)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jbyte)carr[i];
  jenv->ReleaseByteArrayElements(input, jarr, 0);
}

jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz) {
  jbyte *arr;
  int i;
  jbyteArray jresult = jenv->NewByteArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetByteArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jbyte)result[i];
  jenv->ReleaseByteArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned char[] support */
int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned char)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* short[] support */
int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (short)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned short[] support */
int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned short)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* int[] support */
int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (int)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned int[] support */
int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned int)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* long[] support */
int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned long[] support */
int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned long)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* jlong[] support */
int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new jlong[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (jlong)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* float[] support */
int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetFloatArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new float[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (float)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jfloat)carr[i];
  jenv->ReleaseFloatArrayElements(input, jarr, 0);
}

jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz) {
  jfloat *arr;
  int i;
  jfloatArray jresult = jenv->NewFloatArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetFloatArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jfloat)result[i];
  jenv->ReleaseFloatArrayElements(jresult, arr, 0);
  return jresult;
}


/* double[] support */
int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetDoubleArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new double[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (double)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jdouble)carr[i];
  jenv->ReleaseDoubleArrayElements(input, jarr, 0);
}

jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz) {
  jdouble *arr;
  int i;
  jdoubleArray jresult = jenv->NewDoubleArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetDoubleArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jdouble)result[i];
  jenv->ReleaseDoubleArrayElements(jresult, arr, 0);
  return jresult;
}


#endif


  void Debug( const char *msg_class, const char *message ) {
    CPLDebug( msg_class, message );
  }
  void Error( CPLErr msg_class = CE_Failure, int err_code = 0, const char* msg = "error" ) {
    CPLError( msg_class, err_code, msg );
  }

  CPLErr PushErrorHandler( char const * pszCallbackName = "CPLQuietErrorHandler" ) {
    CPLErrorHandler pfnHandler = NULL;
    if( EQUAL(pszCallbackName,"CPLQuietErrorHandler") )
      pfnHandler = CPLQuietErrorHandler;
    else if( EQUAL(pszCallbackName,"CPLDefaultErrorHandler") )
      pfnHandler = CPLDefaultErrorHandler;
    else if( EQUAL(pszCallbackName,"CPLLoggingErrorHandler") )
      pfnHandler = CPLLoggingErrorHandler;

    if ( pfnHandler == NULL )
      return CE_Fatal;

    CPLPushErrorHandler( pfnHandler );

    return CE_None;
  }


SWIGINTERN char const *GDALMajorObjectShadow_GetDescription(GDALMajorObjectShadow *self){
    return GDALGetDescription( self );
  }
SWIGINTERN void GDALMajorObjectShadow_SetDescription(GDALMajorObjectShadow *self,char const *pszNewDesc){
    GDALSetDescription( self, pszNewDesc );
  }
SWIGINTERN char **GDALMajorObjectShadow_GetMetadata_Dict(GDALMajorObjectShadow *self,char const *pszDomain=""){
    return GDALGetMetadata( self, pszDomain );
  }
SWIGINTERN char **GDALMajorObjectShadow_GetMetadata_List(GDALMajorObjectShadow *self,char const *pszDomain=""){
    return GDALGetMetadata( self, pszDomain );
  }
SWIGINTERN CPLErr GDALMajorObjectShadow_SetMetadata__SWIG_0(GDALMajorObjectShadow *self,char **papszMetadata,char const *pszDomain=""){
    return GDALSetMetadata( self, papszMetadata, pszDomain );
  }
SWIGINTERN CPLErr GDALMajorObjectShadow_SetMetadata__SWIG_1(GDALMajorObjectShadow *self,char *pszMetadataString,char const *pszDomain=""){
    char *tmpList[2];
    tmpList[0] = pszMetadataString;
    tmpList[1] = 0;
    return GDALSetMetadata( self, tmpList, pszDomain );
  }
SWIGINTERN GDALDatasetShadow *GDALDriverShadow_Create(GDALDriverShadow *self,char const *name,int xsize,int ysize,int bands=1,GDALDataType eType=GDT_Byte,char **options=0){
    GDALDatasetShadow* ds = (GDALDatasetShadow*) GDALCreate( self, name, xsize, ysize, bands, eType, options );
    return ds;
  }
SWIGINTERN GDALDatasetShadow *GDALDriverShadow_CreateCopy(GDALDriverShadow *self,char const *name,GDALDatasetShadow *src,int strict=1,char **options=0){
    GDALDatasetShadow *ds = (GDALDatasetShadow*) GDALCreateCopy(self, name, src, strict, options, 0, 0 );
    return ds;
  }
SWIGINTERN int GDALDriverShadow_Delete(GDALDriverShadow *self,char const *name){
    return GDALDeleteDataset( self, name );
  }

char const *GDALDriverShadow_ShortName_get( GDALDriverShadow *h ) {
  return GDALGetDriverShortName( h );
}
char const *GDALDriverShadow_LongName_get( GDALDriverShadow *h ) {
  return GDALGetDriverLongName( h );
}
char const *GDALDriverShadow_HelpTopic_get( GDALDriverShadow *h ) {
  return GDALGetDriverHelpTopic( h );
}

SWIGINTERN GDAL_GCP *new_GDAL_GCP(double x=0.0,double y=0.0,double z=0.0,double pixel=0.0,double line=0.0,char const *info="",char const *id=""){
    GDAL_GCP *self = (GDAL_GCP*) CPLMalloc( sizeof( GDAL_GCP ) );
    self->dfGCPX = x;
    self->dfGCPY = y;
    self->dfGCPZ = z;
    self->dfGCPPixel = pixel;
    self->dfGCPLine = line;
    self->pszInfo =  CPLStrdup( (info == 0) ? "" : info );
    self->pszId = CPLStrdup( (id==0)? "" : id );
    return self;
  }
SWIGINTERN void delete_GDAL_GCP(GDAL_GCP *self){
    if ( self->pszInfo )
      CPLFree( self->pszInfo );
    if ( self->pszId )
      CPLFree( self->pszId );
    CPLFree( self );
  }


double GDAL_GCP_GCPX_get( GDAL_GCP *h ) {
  return h->dfGCPX;
}
void GDAL_GCP_GCPX_set( GDAL_GCP *h, double val ) {
  h->dfGCPX = val;
}
double GDAL_GCP_GCPY_get( GDAL_GCP *h ) {
  return h->dfGCPY;
}
void GDAL_GCP_GCPY_set( GDAL_GCP *h, double val ) {
  h->dfGCPY = val;
}
double GDAL_GCP_GCPZ_get( GDAL_GCP *h ) {
  return h->dfGCPZ;
}
void GDAL_GCP_GCPZ_set( GDAL_GCP *h, double val ) {
  h->dfGCPZ = val;
}
double GDAL_GCP_GCPPixel_get( GDAL_GCP *h ) {
  return h->dfGCPPixel;
}
void GDAL_GCP_GCPPixel_set( GDAL_GCP *h, double val ) {
  h->dfGCPPixel = val;
}
double GDAL_GCP_GCPLine_get( GDAL_GCP *h ) {
  return h->dfGCPLine;
}
void GDAL_GCP_GCPLine_set( GDAL_GCP *h, double val ) {
  h->dfGCPLine = val;
}
const char * GDAL_GCP_Info_get( GDAL_GCP *h ) {
  return h->pszInfo;
}
void GDAL_GCP_Info_set( GDAL_GCP *h, const char * val ) {
  if ( h->pszInfo ) 
    CPLFree( h->pszInfo );
  h->pszInfo = CPLStrdup(val);
}
const char * GDAL_GCP_Id_get( GDAL_GCP *h ) {
  return h->pszId;
}
void GDAL_GCP_Id_set( GDAL_GCP *h, const char * val ) {
  if ( h->pszId ) 
    CPLFree( h->pszId );
  h->pszId = CPLStrdup(val);
}



/* Duplicate, but transposed names for C# because 
*  the C# module outputs backwards names
*/
double GDAL_GCP_get_GCPX( GDAL_GCP *h ) {
  return h->dfGCPX;
}
void GDAL_GCP_set_GCPX( GDAL_GCP *h, double val ) {
  h->dfGCPX = val;
}
double GDAL_GCP_get_GCPY( GDAL_GCP *h ) {
  return h->dfGCPY;
}
void GDAL_GCP_set_GCPY( GDAL_GCP *h, double val ) {
  h->dfGCPY = val;
}
double GDAL_GCP_get_GCPZ( GDAL_GCP *h ) {
  return h->dfGCPZ;
}
void GDAL_GCP_set_GCPZ( GDAL_GCP *h, double val ) {
  h->dfGCPZ = val;
}
double GDAL_GCP_get_GCPPixel( GDAL_GCP *h ) {
  return h->dfGCPPixel;
}
void GDAL_GCP_set_GCPPixel( GDAL_GCP *h, double val ) {
  h->dfGCPPixel = val;
}
double GDAL_GCP_get_GCPLine( GDAL_GCP *h ) {
  return h->dfGCPLine;
}
void GDAL_GCP_set_GCPLine( GDAL_GCP *h, double val ) {
  h->dfGCPLine = val;
}
const char * GDAL_GCP_get_Info( GDAL_GCP *h ) {
  return h->pszInfo;
}
void GDAL_GCP_set_Info( GDAL_GCP *h, const char * val ) {
  if ( h->pszInfo ) 
    CPLFree( h->pszInfo );
  h->pszInfo = CPLStrdup(val);
}
const char * GDAL_GCP_get_Id( GDAL_GCP *h ) {
  return h->pszId;
}
void GDAL_GCP_set_Id( GDAL_GCP *h, const char * val ) {
  if ( h->pszId ) 
    CPLFree( h->pszId );
  h->pszId = CPLStrdup(val);
}





static
CPLErr DSReadRaster_internal( GDALDatasetShadow *obj, 
                            int xoff, int yoff, int xsize, int ysize,
                            int buf_xsize, int buf_ysize,
                            GDALDataType buf_type,
                            int *buf_size, char **buf,
                            int band_list, int *pband_list )
{

    
  *buf_size = buf_xsize * buf_ysize * GDALGetDataTypeSize( buf_type ) / 8;
  *buf = (char*) malloc( *buf_size );

  CPLErr result = GDALDatasetRasterIO(obj, GF_Read, xoff, yoff, xsize, ysize,
                                (void*) *buf, buf_xsize, buf_ysize, buf_type,
                                band_list, pband_list, 0, 0, 0 );
  if ( result != CE_None ) {
    free( *buf );
    *buf = 0;
    *buf_size = 0;
  }
  return result;
}

SWIGINTERN void delete_GDALDatasetShadow(GDALDatasetShadow *self){
    if ( GDALDereferenceDataset( self ) <= 0 ) {
      GDALClose(self);
    }
  }
SWIGINTERN GDALDriverShadow *GDALDatasetShadow_GetDriver(GDALDatasetShadow *self){
    return (GDALDriverShadow*) GDALGetDatasetDriver( self );
  }
SWIGINTERN GDALRasterBandShadow *GDALDatasetShadow_GetRasterBand(GDALDatasetShadow *self,int nBand){
    return (GDALRasterBandShadow*) GDALGetRasterBand( self, nBand );
  }
SWIGINTERN char const *GDALDatasetShadow_GetProjection(GDALDatasetShadow *self){
    return GDALGetProjectionRef( self );
  }
SWIGINTERN char const *GDALDatasetShadow_GetProjectionRef(GDALDatasetShadow *self){
    return GDALGetProjectionRef( self );
  }
SWIGINTERN CPLErr GDALDatasetShadow_SetProjection(GDALDatasetShadow *self,char const *prj){
    return GDALSetProjection( self, prj );
  }
SWIGINTERN void GDALDatasetShadow_GetGeoTransform(GDALDatasetShadow *self,double argout[6]){
    if ( GDALGetGeoTransform( self, argout ) != 0 ) {
      argout[0] = 0.0;
      argout[1] = 1.0;
      argout[2] = 0.0;
      argout[3] = 0.0;
      argout[4] = 0.0;
      argout[5] = 1.0;
    }
  }
SWIGINTERN CPLErr GDALDatasetShadow_SetGeoTransform(GDALDatasetShadow *self,double argin[6]){
    return GDALSetGeoTransform( self, argin );
  }
SWIGINTERN int GDALDatasetShadow_BuildOverviews(GDALDatasetShadow *self,char const *resampling="NEAREST",int overviewlist=0,int *pOverviews=0){
    return GDALBuildOverviews( self, resampling, overviewlist, pOverviews, 0, 0, 0, 0);
  }
SWIGINTERN int GDALDatasetShadow_GetGCPCount(GDALDatasetShadow *self){
    return GDALGetGCPCount( self );
  }
SWIGINTERN char const *GDALDatasetShadow_GetGCPProjection(GDALDatasetShadow *self){
    return GDALGetGCPProjection( self );
  }
SWIGINTERN void GDALDatasetShadow_GetGCPs(GDALDatasetShadow *self,int *nGCPs,GDAL_GCP const **pGCPs){
    *nGCPs = GDALGetGCPCount( self );
    *pGCPs = GDALGetGCPs( self );
  }
SWIGINTERN CPLErr GDALDatasetShadow_SetGCPs(GDALDatasetShadow *self,int nGCPs,GDAL_GCP const *pGCPs,char const *pszGCPProjection){
    return GDALSetGCPs( self, nGCPs, pGCPs, pszGCPProjection );
  }
SWIGINTERN void GDALDatasetShadow_FlushCache(GDALDatasetShadow *self){
    GDALFlushCache( self );
  }
SWIGINTERN CPLErr GDALDatasetShadow_AddBand(GDALDatasetShadow *self,GDALDataType datatype=GDT_Byte,char **options=0){
    return GDALAddBand( self, datatype, options );
  }
SWIGINTERN CPLErr GDALDatasetShadow_WriteRaster(GDALDatasetShadow *self,int xoff,int yoff,int xsize,int ysize,int buf_len,char *buf_string,int *buf_xsize=0,int *buf_ysize=0,GDALDataType *buf_type=0,int band_list=0,int *pband_list=0){
    int nxsize = (buf_xsize==0) ? xsize : *buf_xsize;
    int nysize = (buf_ysize==0) ? ysize : *buf_ysize;
    GDALDataType ntype;
    if ( buf_type != 0 ) {
      ntype = (GDALDataType) *buf_type;
    } else {
      int lastband = GDALGetRasterCount( self ) - 1;
      ntype = GDALGetRasterDataType( GDALGetRasterBand( self, lastband ) );
    }
    bool myBandList = false;
    int nBandCount;
    int *pBandList;
    if ( band_list != 0 ) {
      myBandList = false;
      nBandCount = band_list;
      pBandList = pband_list;
    }
    else {
      myBandList = true;
      nBandCount = GDALGetRasterCount( self );
      pBandList = (int*) CPLMalloc( sizeof(int) * nBandCount );
      for( int i = 0; i< nBandCount; ++i ) {
        pBandList[i] = i;
      }
    }
    return GDALDatasetRasterIO( self, GF_Write, xoff, yoff, xsize, ysize,
                                (void*) buf_string, nxsize, nysize, ntype,
                                band_list, pband_list, 0, 0, 0 );
    if ( myBandList ) {
       CPLFree( pBandList );
    }
  }
SWIGINTERN CPLErr GDALDatasetShadow_ReadRaster(GDALDatasetShadow *self,int xoff,int yoff,int xsize,int ysize,int *buf_len,char **buf,int *buf_xsize=0,int *buf_ysize=0,GDALDataType *buf_type=0,int band_list=0,int *pband_list=0){

    int nxsize = (buf_xsize==0) ? xsize : *buf_xsize;
    int nysize = (buf_ysize==0) ? ysize : *buf_ysize;
    GDALDataType ntype;
    if ( buf_type != 0 ) {
      ntype = (GDALDataType) *buf_type;
    } else {
      int lastband = GDALGetRasterCount( self ) - 1;
      ntype = GDALGetRasterDataType( GDALGetRasterBand( self, lastband ) );
    }
    bool myBandList = false;
    int nBandCount;
    int *pBandList;
    if ( band_list != 0 ) {
      myBandList = false;
      nBandCount = band_list;
      pBandList = pband_list;
    }
    else {
      myBandList = true;
      nBandCount = GDALGetRasterCount( self );
      pBandList = (int*) CPLMalloc( sizeof(int) * nBandCount );
      for( int i = 0; i< nBandCount; ++i ) {
        pBandList[i] = i;
      }
    }
                            
    return DSReadRaster_internal( self, xoff, yoff, xsize, ysize,
                                nxsize, nysize, ntype,
                                buf_len, buf, 
                                nBandCount, pBandList);
    if ( myBandList ) {
       CPLFree( pBandList );
    }

}

int GDALDatasetShadow_RasterXSize_get( GDALDatasetShadow *h ) {
  return GDALGetRasterXSize( h );
}
int GDALDatasetShadow_RasterYSize_get( GDALDatasetShadow *h ) {
  return GDALGetRasterYSize( h );
}
int GDALDatasetShadow_RasterCount_get( GDALDatasetShadow *h ) {
  return GDALGetRasterCount( h );
}


static
CPLErr ReadRaster_internal( GDALRasterBandShadow *obj, 
                            int xoff, int yoff, int xsize, int ysize,
                            int buf_xsize, int buf_ysize,
                            GDALDataType buf_type,
                            int *buf_size, char **buf )
{

  *buf_size = buf_xsize * buf_ysize * GDALGetDataTypeSize( buf_type ) / 8;
  *buf = (char*) malloc( *buf_size );
  CPLErr result =  GDALRasterIO( obj, GF_Read, xoff, yoff, xsize, ysize,
                                 (void *) *buf, buf_xsize, buf_ysize,
                                 buf_type, 0, 0 );
  if ( result != CE_None ) {
    free( *buf );
    *buf = 0;
    *buf_size = 0;
  }
  return result;
}

static
CPLErr WriteRaster_internal( GDALRasterBandShadow *obj,
                             int xoff, int yoff, int xsize, int ysize,
                             int buf_xsize, int buf_ysize,
                             GDALDataType buf_type,
                             int buf_size, char *buffer )
{
    if ( buf_size < buf_xsize * buf_ysize * GDALGetDataTypeSize( buf_type) /8 ) {
      return CE_Failure;
    }

    return GDALRasterIO( obj, GF_Write, xoff, yoff, xsize, ysize, 
		        (void *) buffer, buf_xsize, buf_ysize, buf_type, 0, 0 );
}

SWIGINTERN void GDALRasterBandShadow_GetBlockSize(GDALRasterBandShadow *self,int *pnBlockXSize,int *pnBlockYSize){
      GDALGetBlockSize(self, pnBlockXSize, pnBlockYSize);
  }
SWIGINTERN GDALColorInterp GDALRasterBandShadow_GetRasterColorInterpretation(GDALRasterBandShadow *self){
    return GDALGetRasterColorInterpretation( self );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_SetRasterColorInterpretation(GDALRasterBandShadow *self,GDALColorInterp val){
    return GDALSetRasterColorInterpretation( self, val );
  }
SWIGINTERN void GDALRasterBandShadow_GetNoDataValue(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterNoDataValue( self, hasval );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_SetNoDataValue(GDALRasterBandShadow *self,double d){
    return GDALSetRasterNoDataValue( self, d );
  }
SWIGINTERN void GDALRasterBandShadow_GetMinimum(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterMinimum( self, hasval );
  }
SWIGINTERN void GDALRasterBandShadow_GetMaximum(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterMaximum( self, hasval );
  }
SWIGINTERN void GDALRasterBandShadow_GetOffset(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterOffset( self, hasval );
  }
SWIGINTERN void GDALRasterBandShadow_GetScale(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterScale( self, hasval );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_GetStatistics(GDALRasterBandShadow *self,int approx_ok,int force,double *min,double *max,double *mean,double *stddev){
    return GDALGetRasterStatistics( self, approx_ok, force, 
				    min, max, mean, stddev );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_SetStatistics(GDALRasterBandShadow *self,double min,double max,double mean,double stddev){
    return GDALSetRasterStatistics( self, min, max, mean, stddev );
  }
SWIGINTERN int GDALRasterBandShadow_GetOverviewCount(GDALRasterBandShadow *self){
    return GDALGetOverviewCount( self );
  }
SWIGINTERN GDALRasterBandShadow *GDALRasterBandShadow_GetOverview(GDALRasterBandShadow *self,int i){
    return (GDALRasterBandShadow*) GDALGetOverview( self, i );
  }
SWIGINTERN int GDALRasterBandShadow_Checksum(GDALRasterBandShadow *self,int xoff=0,int yoff=0,int *xsize=0,int *ysize=0){
    int nxsize = (xsize!=0) ? *xsize : GDALGetRasterBandXSize( self );
    int nysize = (ysize!=0) ? *ysize : GDALGetRasterBandYSize( self );
    return GDALChecksumImage( self, xoff, yoff, nxsize, nysize );
  }
SWIGINTERN void GDALRasterBandShadow_ComputeRasterMinMax(GDALRasterBandShadow *self,double argout[2],int approx_ok=0){
    GDALComputeRasterMinMax( self, approx_ok, argout );
  }
SWIGINTERN void GDALRasterBandShadow_ComputeBandStats(GDALRasterBandShadow *self,double argout[2],int samplestep=1){
    GDALComputeBandStats( self, samplestep, argout+0, argout+1, 
                          NULL, NULL );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_Fill(GDALRasterBandShadow *self,double real_fill,double imag_fill=0.0){
    return GDALFillRaster( self, real_fill, imag_fill );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_ReadRaster(GDALRasterBandShadow *self,int xoff,int yoff,int xsize,int ysize,int *buf_len,char **buf,int *buf_xsize=0,int *buf_ysize=0,int *buf_type=0){
    int nxsize = (buf_xsize==0) ? xsize : *buf_xsize;
    int nysize = (buf_ysize==0) ? ysize : *buf_ysize;
    GDALDataType ntype  = (buf_type==0) ? GDALGetRasterDataType(self)
                                        : (GDALDataType)*buf_type;
    return ReadRaster_internal( self, xoff, yoff, xsize, ysize,
                                nxsize, nysize, ntype, buf_len, buf );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_WriteRaster(GDALRasterBandShadow *self,int xoff,int yoff,int xsize,int ysize,int buf_len,char *buf_string,int *buf_xsize=0,int *buf_ysize=0,int *buf_type=0){
    int nxsize = (buf_xsize==0) ? xsize : *buf_xsize;
    int nysize = (buf_ysize==0) ? ysize : *buf_ysize;
    GDALDataType ntype  = (buf_type==0) ? GDALGetRasterDataType(self)
                                        : (GDALDataType)*buf_type;
    return WriteRaster_internal( self, xoff, yoff, xsize, ysize,
                                 nxsize, nysize, ntype, buf_len, buf_string );
  }
SWIGINTERN void GDALRasterBandShadow_FlushCache(GDALRasterBandShadow *self){
    GDALFlushRasterCache( self );
  }
SWIGINTERN GDALColorTable *GDALRasterBandShadow_GetRasterColorTable(GDALRasterBandShadow *self){
    return (GDALColorTable*) GDALGetRasterColorTable( self );
  }
SWIGINTERN int GDALRasterBandShadow_SetRasterColorTable(GDALRasterBandShadow *self,GDALColorTable *arg){
    return GDALSetRasterColorTable( self, arg );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_ReadRaster_Direct(GDALRasterBandShadow *self,int xoff,int yoff,int xsize,int ysize,int buf_xsize,int buf_ysize,GDALDataType buf_type,void *buf){

  return GDALRasterIO( self, GF_Read, xoff, yoff, xsize, ysize,
                                 buf, buf_xsize, buf_ysize,
                                 buf_type, 0, 0 );

}
SWIGINTERN CPLErr GDALRasterBandShadow_WriteRaster_Direct(GDALRasterBandShadow *self,int xoff,int yoff,int xsize,int ysize,int buf_xsize,int buf_ysize,GDALDataType buf_type,void *buf){

  return GDALRasterIO( self, GF_Write, xoff, yoff, xsize, ysize,
                                 buf, buf_xsize, buf_ysize,
                                 buf_type, 0, 0 );

}

GDALDataType GDALRasterBandShadow_DataType_get( GDALRasterBandShadow *h ) {
  return GDALGetRasterDataType( h );
}
int GDALRasterBandShadow_XSize_get( GDALRasterBandShadow *h ) {
  return GDALGetRasterBandXSize( h );
}
int GDALRasterBandShadow_YSize_get( GDALRasterBandShadow *h ) {
  return GDALGetRasterBandYSize( h );
}


int GetDriverCount() {
  return GDALGetDriverCount();
}


GDALDriverShadow* GetDriverByName( char const *name ) {
  return (GDALDriverShadow*) GDALGetDriverByName( name );
}


GDALDriverShadow* GetDriver( int i ) {
  return (GDALDriverShadow*) GDALGetDriver( i );
}


GDALDatasetShadow* Open( char const* name, GDALAccess eAccess = GA_ReadOnly ) {
  GDALDatasetShadow *ds = GDALOpen( name, eAccess );
  return (GDALDatasetShadow*) ds;
}


GDALDatasetShadow* OpenShared( char const* name, GDALAccess eAccess = GA_ReadOnly ) {
  GDALDatasetShadow *ds = GDALOpenShared( name, eAccess );
  return (GDALDatasetShadow*) ds;
}


GDALDatasetShadow *AutoCreateWarpedVRT( GDALDatasetShadow *src_ds,
                                        const char *src_wkt = 0,
                                        const char *dst_wkt = 0,
                                        GDALResampleAlg eResampleAlg = GRA_NearestNeighbour,
                                        double maxerror = 0.0 ) {
  GDALDatasetShadow *ds = GDALAutoCreateWarpedVRT( src_ds, src_wkt,
                                                   dst_wkt,
                                                   eResampleAlg,
                                                   maxerror,
                                                   0 );
  if (ds == 0) {
    /*throw CPLGetLastErrorMsg(); causes a SWIG_exception later*/
  }
  return ds;
  
}


  char **GeneralCmdLineProcessor( char **papszArgv, int nOptions = 0 ) {
    GDALGeneralCmdLineProcessor( CSLCount(papszArgv), &papszArgv, nOptions ); 
    return papszArgv;
  }


#ifdef __cplusplus
extern "C" {
#endif

JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_Debug(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  Debug((char const *)arg1,(char const *)arg2);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_Error(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jstring jarg3) {
  CPLErr arg1 = (CPLErr) CE_Failure ;
  int arg2 = (int) 0 ;
  char *arg3 = (char *) "error" ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (CPLErr)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  Error(arg1,arg2,(char const *)arg3);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3);
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_PushErrorHandler_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  char *arg1 = (char *) "CPLQuietErrorHandler" ;
  CPLErr result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (CPLErr)PushErrorHandler((char const *)arg1);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1);
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_PushErrorHandler_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CPLErrorHandler arg1 ;
  CPLErrorHandler *argp1 ;
  
  (void)jenv;
  (void)jcls;
  argp1 = *(CPLErrorHandler **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null CPLErrorHandler");
    return ;
  }
  arg1 = *argp1; 
  CPLPushErrorHandler(arg1);
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_PopErrorHandler(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  CPLPopErrorHandler();
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_ErrorReset(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  CPLErrorReset();
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_GetLastErrorNo(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)CPLGetLastErrorNo();
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_GetLastErrorType(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  CPLErr result;
  
  (void)jenv;
  (void)jcls;
  result = (CPLErr)CPLGetLastErrorType();
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_gdal_gdalJNI_GetLastErrorMsg(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)CPLGetLastErrorMsg();
  if(result) jresult = jenv->NewStringUTF(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_PushFinderLocation(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  CPLPushFinderLocation((char const *)arg1);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1);
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_PopFinderLocation(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  CPLPopFinderLocation();
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_FinderClean(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  CPLFinderClean();
}


JNIEXPORT jstring JNICALL Java_org_gdal_gdal_gdalJNI_FindFile(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)CPLFindFile((char const *)arg1,(char const *)arg2);
  if(result) jresult = jenv->NewStringUTF(result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_SetConfigOption(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  CPLSetConfigOption((char const *)arg1,(char const *)arg2);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_org_gdal_gdal_gdalJNI_GetConfigOption(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)CPLGetConfigOption((char const *)arg1,(char const *)arg2);
  if(result) jresult = jenv->NewStringUTF(result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_gdal_gdalJNI_CPLBinaryToHex(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2) {
  jstring jresult = 0 ;
  int arg1 ;
  GByte *arg2 = (GByte *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = *(GByte **)&jarg2; 
  result = (char *)CPLBinaryToHex(arg1,(GByte const *)arg2);
  if(result) jresult = jenv->NewStringUTF(result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_gdal_gdalJNI_CPLHexToBinary(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int *arg2 = (int *) 0 ;
  GByte *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(int **)&jarg2; 
  result = (GByte *)CPLHexToBinary((char const *)arg1,arg2);
  *(GByte **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_gdal_gdalJNI_MajorObject_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALMajorObjectShadow **)&jarg1; 
  result = (char *)GDALMajorObjectShadow_GetDescription(arg1);
  if(result) jresult = jenv->NewStringUTF(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_MajorObject_1SetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALMajorObjectShadow **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  GDALMajorObjectShadow_SetDescription(arg1,(char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
}


JNIEXPORT jobject JNICALL Java_org_gdal_gdal_gdalJNI_MajorObject_1GetMetadata_1Dict(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jobject jresult = 0 ;
  GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
  char *arg2 = (char *) "" ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALMajorObjectShadow **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char **)GDALMajorObjectShadow_GetMetadata_Dict(arg1,(char const *)arg2);
  {
    /* %typemap(out) char ** -> to hash */
    /* Convert a char array to a Hashtable */
    char **stringarray = result;
    const jclass hashtable = jenv->FindClass("java/util/Hashtable");
    const jmethodID constructor = jenv->GetMethodID(hashtable, "<init>", "()V");
    const jmethodID put = jenv->GetMethodID(hashtable, "put",
      "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
    jresult = jenv->NewObject(hashtable, constructor);
    if ( stringarray != NULL ) {
      while (*stringarray != NULL ) {
        char const *valptr;
        char *keyptr;
        /*printf("working on pair: %s\n", *stringarray);*/
        valptr = CPLParseNameValue( *stringarray, &keyptr );
        if ( valptr != 0 ) {
          jstring name = jenv->NewStringUTF(keyptr);
          jstring value = jenv->NewStringUTF(valptr);
          jenv->CallObjectMethod(jresult, put, name, value);
          CPLFree( keyptr );
        }
        stringarray++;
      }
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
  return jresult;
}


JNIEXPORT jobject JNICALL Java_org_gdal_gdal_gdalJNI_MajorObject_1GetMetadata_1List(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jobject jresult = 0 ;
  GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
  char *arg2 = (char *) "" ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALMajorObjectShadow **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char **)GDALMajorObjectShadow_GetMetadata_List(arg1,(char const *)arg2);
  {
    /* %typemap(out) char ** -> ( string ) */
    char **stringarray = result;
    const jclass vector = jenv->FindClass("java/util/Vector");
    const jmethodID constructor = jenv->GetMethodID(vector, "<init>", "()V");
    const jmethodID add = jenv->GetMethodID(vector, "add", "(Ljava/lang/Object;)Z");
    
    jresult = jenv->NewObject(vector, constructor);
    if ( stringarray != NULL ) {
      while(*stringarray != NULL) {
        /*printf("working on string %s\n", *stringarray);*/
        jstring value = (jstring)jenv->NewStringUTF(*stringarray);
        jenv->CallBooleanMethod(jresult, add, value);
        stringarray++;
      }
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_MajorObject_1SetMetadata_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jstring jarg3) {
  jint jresult = 0 ;
  GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
  char **arg2 = (char **) 0 ;
  char *arg3 = (char *) "" ;
  CPLErr result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALMajorObjectShadow **)&jarg1; 
  {
    /* %typemap(in) char **dict */
    /* Convert the Hashtable to a char array */
    arg2 = NULL;
    if(jarg2 != 0) {
      const jclass hashtable = jenv->FindClass("java/util/Hashtable");
      const jclass enumeration = jenv->FindClass("java/util/Enumeration");
      const jmethodID get = jenv->GetMethodID(hashtable, "get",
        "(Ljava/lang/Object;)Ljava/lang/Object;");
      const jmethodID keys = jenv->GetMethodID(hashtable, "keys",
        "()Ljava/lang/Enumeration;");
      const jmethodID hasMoreElements = jenv->GetMethodID(enumeration, 
        "hasMoreElements", "()Z");
      const jmethodID getNextElement = jenv->GetMethodID(enumeration,
        "getNextElement", "()Ljava/lang/Object;");
      for (jobject keyset = jenv->CallObjectMethod(jarg2, keys);
        jenv->CallBooleanMethod(keyset, hasMoreElements) == JNI_TRUE;) {
        jstring key = (jstring)jenv->CallObjectMethod(keyset, getNextElement);
        jstring value = (jstring)jenv->CallObjectMethod(jarg2, get, key);
        const char *keyptr = jenv->GetStringUTFChars(key, 0);
        const char *valptr = jenv->GetStringUTFChars(value, 0);
        arg2 = CSLAddNameValue(arg2, keyptr, valptr);
        jenv->ReleaseStringUTFChars(key, keyptr);
        jenv->ReleaseStringUTFChars(value, valptr);
      }
    }
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (CPLErr)GDALMajorObjectShadow_SetMetadata__SWIG_0(arg1,arg2,(char const *)arg3);
  jresult = (jint)result; 
  {
    /* %typemap(freearg) char **dict */
    CSLDestroy( arg2 );
  }
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3);
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_MajorObject_1SetMetadata_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
  jint jresult = 0 ;
  GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) "" ;
  CPLErr result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALMajorObjectShadow **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (CPLErr)GDALMajorObjectShadow_SetMetadata__SWIG_1(arg1,arg2,(char const *)arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_gdal_gdalJNI_Driver_1ShortName_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDriverShadow **)&jarg1; 
  result = (char *)GDALDriverShadow_ShortName_get(arg1);
  if(result) jresult = jenv->NewStringUTF(result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_gdal_gdalJNI_Driver_1LongName_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDriverShadow **)&jarg1; 
  result = (char *)GDALDriverShadow_LongName_get(arg1);
  if(result) jresult = jenv->NewStringUTF(result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_gdal_gdalJNI_Driver_1HelpTopic_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDriverShadow **)&jarg1; 
  result = (char *)GDALDriverShadow_HelpTopic_get(arg1);
  if(result) jresult = jenv->NewStringUTF(result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_gdal_gdalJNI_Driver_1Create(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6, jobject jarg7) {
  jlong jresult = 0 ;
  GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  int arg4 ;
  int arg5 = (int) 1 ;
  GDALDataType arg6 = (GDALDataType) GDT_Byte ;
  char **arg7 = (char **) 0 ;
  GDALDatasetShadow *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDriverShadow **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (GDALDataType)jarg6; 
  {
    /* %typemap(in) char **options */
    arg7 = NULL;
    if(jarg7 != 0) {
      const jclass vector = jenv->FindClass("java/util/Vector");
      const jclass enumeration = jenv->FindClass("java/util/Enumeration");
      const jmethodID elements = jenv->GetMethodID(vector, "elements",
        "()Ljava/util/Enumeration;");
      const jmethodID hasMoreElements = jenv->GetMethodID(enumeration, 
        "hasMoreElements", "()Z");
      const jmethodID getNextElement = jenv->GetMethodID(enumeration,
        "nextElement", "()Ljava/lang/Object;");
      if(vector == NULL || enumeration == NULL || elements == NULL ||
        hasMoreElements == NULL || getNextElement == NULL) {
        fprintf(stderr, "Could not load (options **) jni types.\n");
        return 0;
      }
      for (jobject keys = jenv->CallObjectMethod(jarg7, elements);
        jenv->CallBooleanMethod(keys, hasMoreElements) == JNI_TRUE;) {
        jstring value = (jstring)jenv->CallObjectMethod(keys, getNextElement);
        const char *valptr = jenv->GetStringUTFChars(value, 0);
        arg7 = CSLAddString(arg7,  valptr);
        jenv->ReleaseStringUTFChars(value, valptr);
      }
    }
  }
  result = (GDALDatasetShadow *)GDALDriverShadow_Create(arg1,(char const *)arg2,arg3,arg4,arg5,arg6,arg7);
  *(GDALDatasetShadow **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
  {
    /* %typemap(freearg) char **options */
    CSLDestroy( arg7 );
  }
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_gdal_gdalJNI_Driver_1CreateCopy(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jint jarg4, jobject jarg5) {
  jlong jresult = 0 ;
  GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  GDALDatasetShadow *arg3 = (GDALDatasetShadow *) 0 ;
  int arg4 = (int) 1 ;
  char **arg5 = (char **) 0 ;
  GDALDatasetShadow *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDriverShadow **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(GDALDatasetShadow **)&jarg3; 
  arg4 = (int)jarg4; 
  {
    /* %typemap(in) char **options */
    arg5 = NULL;
    if(jarg5 != 0) {
      const jclass vector = jenv->FindClass("java/util/Vector");
      const jclass enumeration = jenv->FindClass("java/util/Enumeration");
      const jmethodID elements = jenv->GetMethodID(vector, "elements",
        "()Ljava/util/Enumeration;");
      const jmethodID hasMoreElements = jenv->GetMethodID(enumeration, 
        "hasMoreElements", "()Z");
      const jmethodID getNextElement = jenv->GetMethodID(enumeration,
        "nextElement", "()Ljava/lang/Object;");
      if(vector == NULL || enumeration == NULL || elements == NULL ||
        hasMoreElements == NULL || getNextElement == NULL) {
        fprintf(stderr, "Could not load (options **) jni types.\n");
        return 0;
      }
      for (jobject keys = jenv->CallObjectMethod(jarg5, elements);
        jenv->CallBooleanMethod(keys, hasMoreElements) == JNI_TRUE;) {
        jstring value = (jstring)jenv->CallObjectMethod(keys, getNextElement);
        const char *valptr = jenv->GetStringUTFChars(value, 0);
        arg5 = CSLAddString(arg5,  valptr);
        jenv->ReleaseStringUTFChars(value, valptr);
      }
    }
  }
  result = (GDALDatasetShadow *)GDALDriverShadow_CreateCopy(arg1,(char const *)arg2,arg3,arg4,arg5);
  *(GDALDatasetShadow **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
  {
    /* %typemap(freearg) char **options */
    CSLDestroy( arg5 );
  }
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Driver_1Delete(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDriverShadow **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)GDALDriverShadow_Delete(arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_GCP_1GCPX_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  arg2 = (double)jarg2; 
  GDAL_GCP_GCPX_set(arg1,arg2);
  
}


JNIEXPORT jdouble JNICALL Java_org_gdal_gdal_gdalJNI_GCP_1GCPX_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  result = (double)GDAL_GCP_GCPX_get(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_GCP_1GCPY_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  arg2 = (double)jarg2; 
  GDAL_GCP_GCPY_set(arg1,arg2);
  
}


JNIEXPORT jdouble JNICALL Java_org_gdal_gdal_gdalJNI_GCP_1GCPY_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  result = (double)GDAL_GCP_GCPY_get(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_GCP_1GCPZ_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  arg2 = (double)jarg2; 
  GDAL_GCP_GCPZ_set(arg1,arg2);
  
}


JNIEXPORT jdouble JNICALL Java_org_gdal_gdal_gdalJNI_GCP_1GCPZ_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  result = (double)GDAL_GCP_GCPZ_get(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_GCP_1GCPPixel_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  arg2 = (double)jarg2; 
  GDAL_GCP_GCPPixel_set(arg1,arg2);
  
}


JNIEXPORT jdouble JNICALL Java_org_gdal_gdal_gdalJNI_GCP_1GCPPixel_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  result = (double)GDAL_GCP_GCPPixel_get(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_GCP_1GCPLine_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  arg2 = (double)jarg2; 
  GDAL_GCP_GCPLine_set(arg1,arg2);
  
}


JNIEXPORT jdouble JNICALL Java_org_gdal_gdal_gdalJNI_GCP_1GCPLine_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  result = (double)GDAL_GCP_GCPLine_get(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_GCP_1Info_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  GDAL_GCP_Info_set(arg1,arg2);
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_org_gdal_gdal_gdalJNI_GCP_1Info_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  result = (char *)GDAL_GCP_Info_get(arg1);
  if(result) jresult = jenv->NewStringUTF(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_GCP_1Id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  GDAL_GCP_Id_set(arg1,arg2);
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_org_gdal_gdal_gdalJNI_GCP_1Id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  result = (char *)GDAL_GCP_Id_get(arg1);
  if(result) jresult = jenv->NewStringUTF(result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_gdal_gdalJNI_new_1GCP(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jstring jarg6, jstring jarg7) {
  jlong jresult = 0 ;
  double arg1 = (double) 0.0 ;
  double arg2 = (double) 0.0 ;
  double arg3 = (double) 0.0 ;
  double arg4 = (double) 0.0 ;
  double arg5 = (double) 0.0 ;
  char *arg6 = (char *) "" ;
  char *arg7 = (char *) "" ;
  GDAL_GCP *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = 0;
  if (jarg6) {
    arg6 = (char *)jenv->GetStringUTFChars(jarg6, 0);
    if (!arg6) return 0;
  }
  arg7 = 0;
  if (jarg7) {
    arg7 = (char *)jenv->GetStringUTFChars(jarg7, 0);
    if (!arg7) return 0;
  }
  result = (GDAL_GCP *)new_GDAL_GCP(arg1,arg2,arg3,arg4,arg5,(char const *)arg6,(char const *)arg7);
  *(GDAL_GCP **)&jresult = result; 
  if (arg6) jenv->ReleaseStringUTFChars(jarg6, arg6);
  if (arg7) jenv->ReleaseStringUTFChars(jarg7, arg7);
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_delete_1GCP(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  delete_GDAL_GCP(arg1);
  
}


JNIEXPORT jdouble JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1GCPX_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  result = (double)GDAL_GCP_GCPX_get(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1GCPX_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  arg2 = (double)jarg2; 
  GDAL_GCP_GCPX_set(arg1,arg2);
}


JNIEXPORT jdouble JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1GCPY_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  result = (double)GDAL_GCP_GCPY_get(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1GCPY_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  arg2 = (double)jarg2; 
  GDAL_GCP_GCPY_set(arg1,arg2);
}


JNIEXPORT jdouble JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1GCPZ_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  result = (double)GDAL_GCP_GCPZ_get(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1GCPZ_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  arg2 = (double)jarg2; 
  GDAL_GCP_GCPZ_set(arg1,arg2);
}


JNIEXPORT jdouble JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1GCPPixel_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  result = (double)GDAL_GCP_GCPPixel_get(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1GCPPixel_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  arg2 = (double)jarg2; 
  GDAL_GCP_GCPPixel_set(arg1,arg2);
}


JNIEXPORT jdouble JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1GCPLine_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  result = (double)GDAL_GCP_GCPLine_get(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1GCPLine_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  arg2 = (double)jarg2; 
  GDAL_GCP_GCPLine_set(arg1,arg2);
}


JNIEXPORT jstring JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1Info_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  result = (char *)GDAL_GCP_Info_get(arg1);
  if(result) jresult = jenv->NewStringUTF(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1Info_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  GDAL_GCP_Info_set(arg1,(char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1Id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  result = (char *)GDAL_GCP_Id_get(arg1);
  if(result) jresult = jenv->NewStringUTF(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1Id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  GDAL_GCP_Id_set(arg1,(char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
}


JNIEXPORT jdouble JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1get_1GCPX(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  result = (double)GDAL_GCP_get_GCPX(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1set_1GCPX(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  arg2 = (double)jarg2; 
  GDAL_GCP_set_GCPX(arg1,arg2);
}


JNIEXPORT jdouble JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1get_1GCPY(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  result = (double)GDAL_GCP_get_GCPY(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1set_1GCPY(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  arg2 = (double)jarg2; 
  GDAL_GCP_set_GCPY(arg1,arg2);
}


JNIEXPORT jdouble JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1get_1GCPZ(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  result = (double)GDAL_GCP_get_GCPZ(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1set_1GCPZ(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  arg2 = (double)jarg2; 
  GDAL_GCP_set_GCPZ(arg1,arg2);
}


JNIEXPORT jdouble JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1get_1GCPPixel(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  result = (double)GDAL_GCP_get_GCPPixel(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1set_1GCPPixel(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  arg2 = (double)jarg2; 
  GDAL_GCP_set_GCPPixel(arg1,arg2);
}


JNIEXPORT jdouble JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1get_1GCPLine(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  result = (double)GDAL_GCP_get_GCPLine(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1set_1GCPLine(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  arg2 = (double)jarg2; 
  GDAL_GCP_set_GCPLine(arg1,arg2);
}


JNIEXPORT jstring JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1get_1Info(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  result = (char *)GDAL_GCP_get_Info(arg1);
  if(result) jresult = jenv->NewStringUTF(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1set_1Info(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  GDAL_GCP_set_Info(arg1,(char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1get_1Id(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  result = (char *)GDAL_GCP_get_Id(arg1);
  if(result) jresult = jenv->NewStringUTF(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_GDAL_1GCP_1set_1Id(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDAL_GCP **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  GDAL_GCP_set_Id(arg1,(char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
}


JNIEXPORT jlong JNICALL Java_org_gdal_gdal_gdalJNI_GCPsToGeoTransform(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jdoubleArray jarg3, jint jarg4) {
  jlong jresult = 0 ;
  int arg1 ;
  GDAL_GCP *arg2 = (GDAL_GCP *) 0 ;
  double *arg3 ;
  int arg4 = (int) 1 ;
  FALSE_IS_ERR result;
  jdouble *jarr3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = *(GDAL_GCP **)&jarg2; 
  if (jarg3 && jenv->GetArrayLength(jarg3) != 6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return 0;
  }
  if (!SWIG_JavaArrayInDouble(jenv, &jarr3, &arg3, jarg3)) return 0; 
  arg4 = (int)jarg4; 
  result = GDALGCPsToGeoTransform(arg1,(GDAL_GCP const *)arg2,arg3,arg4);
  {
    /* %typemap(out) IF_FALSE_RETURN_NONE */
    jresult = 0;
  }
  SWIG_JavaArrayArgoutDouble(jenv, jarr3, arg3, jarg3); 
  delete [] arg3; 
  {
    /* %typemap(ret) IF_FALSE_RETURN_NONE */
  }
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Dataset_1RasterXSize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDatasetShadow **)&jarg1; 
  result = (int)GDALDatasetShadow_RasterXSize_get(arg1);
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Dataset_1RasterYSize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDatasetShadow **)&jarg1; 
  result = (int)GDALDatasetShadow_RasterYSize_get(arg1);
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Dataset_1RasterCount_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDatasetShadow **)&jarg1; 
  result = (int)GDALDatasetShadow_RasterCount_get(arg1);
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_delete_1Dataset(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDatasetShadow **)&jarg1; 
  delete_GDALDatasetShadow(arg1);
  
}


JNIEXPORT jlong JNICALL Java_org_gdal_gdal_gdalJNI_Dataset_1GetDriver(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  GDALDriverShadow *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDatasetShadow **)&jarg1; 
  result = (GDALDriverShadow *)GDALDatasetShadow_GetDriver(arg1);
  *(GDALDriverShadow **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_gdal_gdalJNI_Dataset_1GetRasterBand(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int arg2 ;
  GDALRasterBandShadow *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDatasetShadow **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (GDALRasterBandShadow *)GDALDatasetShadow_GetRasterBand(arg1,arg2);
  *(GDALRasterBandShadow **)&jresult = result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_gdal_gdalJNI_Dataset_1GetProjection(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDatasetShadow **)&jarg1; 
  result = (char *)GDALDatasetShadow_GetProjection(arg1);
  if(result) jresult = jenv->NewStringUTF(result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_gdal_gdalJNI_Dataset_1GetProjectionRef(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDatasetShadow **)&jarg1; 
  result = (char *)GDALDatasetShadow_GetProjectionRef(arg1);
  if(result) jresult = jenv->NewStringUTF(result);
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Dataset_1SetProjection(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  CPLErr result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDatasetShadow **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (CPLErr)GDALDatasetShadow_SetProjection(arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_Dataset_1GetGeoTransform(JNIEnv *jenv, jclass jcls, jlong jarg1, jdoubleArray jarg2) {
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  double *arg2 ;
  jdouble *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDatasetShadow **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInDouble(jenv, &jarr2, &arg2, jarg2)) return ; 
  GDALDatasetShadow_GetGeoTransform(arg1,arg2);
  SWIG_JavaArrayArgoutDouble(jenv, jarr2, arg2, jarg2); 
  delete [] arg2; 
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Dataset_1SetGeoTransform(JNIEnv *jenv, jclass jcls, jlong jarg1, jdoubleArray jarg2) {
  jint jresult = 0 ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  double *arg2 ;
  CPLErr result;
  jboolean isCopy2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDatasetShadow **)&jarg1; 
  {
    /* %typemap(in) (double argin[ANY]) */
    arg2 = (double *)jenv->GetDoubleArrayElements(jarg2, &isCopy2);
  }
  result = (CPLErr)GDALDatasetShadow_SetGeoTransform(arg1,arg2);
  jresult = (jint)result; 
  {
    /* %typemap(argout) (double argin[ANY]) */
  }
  {
    /* %typemap(in) (double argin[ANY]) */
    if(isCopy2 == JNI_TRUE) {
      jenv->ReleaseDoubleArrayElements(jarg2, (jdouble *)arg2, 0);
    }
  }
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Dataset_1BuildOverviews(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jintArray jarg3) {
  jint jresult = 0 ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  char *arg2 = (char *) "NEAREST" ;
  int arg3 = (int) 0 ;
  int *arg4 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDatasetShadow **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  {
    /* %typemap(in) (int nList, int* pList) */
    /* check if is List */
    arg3 = jenv->GetArrayLength(jarg3);
    arg4 = (int *)jenv->GetIntArrayElements(jarg3, NULL);
  }
  result = (int)GDALDatasetShadow_BuildOverviews(arg1,(char const *)arg2,arg3,arg4);
  jresult = (jint)result; 
  {
    /* %typemap(argout) (int nList, int* pList) */
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
  {
    /* %typemap(freearg) (int nList, int* pList) */
    if (arg4) {
      free((void*) arg4);
    }
  }
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Dataset_1GetGCPCount(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDatasetShadow **)&jarg1; 
  result = (int)GDALDatasetShadow_GetGCPCount(arg1);
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_gdal_gdalJNI_Dataset_1GetGCPProjection(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDatasetShadow **)&jarg1; 
  result = (char *)GDALDatasetShadow_GetGCPProjection(arg1);
  if(result) jresult = jenv->NewStringUTF(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_Dataset_1GetGCPs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int *arg2 = (int *) 0 ;
  GDAL_GCP **arg3 = (GDAL_GCP **) 0 ;
  int nGCPs2 = 0 ;
  GDAL_GCP *pGCPs2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDatasetShadow **)&jarg1; 
  {
    /* %typemap(in,numinputs=1) (int *nGCPs2, GDAL_GCP const **pGCPs2 ) */
    arg2 = &nGCPs2;
    arg3 = &pGCPs2;
  }
  GDALDatasetShadow_GetGCPs(arg1,arg2,(GDAL_GCP const **)arg3);
  {
    /* %typemap(argout) (int *nGCPs, GDAL_GCP const **pGCPs ) */
    const jclass GCPClass = jenv->FindClass("org/gdal/gdal/GCP");
    const jclass vectorClass = jenv->FindClass("java/util/Vector");
    const jmethodID add = jenv->GetMethodID(vectorClass, "add", "(Ljava/lang/Object;)Z");
    const jmethodID GCPcon = jenv->GetMethodID(GCPClass, "<init>",
      "(DDDDDLjava/lang/String;Ljava/lang/String;)V");
    
    for( int i = 0; i < *arg2; i++ ) {
      jobject GCPobj = jenv->NewObject(GCPClass, GCPcon, 
        (*arg3)[i].dfGCPX,
        (*arg3)[i].dfGCPY,
        (*arg3)[i].dfGCPZ,
        (*arg3)[i].dfGCPPixel,
        (*arg3)[i].dfGCPLine,
        (*arg3)[i].pszInfo,
        (*arg3)[i].pszId );
      
      jenv->CallBooleanMethod(jarg2, add, GCPobj);
    }
    //jresult = jarg2;
  }
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Dataset_1SetGCPs(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jstring jarg4) {
  jint jresult = 0 ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int arg2 ;
  GDAL_GCP *arg3 = (GDAL_GCP *) 0 ;
  char *arg4 = (char *) 0 ;
  CPLErr result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDatasetShadow **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(GDAL_GCP **)&jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  result = (CPLErr)GDALDatasetShadow_SetGCPs(arg1,arg2,(GDAL_GCP const *)arg3,(char const *)arg4);
  jresult = (jint)result; 
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, arg4);
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_Dataset_1FlushCache(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDatasetShadow **)&jarg1; 
  GDALDatasetShadow_FlushCache(arg1);
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Dataset_1AddBand(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jobject jarg3) {
  jint jresult = 0 ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  GDALDataType arg2 = (GDALDataType) GDT_Byte ;
  char **arg3 = (char **) 0 ;
  CPLErr result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDatasetShadow **)&jarg1; 
  arg2 = (GDALDataType)jarg2; 
  {
    /* %typemap(in) char **options */
    arg3 = NULL;
    if(jarg3 != 0) {
      const jclass vector = jenv->FindClass("java/util/Vector");
      const jclass enumeration = jenv->FindClass("java/util/Enumeration");
      const jmethodID elements = jenv->GetMethodID(vector, "elements",
        "()Ljava/util/Enumeration;");
      const jmethodID hasMoreElements = jenv->GetMethodID(enumeration, 
        "hasMoreElements", "()Z");
      const jmethodID getNextElement = jenv->GetMethodID(enumeration,
        "nextElement", "()Ljava/lang/Object;");
      if(vector == NULL || enumeration == NULL || elements == NULL ||
        hasMoreElements == NULL || getNextElement == NULL) {
        fprintf(stderr, "Could not load (options **) jni types.\n");
        return 0;
      }
      for (jobject keys = jenv->CallObjectMethod(jarg3, elements);
        jenv->CallBooleanMethod(keys, hasMoreElements) == JNI_TRUE;) {
        jstring value = (jstring)jenv->CallObjectMethod(keys, getNextElement);
        const char *valptr = jenv->GetStringUTFChars(value, 0);
        arg3 = CSLAddString(arg3,  valptr);
        jenv->ReleaseStringUTFChars(value, valptr);
      }
    }
  }
  result = (CPLErr)GDALDatasetShadow_AddBand(arg1,arg2,arg3);
  jresult = (jint)result; 
  {
    /* %typemap(freearg) char **options */
    CSLDestroy( arg3 );
  }
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Dataset_1WriteRaster(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4, jint jarg5, jcharArray jarg6, jintArray jarg8, jintArray jarg9, jintArray jarg10, jintArray jarg11) {
  jint jresult = 0 ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  int arg6 ;
  char *arg7 = (char *) 0 ;
  int *arg8 = (int *) 0 ;
  int *arg9 = (int *) 0 ;
  GDALDataType *arg10 = (GDALDataType *) 0 ;
  int arg11 = (int) 0 ;
  int *arg12 = (int *) 0 ;
  CPLErr result;
  jboolean isCopy6 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDatasetShadow **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  {
    /* %typemap(in) (int nLen, char *pBuf ) */
    arg6 = jenv->GetArrayLength(jarg6);
    arg7 = (char *)jenv->GetCharArrayElements(jarg6, &isCopy6);
  }
  {
    /* %typemap(in) (int *optional_##int) */
    arg8 = (int *)jarg8;
  }
  {
    /* %typemap(in) (int *optional_##int) */
    arg9 = (int *)jarg9;
  }
  {
    /* %typemap(in) (int *optional_##int) */
    arg10 = (GDALDataType *)jarg10;
  }
  {
    /* %typemap(in) (int nList, int* pList) */
    /* check if is List */
    arg11 = jenv->GetArrayLength(jarg11);
    arg12 = (int *)jenv->GetIntArrayElements(jarg11, NULL);
  }
  result = (CPLErr)GDALDatasetShadow_WriteRaster(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
  jresult = (jint)result; 
  {
    /* %typemap(argout) (int nLen, char *pBuf ) */
  }
  {
    /* %typemap(in) (int *optional_##int) */
  }
  {
    /* %typemap(in) (int *optional_##int) */
  }
  {
    /* %typemap(in) (int *optional_##int) */
  }
  {
    /* %typemap(argout) (int nList, int* pList) */
  }
  {
    /* %typemap(freearg) (int nLen, char *pBuf ) */
    /* This calls JNI_ABORT, so any modifications will not be passed back
          into the Java caller
       */
    if(isCopy6 == JNI_TRUE) {
      jenv->ReleaseCharArrayElements(jarg6, (jchar *)arg7, 0);
    }
  }
  {
    /* %typemap(freearg) (int nList, int* pList) */
    if (arg12) {
      free((void*) arg12);
    }
  }
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Dataset_1ReadRaster(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4, jint jarg5, jobjectArray jarg6, jintArray jarg8, jintArray jarg9, jintArray jarg10, jintArray jarg11) {
  jint jresult = 0 ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  int *arg6 = (int *) 0 ;
  char **arg7 = (char **) 0 ;
  int *arg8 = (int *) 0 ;
  int *arg9 = (int *) 0 ;
  GDALDataType *arg10 = (GDALDataType *) 0 ;
  int arg11 = (int) 0 ;
  int *arg12 = (int *) 0 ;
  CPLErr result;
  int nLen6 ;
  char *pBuf6 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDatasetShadow **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  {
    /* %typemap(in) (int *nLen6, char **pBuf6 ) */
    arg6 = &nLen6;
    arg7 = &pBuf6;
  }
  {
    /* %typemap(in) (int *optional_##int) */
    arg8 = (int *)jarg8;
  }
  {
    /* %typemap(in) (int *optional_##int) */
    arg9 = (int *)jarg9;
  }
  {
    /* %typemap(in) (int *optional_##int) */
    arg10 = (GDALDataType *)jarg10;
  }
  {
    /* %typemap(in) (int nList, int* pList) */
    /* check if is List */
    arg11 = jenv->GetArrayLength(jarg11);
    arg12 = (int *)jenv->GetIntArrayElements(jarg11, NULL);
  }
  result = (CPLErr)GDALDatasetShadow_ReadRaster(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
  jresult = (jint)result; 
  {
    /* %typemap(argout) (int *nLen, char **pBuf ) */
    /* make sure that the passed array is at lease length 1 */
    if(jenv->GetArrayLength(jarg6) >= 1) {
      jcharArray charArray = jenv->NewCharArray(nLen6);
      jenv->SetCharArrayRegion(charArray, (jsize)0, (jsize)nLen6, (jchar*)pBuf6);
      jenv->SetObjectArrayElement(jarg6,0,charArray);
    }
  }
  {
    /* %typemap(in) (int *optional_##int) */
  }
  {
    /* %typemap(in) (int *optional_##int) */
  }
  {
    /* %typemap(in) (int *optional_##int) */
  }
  {
    /* %typemap(argout) (int nList, int* pList) */
  }
  {
    /* %typemap(freearg) (int *nLen, char **pBuf ) */
    if( arg6 ) {
      free( *arg7 );
    }
  }
  {
    /* %typemap(freearg) (int nList, int* pList) */
    if (arg12) {
      free((void*) arg12);
    }
  }
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Band_1XSize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  result = (int)GDALRasterBandShadow_XSize_get(arg1);
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Band_1YSize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  result = (int)GDALRasterBandShadow_YSize_get(arg1);
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Band_1DataType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALDataType result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  result = (GDALDataType)GDALRasterBandShadow_DataType_get(arg1);
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_Band_1GetBlockSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jintArray jarg2, jintArray jarg3) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int *arg2 = (int *) 0 ;
  int *arg3 = (int *) 0 ;
  int temp2 ;
  int temp3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  {
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return ;
    }
    if (jenv->GetArrayLength(jarg2) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return ;
    }
    arg2 = &temp2; 
  }
  {
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return ;
    }
    if (jenv->GetArrayLength(jarg3) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return ;
    }
    arg3 = &temp3; 
  }
  GDALRasterBandShadow_GetBlockSize(arg1,arg2,arg3);
  {
    jint jvalue = (jint)temp2;
    jenv->SetIntArrayRegion(jarg2, 0, 1, &jvalue);
  }
  {
    jint jvalue = (jint)temp3;
    jenv->SetIntArrayRegion(jarg3, 0, 1, &jvalue);
  }
  
  
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Band_1GetRasterColorInterpretation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALColorInterp result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  result = (GDALColorInterp)GDALRasterBandShadow_GetRasterColorInterpretation(arg1);
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Band_1SetRasterColorInterpretation(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALColorInterp arg2 ;
  CPLErr result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  arg2 = (GDALColorInterp)jarg2; 
  result = (CPLErr)GDALRasterBandShadow_SetRasterColorInterpretation(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_Band_1GetNoDataValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobjectArray jarg2) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double *arg2 = (double *) 0 ;
  int *arg3 = (int *) 0 ;
  double tmpval2 ;
  int tmphasval2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  {
    /* %typemap(in,numinputs=0) (double *val, int*hasval) */
    arg2 = &tmpval2;
    arg3 = &tmphasval2;
    if(jenv->GetArrayLength(jarg2) < 1) {
      return ;
    }
  }
  GDALRasterBandShadow_GetNoDataValue(arg1,arg2,arg3);
  {
    /* %typemap(argout) (double *val, int*hasval) */
    const jclass Double = jenv->FindClass("java/lang/Double");
    const jmethodID ctor = jenv->GetMethodID(Double, "<init>",
      "(D)V");
    if(*arg3) {
      jobject dbl = jenv->NewObject(Double, ctor, tmpval2);
      jenv->SetObjectArrayElement(jarg2, (jsize)0, dbl);
    } else {
      jenv->SetObjectArrayElement(jarg2, (jsize)0, 0);
    }
  }
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Band_1SetNoDataValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
  jint jresult = 0 ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double arg2 ;
  CPLErr result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  arg2 = (double)jarg2; 
  result = (CPLErr)GDALRasterBandShadow_SetNoDataValue(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_Band_1GetMinimum(JNIEnv *jenv, jclass jcls, jlong jarg1, jobjectArray jarg2) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double *arg2 = (double *) 0 ;
  int *arg3 = (int *) 0 ;
  double tmpval2 ;
  int tmphasval2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  {
    /* %typemap(in,numinputs=0) (double *val, int*hasval) */
    arg2 = &tmpval2;
    arg3 = &tmphasval2;
    if(jenv->GetArrayLength(jarg2) < 1) {
      return ;
    }
  }
  GDALRasterBandShadow_GetMinimum(arg1,arg2,arg3);
  {
    /* %typemap(argout) (double *val, int*hasval) */
    const jclass Double = jenv->FindClass("java/lang/Double");
    const jmethodID ctor = jenv->GetMethodID(Double, "<init>",
      "(D)V");
    if(*arg3) {
      jobject dbl = jenv->NewObject(Double, ctor, tmpval2);
      jenv->SetObjectArrayElement(jarg2, (jsize)0, dbl);
    } else {
      jenv->SetObjectArrayElement(jarg2, (jsize)0, 0);
    }
  }
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_Band_1GetMaximum(JNIEnv *jenv, jclass jcls, jlong jarg1, jobjectArray jarg2) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double *arg2 = (double *) 0 ;
  int *arg3 = (int *) 0 ;
  double tmpval2 ;
  int tmphasval2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  {
    /* %typemap(in,numinputs=0) (double *val, int*hasval) */
    arg2 = &tmpval2;
    arg3 = &tmphasval2;
    if(jenv->GetArrayLength(jarg2) < 1) {
      return ;
    }
  }
  GDALRasterBandShadow_GetMaximum(arg1,arg2,arg3);
  {
    /* %typemap(argout) (double *val, int*hasval) */
    const jclass Double = jenv->FindClass("java/lang/Double");
    const jmethodID ctor = jenv->GetMethodID(Double, "<init>",
      "(D)V");
    if(*arg3) {
      jobject dbl = jenv->NewObject(Double, ctor, tmpval2);
      jenv->SetObjectArrayElement(jarg2, (jsize)0, dbl);
    } else {
      jenv->SetObjectArrayElement(jarg2, (jsize)0, 0);
    }
  }
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_Band_1GetOffset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobjectArray jarg2) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double *arg2 = (double *) 0 ;
  int *arg3 = (int *) 0 ;
  double tmpval2 ;
  int tmphasval2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  {
    /* %typemap(in,numinputs=0) (double *val, int*hasval) */
    arg2 = &tmpval2;
    arg3 = &tmphasval2;
    if(jenv->GetArrayLength(jarg2) < 1) {
      return ;
    }
  }
  GDALRasterBandShadow_GetOffset(arg1,arg2,arg3);
  {
    /* %typemap(argout) (double *val, int*hasval) */
    const jclass Double = jenv->FindClass("java/lang/Double");
    const jmethodID ctor = jenv->GetMethodID(Double, "<init>",
      "(D)V");
    if(*arg3) {
      jobject dbl = jenv->NewObject(Double, ctor, tmpval2);
      jenv->SetObjectArrayElement(jarg2, (jsize)0, dbl);
    } else {
      jenv->SetObjectArrayElement(jarg2, (jsize)0, 0);
    }
  }
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_Band_1GetScale(JNIEnv *jenv, jclass jcls, jlong jarg1, jobjectArray jarg2) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double *arg2 = (double *) 0 ;
  int *arg3 = (int *) 0 ;
  double tmpval2 ;
  int tmphasval2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  {
    /* %typemap(in,numinputs=0) (double *val, int*hasval) */
    arg2 = &tmpval2;
    arg3 = &tmphasval2;
    if(jenv->GetArrayLength(jarg2) < 1) {
      return ;
    }
  }
  GDALRasterBandShadow_GetScale(arg1,arg2,arg3);
  {
    /* %typemap(argout) (double *val, int*hasval) */
    const jclass Double = jenv->FindClass("java/lang/Double");
    const jmethodID ctor = jenv->GetMethodID(Double, "<init>",
      "(D)V");
    if(*arg3) {
      jobject dbl = jenv->NewObject(Double, ctor, tmpval2);
      jenv->SetObjectArrayElement(jarg2, (jsize)0, dbl);
    } else {
      jenv->SetObjectArrayElement(jarg2, (jsize)0, 0);
    }
  }
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Band_1GetStatistics(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jlong jarg7) {
  jint jresult = 0 ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int arg2 ;
  int arg3 ;
  double *arg4 = (double *) 0 ;
  double *arg5 = (double *) 0 ;
  double *arg6 = (double *) 0 ;
  double *arg7 = (double *) 0 ;
  CPLErr result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = *(double **)&jarg4; 
  arg5 = *(double **)&jarg5; 
  arg6 = *(double **)&jarg6; 
  arg7 = *(double **)&jarg7; 
  result = (CPLErr)GDALRasterBandShadow_GetStatistics(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Band_1SetStatistics(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5) {
  jint jresult = 0 ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  CPLErr result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  result = (CPLErr)GDALRasterBandShadow_SetStatistics(arg1,arg2,arg3,arg4,arg5);
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Band_1GetOverviewCount(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  result = (int)GDALRasterBandShadow_GetOverviewCount(arg1);
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_gdal_gdalJNI_Band_1GetOverview(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int arg2 ;
  GDALRasterBandShadow *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (GDALRasterBandShadow *)GDALRasterBandShadow_GetOverview(arg1,arg2);
  *(GDALRasterBandShadow **)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Band_1Checksum(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jintArray jarg4, jintArray jarg5) {
  jint jresult = 0 ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int arg2 = (int) 0 ;
  int arg3 = (int) 0 ;
  int *arg4 = (int *) 0 ;
  int *arg5 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    /* %typemap(in) (int *optional_##int) */
    arg4 = (int *)jarg4;
  }
  {
    /* %typemap(in) (int *optional_##int) */
    arg5 = (int *)jarg5;
  }
  result = (int)GDALRasterBandShadow_Checksum(arg1,arg2,arg3,arg4,arg5);
  jresult = (jint)result; 
  {
    /* %typemap(in) (int *optional_##int) */
  }
  {
    /* %typemap(in) (int *optional_##int) */
  }
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_Band_1ComputeRasterMinMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jdoubleArray jarg2, jint jarg3) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double *arg2 ;
  int arg3 = (int) 0 ;
  jdouble *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInDouble(jenv, &jarr2, &arg2, jarg2)) return ; 
  arg3 = (int)jarg3; 
  GDALRasterBandShadow_ComputeRasterMinMax(arg1,arg2,arg3);
  SWIG_JavaArrayArgoutDouble(jenv, jarr2, arg2, jarg2); 
  delete [] arg2; 
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_Band_1ComputeBandStats(JNIEnv *jenv, jclass jcls, jlong jarg1, jdoubleArray jarg2, jint jarg3) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double *arg2 ;
  int arg3 = (int) 1 ;
  jdouble *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInDouble(jenv, &jarr2, &arg2, jarg2)) return ; 
  arg3 = (int)jarg3; 
  GDALRasterBandShadow_ComputeBandStats(arg1,arg2,arg3);
  SWIG_JavaArrayArgoutDouble(jenv, jarr2, arg2, jarg2); 
  delete [] arg2; 
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Band_1Fill(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3) {
  jint jresult = 0 ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double arg2 ;
  double arg3 = (double) 0.0 ;
  CPLErr result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  result = (CPLErr)GDALRasterBandShadow_Fill(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Band_1ReadRaster(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4, jint jarg5, jobjectArray jarg6, jintArray jarg8, jintArray jarg9, jintArray jarg10) {
  jint jresult = 0 ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  int *arg6 = (int *) 0 ;
  char **arg7 = (char **) 0 ;
  int *arg8 = (int *) 0 ;
  int *arg9 = (int *) 0 ;
  int *arg10 = (int *) 0 ;
  CPLErr result;
  int nLen6 ;
  char *pBuf6 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  {
    /* %typemap(in) (int *nLen6, char **pBuf6 ) */
    arg6 = &nLen6;
    arg7 = &pBuf6;
  }
  {
    /* %typemap(in) (int *optional_##int) */
    arg8 = (int *)jarg8;
  }
  {
    /* %typemap(in) (int *optional_##int) */
    arg9 = (int *)jarg9;
  }
  {
    /* %typemap(in) (int *optional_##int) */
    arg10 = (int *)jarg10;
  }
  result = (CPLErr)GDALRasterBandShadow_ReadRaster(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
  jresult = (jint)result; 
  {
    /* %typemap(argout) (int *nLen, char **pBuf ) */
    /* make sure that the passed array is at lease length 1 */
    if(jenv->GetArrayLength(jarg6) >= 1) {
      jcharArray charArray = jenv->NewCharArray(nLen6);
      jenv->SetCharArrayRegion(charArray, (jsize)0, (jsize)nLen6, (jchar*)pBuf6);
      jenv->SetObjectArrayElement(jarg6,0,charArray);
    }
  }
  {
    /* %typemap(in) (int *optional_##int) */
  }
  {
    /* %typemap(in) (int *optional_##int) */
  }
  {
    /* %typemap(in) (int *optional_##int) */
  }
  {
    /* %typemap(freearg) (int *nLen, char **pBuf ) */
    if( arg6 ) {
      free( *arg7 );
    }
  }
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Band_1WriteRaster(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4, jint jarg5, jcharArray jarg6, jintArray jarg8, jintArray jarg9, jintArray jarg10) {
  jint jresult = 0 ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  int arg6 ;
  char *arg7 = (char *) 0 ;
  int *arg8 = (int *) 0 ;
  int *arg9 = (int *) 0 ;
  int *arg10 = (int *) 0 ;
  CPLErr result;
  jboolean isCopy6 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  {
    /* %typemap(in) (int nLen, char *pBuf ) */
    arg6 = jenv->GetArrayLength(jarg6);
    arg7 = (char *)jenv->GetCharArrayElements(jarg6, &isCopy6);
  }
  {
    /* %typemap(in) (int *optional_##int) */
    arg8 = (int *)jarg8;
  }
  {
    /* %typemap(in) (int *optional_##int) */
    arg9 = (int *)jarg9;
  }
  {
    /* %typemap(in) (int *optional_##int) */
    arg10 = (int *)jarg10;
  }
  result = (CPLErr)GDALRasterBandShadow_WriteRaster(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
  jresult = (jint)result; 
  {
    /* %typemap(argout) (int nLen, char *pBuf ) */
  }
  {
    /* %typemap(in) (int *optional_##int) */
  }
  {
    /* %typemap(in) (int *optional_##int) */
  }
  {
    /* %typemap(in) (int *optional_##int) */
  }
  {
    /* %typemap(freearg) (int nLen, char *pBuf ) */
    /* This calls JNI_ABORT, so any modifications will not be passed back
          into the Java caller
       */
    if(isCopy6 == JNI_TRUE) {
      jenv->ReleaseCharArrayElements(jarg6, (jchar *)arg7, 0);
    }
  }
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_Band_1FlushCache(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  GDALRasterBandShadow_FlushCache(arg1);
}


JNIEXPORT jlong JNICALL Java_org_gdal_gdal_gdalJNI_Band_1GetRasterColorTable(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALColorTable *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  result = (GDALColorTable *)GDALRasterBandShadow_GetRasterColorTable(arg1);
  *(GDALColorTable **)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Band_1SetRasterColorTable(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALColorTable *arg2 = (GDALColorTable *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  arg2 = *(GDALColorTable **)&jarg2; 
  result = (int)GDALRasterBandShadow_SetRasterColorTable(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Band_1ReadRaster_1Direct(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6, jint jarg7, jint jarg8, jobject jarg9) {
  jint jresult = 0 ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  int arg6 ;
  int arg7 ;
  GDALDataType arg8 ;
  void *arg9 = (void *) 0 ;
  CPLErr result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (int)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = (GDALDataType)jarg8; 
  {
    /* %typemap(in) void * */
    arg9 = jenv->GetDirectBufferAddress(jarg9);
  }
  result = (CPLErr)GDALRasterBandShadow_ReadRaster_Direct(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_Band_1WriteRaster_1Direct(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6, jint jarg7, jint jarg8, jobject jarg9) {
  jint jresult = 0 ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  int arg6 ;
  int arg7 ;
  GDALDataType arg8 ;
  void *arg9 = (void *) 0 ;
  CPLErr result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALRasterBandShadow **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (int)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = (GDALDataType)jarg8; 
  {
    /* %typemap(in) void * */
    arg9 = jenv->GetDirectBufferAddress(jarg9);
  }
  result = (CPLErr)GDALRasterBandShadow_WriteRaster_Direct(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_gdal_gdalJNI_new_1ColorTable(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  GDALPaletteInterp arg1 = (GDALPaletteInterp) GPI_RGB ;
  GDALColorTable *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (GDALPaletteInterp)jarg1; 
  result = (GDALColorTable *)new GDALColorTable(arg1);
  *(GDALColorTable **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_delete_1ColorTable(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  GDALColorTable *arg1 = (GDALColorTable *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALColorTable **)&jarg1; 
  delete arg1;
  
}


JNIEXPORT jlong JNICALL Java_org_gdal_gdal_gdalJNI_ColorTable_1Clone(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  GDALColorTable *arg1 = (GDALColorTable *) 0 ;
  GDALColorTable *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALColorTable **)&jarg1; 
  result = (GDALColorTable *)((GDALColorTable const *)arg1)->Clone();
  *(GDALColorTable **)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_ColorTable_1GetPaletteInterpretation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  GDALColorTable *arg1 = (GDALColorTable *) 0 ;
  GDALPaletteInterp result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALColorTable **)&jarg1; 
  result = (GDALPaletteInterp)((GDALColorTable const *)arg1)->GetPaletteInterpretation();
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_ColorTable_1GetCount(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  GDALColorTable *arg1 = (GDALColorTable *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALColorTable **)&jarg1; 
  result = (int)((GDALColorTable const *)arg1)->GetColorEntryCount();
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jobject JNICALL Java_org_gdal_gdal_gdalJNI_ColorTable_1GetColorEntry(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jobject jresult = 0 ;
  GDALColorTable *arg1 = (GDALColorTable *) 0 ;
  int arg2 ;
  GDALColorEntry *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALColorTable **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (GDALColorEntry *)(arg1)->GetColorEntry(arg2);
  {
    /* %typemap(out) (GDALColorEntry *) */
    const jclass Color = jenv->FindClass("java/awt/Color");
    const jmethodID ccon = jenv->GetMethodID(Color, "<init>",
      "(IIII)V");
    jresult = jenv->NewObject(Color, ccon, result->c1, result->c2, result->c3, result->c4);
  }
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_ColorTable_1GetColorEntryAsRGB(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jobject jarg3) {
  jint jresult = 0 ;
  GDALColorTable *arg1 = (GDALColorTable *) 0 ;
  int arg2 ;
  GDALColorEntry *arg3 = (GDALColorEntry *) 0 ;
  int result;
  GDALColorEntry tmp3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALColorTable **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    /* %typemap(in) (GDALColorEntry *) (GDALColorEntry tmp3) */
    arg3 = NULL;
    float *colorptr = 0;
    const jclass Color = jenv->FindClass("java/awt/Color");
    const jmethodID colors = jenv->GetMethodID(Color, "getRGBComponents",
      "([F)[F");
    
    jfloatArray colorArr = jenv->NewFloatArray(4);
    colorArr = (jfloatArray)jenv->CallObjectMethod(jarg3, colors, colorArr); 
    
    colorptr = (float *)jenv->GetFloatArrayElements(colorArr, 0);
    tmp3.c1 = (short)(colorptr[0] * 255);
    tmp3.c2 = (short)(colorptr[1] * 255);
    tmp3.c3 = (short)(colorptr[2] * 255);
    tmp3.c4 = (short)(colorptr[3] * 255);
    /*printf( "  %d, %d, %d, %d\n",
                        tmp3.c1, tmp3.c2, tmp3.c3, tmp3.c4 );*/
    arg3 = &tmp3;
  }
  result = (int)((GDALColorTable const *)arg1)->GetColorEntryAsRGB(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_ColorTable_1SetColorEntry(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jobject jarg3) {
  GDALColorTable *arg1 = (GDALColorTable *) 0 ;
  int arg2 ;
  GDALColorEntry *arg3 = (GDALColorEntry *) 0 ;
  GDALColorEntry tmp3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALColorTable **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    /* %typemap(in) (GDALColorEntry *) (GDALColorEntry tmp3) */
    arg3 = NULL;
    float *colorptr = 0;
    const jclass Color = jenv->FindClass("java/awt/Color");
    const jmethodID colors = jenv->GetMethodID(Color, "getRGBComponents",
      "([F)[F");
    
    jfloatArray colorArr = jenv->NewFloatArray(4);
    colorArr = (jfloatArray)jenv->CallObjectMethod(jarg3, colors, colorArr); 
    
    colorptr = (float *)jenv->GetFloatArrayElements(colorArr, 0);
    tmp3.c1 = (short)(colorptr[0] * 255);
    tmp3.c2 = (short)(colorptr[1] * 255);
    tmp3.c3 = (short)(colorptr[2] * 255);
    tmp3.c4 = (short)(colorptr[3] * 255);
    /*printf( "  %d, %d, %d, %d\n",
                        tmp3.c1, tmp3.c2, tmp3.c3, tmp3.c4 );*/
    arg3 = &tmp3;
  }
  (arg1)->SetColorEntry(arg2,(GDALColorEntry const *)arg3);
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_AllRegister(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  GDALAllRegister();
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_GetCacheMax(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)GDALGetCacheMax();
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_gdal_gdalJNI_SetCacheMax(JNIEnv *jenv, jclass jcls, jint jarg1) {
  int arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  GDALSetCacheMax(arg1);
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_GetCacheUsed(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)GDALGetCacheUsed();
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_GetDataTypeSize(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jint jresult = 0 ;
  GDALDataType arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (GDALDataType)jarg1; 
  result = (int)GDALGetDataTypeSize(arg1);
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_DataTypeIsComplex(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jint jresult = 0 ;
  GDALDataType arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (GDALDataType)jarg1; 
  result = (int)GDALDataTypeIsComplex(arg1);
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_gdal_gdalJNI_GetDataTypeName(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  GDALDataType arg1 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (GDALDataType)jarg1; 
  result = (char *)GDALGetDataTypeName(arg1);
  if(result) jresult = jenv->NewStringUTF(result);
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_GetDataTypeByName(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  GDALDataType result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (GDALDataType)GDALGetDataTypeByName((char const *)arg1);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_gdal_gdalJNI_GetColorInterpretationName(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  GDALColorInterp arg1 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (GDALColorInterp)jarg1; 
  result = (char *)GDALGetColorInterpretationName(arg1);
  if(result) jresult = jenv->NewStringUTF(result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_gdal_gdalJNI_GetPaletteInterpretationName(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  GDALPaletteInterp arg1 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (GDALPaletteInterp)jarg1; 
  result = (char *)GDALGetPaletteInterpretationName(arg1);
  if(result) jresult = jenv->NewStringUTF(result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_gdal_gdalJNI_DecToDMS(JNIEnv *jenv, jclass jcls, jdouble jarg1, jstring jarg2, jint jarg3) {
  jstring jresult = 0 ;
  double arg1 ;
  char *arg2 = (char *) 0 ;
  int arg3 = (int) 2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  result = (char *)GDALDecToDMS(arg1,(char const *)arg2,arg3);
  if(result) jresult = jenv->NewStringUTF(result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
  return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_gdal_gdal_gdalJNI_PackedDMSToDec(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jdouble jresult = 0 ;
  double arg1 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  result = (double)GDALPackedDMSToDec(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_gdal_gdal_gdalJNI_DecToPackedDMS(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jdouble jresult = 0 ;
  double arg1 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  result = (double)GDALDecToPackedDMS(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_gdal_gdalJNI_ParseXMLString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  CPLXMLNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (CPLXMLNode *)CPLParseXMLString(arg1);
  *(CPLXMLNode **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_gdal_gdalJNI_SerializeXMLTree(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CPLXMLNode **)&jarg1; 
  result = (char *)CPLSerializeXMLTree(arg1);
  if(result) jresult = jenv->NewStringUTF(result);
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_gdal_gdalJNI_GetDriverCount(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)GetDriverCount();
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_gdal_gdalJNI_GetDriverByName(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  GDALDriverShadow *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (GDALDriverShadow *)GetDriverByName((char const *)arg1);
  *(GDALDriverShadow **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_gdal_gdalJNI_GetDriver(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  GDALDriverShadow *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (GDALDriverShadow *)GetDriver(arg1);
  *(GDALDriverShadow **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_gdal_gdalJNI_Open(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  GDALAccess arg2 = (GDALAccess) GA_ReadOnly ;
  GDALDatasetShadow *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (GDALAccess)jarg2; 
  result = (GDALDatasetShadow *)Open((char const *)arg1,arg2);
  *(GDALDatasetShadow **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_gdal_gdalJNI_OpenShared(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  GDALAccess arg2 = (GDALAccess) GA_ReadOnly ;
  GDALDatasetShadow *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (GDALAccess)jarg2; 
  result = (GDALDatasetShadow *)OpenShared((char const *)arg1,arg2);
  *(GDALDatasetShadow **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_gdal_gdalJNI_AutoCreateWarpedVRT(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jint jarg4, jdouble jarg5) {
  jlong jresult = 0 ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  GDALResampleAlg arg4 = (GDALResampleAlg) GRA_NearestNeighbour ;
  double arg5 = (double) 0.0 ;
  GDALDatasetShadow *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(GDALDatasetShadow **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (GDALResampleAlg)jarg4; 
  arg5 = (double)jarg5; 
  result = (GDALDatasetShadow *)AutoCreateWarpedVRT(arg1,(char const *)arg2,(char const *)arg3,arg4,arg5);
  *(GDALDatasetShadow **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3);
  return jresult;
}


JNIEXPORT jobject JNICALL Java_org_gdal_gdal_gdalJNI_GeneralCmdLineProcessor(JNIEnv *jenv, jclass jcls, jobject jarg1, jint jarg2) {
  jobject jresult = 0 ;
  char **arg1 = (char **) 0 ;
  int arg2 = (int) 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    /* %typemap(in) char **options */
    arg1 = NULL;
    if(jarg1 != 0) {
      const jclass vector = jenv->FindClass("java/util/Vector");
      const jclass enumeration = jenv->FindClass("java/util/Enumeration");
      const jmethodID elements = jenv->GetMethodID(vector, "elements",
        "()Ljava/util/Enumeration;");
      const jmethodID hasMoreElements = jenv->GetMethodID(enumeration, 
        "hasMoreElements", "()Z");
      const jmethodID getNextElement = jenv->GetMethodID(enumeration,
        "nextElement", "()Ljava/lang/Object;");
      if(vector == NULL || enumeration == NULL || elements == NULL ||
        hasMoreElements == NULL || getNextElement == NULL) {
        fprintf(stderr, "Could not load (options **) jni types.\n");
        return 0;
      }
      for (jobject keys = jenv->CallObjectMethod(jarg1, elements);
        jenv->CallBooleanMethod(keys, hasMoreElements) == JNI_TRUE;) {
        jstring value = (jstring)jenv->CallObjectMethod(keys, getNextElement);
        const char *valptr = jenv->GetStringUTFChars(value, 0);
        arg1 = CSLAddString(arg1,  valptr);
        jenv->ReleaseStringUTFChars(value, valptr);
      }
    }
  }
  arg2 = (int)jarg2; 
  result = (char **)GeneralCmdLineProcessor(arg1,arg2);
  {
    /* %typemap(out) char ** -> ( string ) */
    char **stringarray = result;
    const jclass vector = jenv->FindClass("java/util/Vector");
    const jmethodID constructor = jenv->GetMethodID(vector, "<init>", "()V");
    const jmethodID add = jenv->GetMethodID(vector, "add", "(Ljava/lang/Object;)Z");
    
    jresult = jenv->NewObject(vector, constructor);
    if ( stringarray != NULL ) {
      while(*stringarray != NULL) {
        /*printf("working on string %s\n", *stringarray);*/
        jstring value = (jstring)jenv->NewStringUTF(*stringarray);
        jenv->CallBooleanMethod(jresult, add, value);
        stringarray++;
      }
    }
  }
  {
    /* %typemap(freearg) char **options */
    CSLDestroy( arg1 );
  }
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_gdal_gdalJNI_SWIGDriverUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(GDALMajorObjectShadow **)&baseptr = *(GDALDriverShadow **)&jarg1;
    return baseptr;
}

JNIEXPORT jlong JNICALL Java_org_gdal_gdal_gdalJNI_SWIGDatasetUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(GDALMajorObjectShadow **)&baseptr = *(GDALDatasetShadow **)&jarg1;
    return baseptr;
}

JNIEXPORT jlong JNICALL Java_org_gdal_gdal_gdalJNI_SWIGBandUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(GDALMajorObjectShadow **)&baseptr = *(GDALRasterBandShadow **)&jarg1;
    return baseptr;
}

#ifdef __cplusplus
}
#endif

