import gtk
import tempfile
import subprocess

from gettext import gettext as _
from softwareproperties.gtk.DialogAptKey import DialogAddKey as apt_key
from aptsources.sourceslist import SourcesList

def dialog_error(parent, primary, secondary):
    p = "<span weight=\"bold\" size=\"larger\">%s</span>" % primary
    dialog = gtk.MessageDialog(parent, gtk.DIALOG_MODAL,
                               gtk.MESSAGE_ERROR, gtk.BUTTONS_OK, "")
    dialog.set_markup(p);
    dialog.format_secondary_text(secondary);
    dialog.run()
    dialog.hide()

    
class gapti_apt_key(apt_key):

    def info(self, filename):
        """Extracts information out of the specified key file. This is
           implemented by creating a temporary GPG key file, importing the key
           into it, and then listing from it. This is a hack."""
           
        print filename
        
        # Temporary keyring and GPG options to reference it.
        keyring = tempfile.NamedTemporaryFile()
        info_opt = self.gpg + ['--keyring', keyring.name, '--no-default-keyring']
        
        # Import specified file into temporary keyring.
        cmd = info_opt + ['--import']
        cmd.append(filename)
        p = subprocess.Popen(cmd)
        p.wait()

        # Retrieve the key we imported.
        res = []
        cmd = info_opt + self.list_opt[len(self.base_opt):]
        p = subprocess.Popen(cmd, stdout=subprocess.PIPE)
        for line in p.stdout.readlines():
            fields = line.split(":")
            if (fields[0] == "pub"):
                name = fields[9]
                res.append("%s" % _(name))
        if (p.wait() != 0):
            return None
            
        keyring.close()
            
        return res
        
class GAptISourcesList(SourcesList):

    def __init__(self):
        self.list = []
