#include "dnet.h"
#include <stdlib.h>

#if 0
static int
print_intf(const struct intf_entry *entry, void *arg)
{
   struct addr bcast;
   uint32_t mask;
   int i;

   /* We only want interfaces that are up and multicast-enabled */
   if (!   (entry->intf_flags & INTF_FLAG_UP) ||
       !   (entry->intf_flags & INTF_FLAG_MULTICAST) )
      return (0);

   printf("%s: UP and MULTICAST-ENABLED", entry->intf_name);

   printf("\n");

   if (entry->intf_addr.addr_type == ADDR_TYPE_IP) {
      addr_btom(entry->intf_addr.addr_bits, &mask, IP_ADDR_LEN);
      mask = ntohl(mask);
      addr_bcast(&entry->intf_addr, &bcast);

      if (entry->intf_dst_addr.addr_type == ADDR_TYPE_IP) {
         printf("\tinet %s --> %s netmask 0x%x broadcast %s\n",
             ip_ntoa(&entry->intf_addr.addr_ip),
             addr_ntoa(&entry->intf_dst_addr),
             mask, addr_ntoa(&bcast));
      } else {
         printf("\tinet %s netmask 0x%x broadcast %s\n",
             ip_ntoa(&entry->intf_addr.addr_ip),
             mask, addr_ntoa(&bcast));
      }
   }
   if (entry->intf_link_addr.addr_type == ADDR_TYPE_ETH)
      printf("\tlink %s\n", addr_ntoa(&entry->intf_link_addr));

   for (i = 0; i < entry->intf_alias_num; i++)
      printf("\talias %s\n", addr_ntoa(&entry->intf_alias_addrs[i]));

   return (0);
}
#endif

static int
get_first_multicast_interface_callback(const struct intf_entry *entry, void *arg)
{
   if ( *(struct intf_entry **)arg != NULL )
      return 0;

   /* Must be up, multicast-enabled and NOT loopback */
   if (! (entry->intf_flags & INTF_FLAG_UP) ||
         (entry->intf_flags & INTF_FLAG_LOOPBACK) ||
       ! (entry->intf_flags & INTF_FLAG_MULTICAST) )
      return 0;

   *(struct intf_entry**)arg = (struct intf_entry *) malloc ( sizeof(struct intf_entry) );
   if (! *(struct intf_entry**)arg )
      return 0;

   memcpy( *(struct intf_entry**)arg, entry, sizeof(struct intf_entry) );
}

struct intf_entry *
get_first_multicast_interface ( void )
{
   intf_t *intf;
   struct intf_entry* entry = NULL;

   intf = intf_open();
   intf_loop( intf, get_first_multicast_interface_callback, (void *)&entry);
   intf_close( intf );
   return entry;
}

static int
get_first_interface_callback(const struct intf_entry *entry, void *arg)
{
   if ( *(struct intf_entry **)arg != NULL )
      return 0;

   /* Must be up and NOT loopback */
   if (! (entry->intf_flags & INTF_FLAG_UP) ||
         (entry->intf_flags & INTF_FLAG_LOOPBACK) )
      return 0;

   *(struct intf_entry**)arg = (struct intf_entry *) malloc ( sizeof(struct intf_entry) );
   if (! *(struct intf_entry**)arg )
      return 0;

   memcpy( *(struct intf_entry**)arg, entry, sizeof(struct intf_entry) );
}

struct intf_entry *
get_first_interface ( void )
{
   intf_t *intf;
   struct intf_entry* entry = NULL;

   intf = intf_open();
   intf_loop( intf, get_first_interface_callback, (void *)&entry);
   intf_close( intf );
   return entry;
}

struct intf_entry *
get_interface ( char *name )
{
   intf_t *intf;
   struct intf_entry *entry;
   int rval;

   entry = (struct intf_entry *) malloc ( sizeof( struct intf_entry ) );
   if( !entry )
      return NULL;

   strncpy( entry->intf_name, name, 60); 
   intf = intf_open();
   rval = intf_get( intf, entry ); 
   intf_close(intf);
   if(rval)
      return NULL;
   else
      return entry;
}

#if 0
void
get_all_interfaces( void )
{
   intf_t *intf;
   intf = intf_open();
   intf_loop( intf, print_intf, NULL );
   intf_close( intf );
}
#endif
