class NewFITS {
    inherit  itk::Toplevel
    private common fileName ""

    private method _close {} {
	delete object $this
	
    }
    private method _go {} {
	if { [file exist $fileName ] == 1 } {
	    promptMsg "File $fileName exists\n Do you want to overwrite?" \
		[code $this _save] Yes No
	} else {
	    _save
	}
    }
    
    private method _save {} {
	$itk_interior.image setFileName $fileName
	$itk_interior.image go
	if { [file exist $fileName ] } {
	    openFitsFileWM $fileName 0
	}
	_close
    }
    
    constructor {args} {
	component hull configure -borderwidth 0

       if { [llength $args]>0 } {
	  set fileName [lindex $args 0]
          set args [lrange $args 1 end]
       }

	itk_component add fname {
	    iwidgets::entryfield $itk_interior.fname -labeltext \
		"File name:" -labelpos w -textvariable [scope fileName]
	} 
	pack $itk_component(fname) -fill x -expand 1

	NewImage $itk_interior.image $fileName
	pack $itk_interior.image -fill x -expand 1

	itk_component add bbox {
	    iwidgets::buttonbox $itk_interior.bbox 
	}  
	$itk_component(bbox) add OK -text Create -command [code $this _go]
	$itk_component(bbox) add Cancel -text Cancel -command \
	    [code $this _close]
	$itk_component(bbox) add Help -text Help -command \
	    {hhelp createNewFITS}
	pack $itk_component(bbox) -fill x -expand 1

        eval itk_initialize $args
    }

    destructor {}

}

















