blits = new Array("RGB","ADD","SUB","MEAN","ABSDIFF","MULT","MULTNOR","DIV","MULTDIV2","MULTDIV4","AND","OR","RED","GREEN","BLUE","REDMASK","GREENMASK","BLUEMASK","NEG","ADDB","ADDBH","SUBB","SHL","SHLB","SHR","MULB","BIN","ALPHA","SRCALPHA","CHROMAKEY","PAST_ADD","PAST_ADDNEG","PAST_ABSDIFF");
cur_bl=0;

fwidth=640;fheight=480;

kbd = new KeyboardController();
register_controller(kbd);
kbd.released_q = function() { quit(); }
kbd.released_a = function() { 
    cur_bl++;
    if (cur_bl>blits.length-1)
        cur_bl=0;
    g1.set_blit(blits[cur_bl]);
    echo("blit now: " + cur_bl + " " + blits[cur_bl]);
}
kbd.released_z = function() { 
    cur_bl--;
    if (cur_bl<0)
        cur_bl=blits.length - 1;
    g1.set_blit(blits[cur_bl]);
    echo("blit now: " + cur_bl + " " + blits[cur_bl]);
}
kbd.released_x = function() { 
    g=data[0];
    if (g.ld>2)
        g.ld-=2; 
}
kbd.released_s = function() { 
    g=data[0];
    g.ld+=2; 
}
kbd.released_1 = function() { 
    draw_cc(data[0]);
}
kbd.released_2 = function() { 
    draw_cc(data[1]);
}

colpick = new GeometryLayer(50,50);
add_layer(colpick);
colpick.activate();
colpick.set_position(0,0);
//colpick.set_blit("ADD");

data = new Array();

g1 = new GeometryLayer(1600,1200);
add_layer(g1);
g1.activate();
data[0] = new Object();
data[0]["layer"] = g1;
data[0]["x"] = 0;
data[0]["y"] = 0;
data[0]["w"] = 1600;
data[0]["h"] = 1200;
data[0]["col1"] = 0x00ff00ff;
data[0]["col2"] = 0x000000ff;
data[0]["ld"] = 60;
data[0]["sx"] = 1;
data[0]["sy"] = 1;
draw_cc(data[0]);

g2 = new GeometryLayer(1200,1200);
add_layer(g2);
g2.activate();
data[1] = new Object();
data[1]["layer"] = g2;
data[1]["x"] = 800;
data[1]["y"] = 600;
data[1]["w"] = 1200;
data[1]["h"] = 1200;
data[1]["col1"] = 0xff0000ff;
data[1]["col2"] = 0x000000ff;
data[1]["ld"] = 60;
data[1]["sx"] = 1;
data[1]["sy"] = 0;
draw_cc(data[1]);

g3 = new GeometryLayer(1000,1000);
add_layer(g3);
g3.activate();
data[2] = new Object();
data[2]["layer"] = g3;
data[2]["x"] = 700;
data[2]["y"] = 900;
data[2]["w"] = 1000;
data[2]["h"] = 1000;
data[2]["col1"] = 0x0000ffff;
data[2]["col2"] = 0x000000ff;
data[2]["ld"] = 60;
data[2]["sx"] = 1;
data[2]["sy"] = 0;
draw_cc(data[2]);

function draw_cc(g) {
//echo("ld " + g.ld);
    for (r=4*Math.max(g.w,g.h); r>0; r-=(2*g.ld) ) {
        g.layer.circle_fill(g.x,g.y,r     ,g.col1);
//        g.layer.aacircle(g.x,g.y,r     ,g.col1);
        g.layer.circle_fill(g.x,g.y,r-g.ld,g.col2);
//        g.layer.aacircle(g.x,g.y,r-g.ld,g.col2);
    }
}


//g1.slide_position(w,100,1);
//g2.slide_position(100,h,1);


//aacircle(<int> x, <int> y, <int> radius)
//circle_fill(<int> x, <int> y, <int> radius)

tr=new TriggerController();
register_controller(tr);
last_js = new Array();
tr.frame = function() {
    for (i=0;i<3;i++) {
        g=data[i];
        x = g.layer.get_x_position() + g.sx
        y = g.layer.get_y_position() + g.sy
        g.layer.set_position(Math.floor(x),Math.floor(y));
        bounce(g);
/*echo("pos " + i + " " 
+ g.sx + "/" + g.sy + " "
+ x + "/" + y);*/
    }
    for (which=0; which <= last_js.length; which++) {
//echo("whch " + which);
        if (last_js[which]) {
            for (axis=0; axis <= (last_js[which]).length; axis++) {
//echo("axis " + axis);
                value = last_js[which][axis];
                if ((value) && (value !=0)) {
//echo("val " + last_js[which][axis]);
                       axismotion(which, axis, value); 
               }
            }
        }
    }
}

jc = new JoystickController();
register_controller(jc);

jc.axismotion = function (which, axis, value) {
    value = value/100000; //equilaze
    //value = Math.floor(value/1000); //equilaze
    if(!last_js[which]) {
        last_js[which] = new Array();
    }
    last_js[which][axis] = value;
//    axismotion(which, axis, value);
}

function axismotion(which, axis, value) {
    //if (which==0) return;
    switch(axis) {
        case 0:
            g=data[0];
            g.sx += value;
            break;
        case 1:
            g=data[0];
            g.sy += value;
            break;
        case 3:
            g=data[1];
            g.sx += value;
            break;
        case 4:
            g=data[1];
            g.sy += value;
            break;
    }
    max_speed(data[0]);
    max_speed(data[1]);
}
max_s=20;
function max_speed (g) {
    if (g.sx > max_s) g.sx=max_s;
    if (g.sx < -max_s) g.sx=-max_s;
    if (g.sy > max_s) g.sy=max_s;
    if (g.sy < -max_s) g.sy=-max_s;
}

function bounce(g) {
    x = g.layer.get_x_position();
    y = g.layer.get_y_position();
    if (x>0) {
        g.sx = -g.sx
        x=0;
    } else if (-x>g.w-fwidth) {
        g.sx = -g.sx
        x=-(g.w-fwidth);
    }

    if (y>0) {
        g.sy = -g.sy
        y=0;
    } else if (-y>g.h-fheight) {
        g.sy = -g.sy
        y=-(g.h-fheight);
    }
    g.layer.set_position(x,y);
}


mc = new MidiController(); // ('descr')
register_controller(mc);
ret = mc.connect_from(0, 20, 0);
ret = mc.connect_from(0, 128, 1);

mc.event_ctrl = function (ch, func, value) {
    echo("midi js" + ch + ", " + func + ", " + value); 
    var g;
    switch(ch) {
        case 0:
            g=data[0];
            colnr="col1";
            break;
        case 1:
            g=data[0];
            colnr="col2";
            break;
        case 2:
            g=data[1];
            colnr="col1";
            break;
        case 3:
            g=data[1];
            colnr="col2";
            break;
    }
    // func 1=alpha, 2=r 3=g 4=b
    if (!g) return;
    col=g[colnr];
    echo("f: " + col + " " + colnr);
    switch (func) {
        case 1:
            col = (col & 0xFFFFFF00) | (value*2);
            break;
        case 2:
            col = (col & 0x00FFFFFF) | (value*2) << 24;
            break;
        case 3:
            col = (col & 0xFF00FFFF) | (value*2) << 16;
            break;
        case 4:
            col = (col & 0xFFFF00FF) | (value*2) << 8;
            break;
        }
    echo("a: " + col);
    g[colnr]=col;
        //draw_cc(g);
    colpick.rectangle_fill( 0,0,25,50,g.col1);
    colpick.rectangle_fill(25,0,50,50,g.col2);
//rectangle_fill(<int> x1, <int> y1, <int> x2, <int> y2)
}
