/// PREFS FUNCTIONS

// Returns the value of the flashblock.enabled pref
function isEnabled() {
    var prefs = Components.classes["@mozilla.org/preferences-service;1"]
                          .getService(Components.interfaces.nsIPrefBranch);

    if(prefs.getPrefType("flashblock.enabled") == prefs.PREF_BOOL)
        return prefs.getBoolPref("flashblock.enabled");
    else {
        prefs.setBoolPref("flashblock.enabled", true);
        return true;
    }
}

// Returns the value of the flashblock.blockLocal pref
function isLocalBlocked() {
    var prefs = Components.classes["@mozilla.org/preferences-service;1"]
                          .getService(Components.interfaces.nsIPrefBranch);

    if(prefs.getPrefType("flashblock.blockLocal") == prefs.PREF_BOOL)
        return prefs.getBoolPref("flashblock.blockLocal");
    else {
        return false;
    }
}

// Returns the value of the javascript.enabled pref
function isJavascriptEnabled() {
    var prefs = Components.classes["@mozilla.org/preferences-service;1"]
                          .getService(Components.interfaces.nsIPrefBranch);

    return prefs.getBoolPref("javascript.enabled");
}

// Returns the value of the browser.toolbars.showbutton.flashblockMozToggle pref
function isButtonEnabled() {
    var prefs = Components.classes["@mozilla.org/preferences-service;1"]
                          .getService(Components.interfaces.nsIPrefBranch);

    if(prefs.getPrefType("browser.toolbars.showbutton.flashblockMozToggle") == prefs.PREF_BOOL)
        return prefs.getBoolPref("browser.toolbars.showbutton.flashblockMozToggle");
    else {
        prefs.setBoolPref("browser.toolbars.showbutton.flashblockMozToggle", true);
        return true;
    }
}


// Sets the flashblock.enabled pref to the given boolean value
function setEnabled(enabled) {
    var prefs = Components.classes["@mozilla.org/preferences-service;1"]
                          .getService(Components.interfaces.nsIPrefBranch);

    return prefs.setBoolPref("flashblock.enabled", enabled);
}

// Returns the value of the flashblock.whitelist pref
function getWhitelistPref() {
    var prefs = Components.classes["@mozilla.org/preferences-service;1"]
                          .getService(Components.interfaces.nsIPrefBranch);

    if(prefs.getPrefType("flashblock.whitelist") == prefs.PREF_STRING)
	    return prefs.getCharPref("flashblock.whitelist");
	else
		return undefined;
}

// Set the flashblock.whitelist pref to the given string
function setWhitelistPref(prefStr) {
    var prefs = Components.classes["@mozilla.org/preferences-service;1"]
                          .getService(Components.interfaces.nsIPrefBranch);

    prefs.setCharPref("flashblock.whitelist", prefStr);
}
