/******************************************************************** 
   Copyright (C) 2000 Bassoukos Tassos <abas@aix.meng.auth.gr>
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later
   version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*********************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gtk/gtk.h>
#include <gnome.h>

#include "bookmarks.h"
#include "protocol.h"
#include "server.h"
#include "guiprefs.h"
#include "login.h"
#include "main.h"
#include "smalltrans.h"
#include "news.h"
#include "news15.h"
#include "userlist.h"
#include "files.h"
#include "pixmap.h"
#include "guiutils.h"
#include "users.h"
#include "hldat.h"

static void gui_show_agreement(GtkWidget *w,gpointer data){
  Connection *c=(Connection *)data;
  show_agreement(c);
}

static void gui_show_files(GtkWidget *w,gpointer data){
  Connection *c=(Connection *)data;
  show_files(c);
}

static void gui_show_userlist(GtkWidget *w,gpointer data){
  Connection *c=(Connection *)data;
  show_users(c);
}

static void gui_show_news(GtkWidget *w,gpointer data){
  Connection *c=(Connection *)data;
  if(c->version<150)
    want_news(c);
  else
    want_news_15(c);
}

static gboolean delete_gui(GtkWidget *widget,
		    GdkEvent *event,
		    gpointer user_data){
  Connection *c=(Connection *)user_data;
  server_cancel(c);
  return TRUE;
}

static void initialize_notebook(Connection *c){
  check_userlist(c);
  check_users(c);
  check_messages(c);
  if(c->version<150)
    check_news(c);
  else
    check_news_15(c);
  check_files(c);
}

static void make_bookmark(GtkWidget *w,gpointer data){
  Connection *c=(Connection *)data;
  Bookmark *b=dup_bookmark(c->bookmark);
  Bookmark *bm=bookmark_dialog(b,_("Add bookmark"),c->gui->main_window);
  if(bm==NULL){
    free(b);
  } else {
    add_bookmark(b);
  }
}

static GnomeUIInfo server_toolbar[]={
  GNOMEUIINFO_ITEM_STOCK(N_("Agreement"),N_("Show Agreement"),
			 gui_show_agreement,
			 HL_STOCK_PIXMAP_AGREEMENT),
  GNOMEUIINFO_ITEM_STOCK(N_("News"),N_("Show the news"),
			 gui_show_news,
			 HL_STOCK_PIXMAP_NEWS),
  GNOMEUIINFO_ITEM_STOCK(N_("Files"),N_("Show the files"),
			 gui_show_files,
			 HL_STOCK_PIXMAP_FILES),
  GNOMEUIINFO_ITEM_STOCK(N_("Users"),N_("Show the Userlist"),
			 gui_show_userlist,
			 HL_STOCK_PIXMAP_USERS),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_ITEM_STOCK(N_("Bookmark"),N_("Bookmark this site"),
			 make_bookmark,
			 HL_STOCK_PIXMAP_BOOKMARKS),
  GNOMEUIINFO_END
};

void gui_destroy(Connection *c){
  if(c->gui==NULL)
    return;
  if(c->gui->main_window!=NULL)
    gtk_widget_destroy(c->gui->main_window);
  free(c->gui);
  c->gui=NULL;
}

static void login_gui_create(Connection *c){
  GtkWidget *w;
  ConnectionGui *cg=(ConnectionGui *)malloc(sizeof(ConnectionGui));

  play_sound(HL_SOUND_LOGGED_IN);
  cg->toolbar_info=(GnomeUIInfo *)malloc(sizeof(server_toolbar));
  memcpy(cg->toolbar_info,server_toolbar,sizeof(server_toolbar));
  w=gnome_app_new(PACKAGE "/Server",S_NAME(c));
  cg->main_window=w;
  gnome_app_create_toolbar_with_data(GNOME_APP(w),cg->toolbar_info,
				     (gpointer)c);
  cg->hbox=gtk_hbox_new(FALSE,0);
  cg->notebook=gtk_notebook_new();
  gtk_notebook_popup_enable(GTK_NOTEBOOK(cg->notebook));
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(cg->notebook),notebook_tab_side);
  gtk_box_pack_end(GTK_BOX(cg->hbox),cg->notebook,TRUE,TRUE,0);
  gnome_app_set_contents(GNOME_APP(w),cg->hbox);
  c->gui=cg;
  guiprefs_add_window(GTK_WINDOW(w),"Server/Window/Size");
  gtk_signal_connect(GTK_OBJECT(w), "delete_event",
		     GTK_SIGNAL_FUNC(delete_gui),(gpointer)c);
  gtk_widget_set_sensitive(cg->toolbar_info[0].widget,FALSE);
  gtk_widget_show_all(w);
  initialize_notebook(c);
  gtk_signal_connect(GTK_OBJECT(cg->notebook), "switch-page",
		     guiutils_nbpage_change_hook,(gpointer)c);
  register_window(w,S_NAME(c));
}

gboolean login_done(gpointer c){
  if(((Connection *)c)->version!=0){
    return FALSE;
  }
  login_gui_create(c);
  users_update_self(c);
  return FALSE;
}

gboolean login_done_after_agreement(gpointer c){
  users_register_self(c);
  login_gui_create(c);
  show_agreement(c);
  return FALSE;
}
