/****************************************************************\
*                                                                *
*  Nucleotide Translation Code                                   *
*                                                                *
*  Guy St.C. Slater..   mailto:guy@ebi.ac.uk                     *
*  Copyright (C) 2000-2006.  All Rights Reserved.                *
*                                                                *
*  This source code is distributed under the terms of the        *
*  GNU Lesser General Public License. See the file COPYING       *
*  or http://www.fsf.org/copyleft/lesser.html for details        *
*                                                                *
*  If you use this code, please keep this notice intact.         *
*                                                                *
\****************************************************************/

#include "translate.h"

static void reverse_func(gchar *dna, gint length, gpointer user_data){
    register gint *rt_count = user_data;
    g_message("Reverse translated [%s]", dna);
    (*rt_count)++;
    return;
    }

static void check_translate(Translate *t, gchar *codon, gchar crib){
    register gchar aa = Translate_codon(t, codon);
    g_assert(aa == crib);
    g_message("Translate [%s] -> [%c] (crib:[%c]", codon, aa, crib);
    return;
    }

int main(void){
    register Translate *t = Translate_create(FALSE);
    int rt_count = 0;
    check_translate(t, "ATG", 'M');
    check_translate(t, "GGX", 'G');
    check_translate(t, "NGT", 'X');
    Translate_reverse(t, "S*MXG", 5, reverse_func, &rt_count);
    g_message("produced [%d] reverse translations", rt_count);
    g_assert(rt_count == 72);
    Translate_destroy(t);
    return 0;
    }

