/*
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: LVM Region Manager
 * File: evms2/engine/plugins/lvm/lvm_options.h
 *
 * Definitions of the options available in LVM.
 */ 

/* Container creation. */
#define	LVM_OPTION_VG_NAME_INDEX	0
#define	LVM_OPTION_VG_NAME_STR		"name"
#define	LVM_OPTION_PE_SIZE_INDEX	1
#define	LVM_OPTION_PE_SIZE_STR		"pe_size"

/* Region creation. */
#define	LVM_OPTION_LV_NAME_INDEX	0
#define	LVM_OPTION_LV_NAME_STR		"name"
#define LVM_OPTION_EXTENTS_INDEX	1
#define LVM_OPTION_EXTENTS_STR		"extents"
#define LVM_OPTION_LV_SIZE_INDEX	2
#define LVM_OPTION_LV_SIZE_STR		"size"
#define	LVM_OPTION_STRIPES_INDEX	3
#define LVM_OPTION_STRIPES_STR		"stripes"
#define	LVM_OPTION_STRIPE_SIZE_INDEX	4
#define LVM_OPTION_STRIPE_SIZE_STR	"stripe_size"
#define LVM_OPTION_PV_NAMES_INDEX	5
#define LVM_OPTION_PV_NAMES_STR		"pv_names"

/* Region expand. */
#define LVM_OPTION_EXPAND_EXTENTS_INDEX		0
#define LVM_OPTION_EXPAND_EXTENTS_STR		"add_extents"
#define LVM_OPTION_EXPAND_SIZE_INDEX		1
#define LVM_OPTION_EXPAND_SIZE_STR		"add_size"
#define LVM_OPTION_EXPAND_PV_NAMES_INDEX	2
#define LVM_OPTION_EXPAND_PV_NAMES_STR		"pv_names"

/* Region shrink. */
#define LVM_OPTION_SHRINK_EXTENTS_INDEX		0
#define LVM_OPTION_SHRINK_EXTENTS_STR		"remove_extents"
#define LVM_OPTION_SHRINK_SIZE_INDEX		1
#define LVM_OPTION_SHRINK_SIZE_STR		"remove_size"

/* A special structure for LV create options. */
typedef struct lvm_lv_create_options_s {
	lvm_physical_volume_t	* pv_entries[MAX_PV+1];
	char			lv_name[NAME_LEN];
	u_int32_t		extents;
	u_int32_t		lv_size;
	u_int32_t		stripes;
	u_int32_t		stripe_size;
} lvm_lv_create_options_t;

/* A special structure for LV expand options. */
typedef struct lvm_lv_expand_options_s {
	lvm_physical_volume_t	* pv_entries[MAX_PV+1];
	u_int32_t		add_size;
	u_int32_t		add_extents;
} lvm_lv_expand_options_t;


/* Functions exported from lvm_options.c. */

/* Container creation option handlers. */
extern int lvm_create_container_parse_option_array(option_array_t * options,
						   char * name,
						   u_int32_t * pe_size);
extern int lvm_create_container_verify_options(char * vg_name,
					       u_int32_t * pe_size);
extern int lvm_create_container_allocate_option_descriptor(option_desc_array_t * od);
extern int lvm_create_container_get_acceptable(list_anchor_t acceptable_segments);
extern int lvm_create_container_set_objects(task_context_t * context,
					    list_anchor_t declined_objects,
					    task_effect_t * effect);
extern int lvm_create_container_set_option(task_context_t * context,
					   u_int32_t index,
					   value_t * value,
					   u_int32_t * info);


/* Region creation option handlers. */
extern int lvm_parse_pv_list_option(value_list_t * list,
				    lvm_physical_volume_t * pv_entries[],
				    lvm_volume_group_t * group);
extern int lvm_create_region_parse_option_array(option_array_t * options,
						lvm_volume_group_t * group,
						lvm_lv_create_options_t * lv_opts);
extern int lvm_create_region_verify_options(lvm_lv_create_options_t * lv_opts,
					    lvm_volume_group_t * group);
extern int lvm_create_region_allocate_option_descriptor(option_desc_array_t * od);
extern void lvm_create_region_get_acceptable(list_anchor_t acceptable_regions);
extern int lvm_create_region_set_objects(task_context_t * context,
					 list_anchor_t declined_objects,
					 task_effect_t * effect);
extern int lvm_create_region_set_option(task_context_t * context,
					u_int32_t index,
					value_t * value,
					u_int32_t * info);

/* Region expansion option handlers. */
extern int lvm_expand_region_parse_option_array(option_array_t * options,
						lvm_volume_group_t * group,
						lvm_logical_volume_t * volume,
						lvm_lv_expand_options_t * lv_opts);
extern int lvm_expand_region_verify_options(lvm_lv_expand_options_t * lv_opts,
					    lvm_volume_group_t * group,
					    lvm_logical_volume_t * volume);
extern int lvm_expand_region_allocate_option_descriptor(option_desc_array_t * od);
extern int lvm_expand_region_init_options(task_context_t * context);
extern int lvm_expand_region_set_option(task_context_t * context,
					u_int32_t index,
					value_t * value,
					u_int32_t * info);

/* Region shrink option handlers. */
extern int lvm_shrink_region_parse_option_array(option_array_t * options,
						lvm_volume_group_t * group,
						lvm_logical_volume_t * volume,
						u_int32_t * remove_extents);
extern int lvm_shrink_region_verify_options(u_int32_t * extents,
					    u_int32_t * size,
					    lvm_volume_group_t * group,
					    lvm_logical_volume_t * volume);
extern int lvm_shrink_region_allocate_option_descriptor(option_desc_array_t * od);
extern int lvm_shrink_region_init_options(task_context_t * context);
extern int lvm_shrink_region_set_option(task_context_t * context,
					u_int32_t index,
					value_t * value,
					task_effect_t * effect);

/* Container expansion option handlers. */
extern void lvm_expand_container_allocate_option_descriptor(option_desc_array_t * od);
extern int lvm_expand_container_get_acceptable(storage_container_t * container,
					       list_anchor_t acceptable_segments);
extern int lvm_expand_container_set_objects(task_context_t * context,
					    list_anchor_t declined_objects,
					    task_effect_t * effect);
extern void lvm_expand_container_set_option(task_context_t * context,
					    u_int32_t index,
					    value_t * value,
					    task_effect_t * effect);

/* Container shrink option handlers. */
extern void lvm_shrink_container_allocate_option_descriptor(option_desc_array_t * od);
extern void lvm_shrink_container_get_acceptable(storage_container_t * container,
						list_anchor_t acceptable_segments);
extern int lvm_shrink_container_set_objects(task_context_t * context,
					    list_anchor_t declined_objects,
					    task_effect_t * effect);
extern void lvm_shrink_container_set_option(task_context_t * context,
					    u_int32_t index,
					    value_t * value,
					    task_effect_t * effect);

/* Region rename option handlers. */
extern int lvm_set_volume_info_init_task(task_context_t * context);
extern int lvm_set_volume_info_set_option(task_context_t * context,
					  u_int32_t index,
					  value_t * value,
					  task_effect_t * effect);
extern void lvm_set_volume_info_parse_options(lvm_logical_volume_t * volume,
					      option_array_t * options,
					      char ** lv_name);
extern int lvm_set_volume_info_validate_options(lvm_logical_volume_t * volume,
						char * lv_name);

/* Container rename option handlers. */
extern int lvm_set_group_info_init_task(task_context_t * context);
extern int lvm_set_group_info_set_option(task_context_t * context,
					 u_int32_t index,
					 value_t * value,
					 task_effect_t * effect);
extern void lvm_set_group_info_parse_options(lvm_volume_group_t * group,
					     option_array_t * options,
					     char ** vg_name);
extern int lvm_set_group_info_validate_options(lvm_volume_group_t * group,
					       char * vg_name);

