#-------------------------------------------------------------------------------
#
#  Define a simple filled box component.
#
#  Written by: David C. Morrill
#
#  Date: 01/30/2004
#
#  (c) Copyright 2004 by Enthought, Inc.
#
#  Classes defined: Box
#
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
#  Imports:
#-------------------------------------------------------------------------------

from component           import Component
from base                import transparent_color
from enable_traits       import white_color_trait, black_color_trait, \
                                border_size_trait
from enthought.traits.ui.api import Group, View, Include

#-------------------------------------------------------------------------------
#  'Box' class:
#-------------------------------------------------------------------------------

class Box ( Component ):
    
    #---------------------------------------------------------------------------
    #  Trait definitions:
    #---------------------------------------------------------------------------
    
    color        = white_color_trait
    border_color = black_color_trait
    border_size  = border_size_trait
    
    #---------------------------------------------------------------------------
    #  Trait view definition:
    #---------------------------------------------------------------------------

    traits_view = View( Group( '<component>', id = 'component' ), 
                        Group( '<links>',     id = 'links' ),
                        Group( 'color', '_', 'border_color', '_', 'border_size', 
                               id    = 'Box', 
                               style = 'custom' ) )
    
    colorchip_map = {
        'color':     'color',
        'alt_color': 'border_color'
    }

    #---------------------------------------------------------------------------
    #  Draw the box background in a specified graphics context:
    #---------------------------------------------------------------------------
    
    def _draw ( self, gc ):
        gc.save_state()
        
        # Set up all the control variables for quick access:
        bs  = self.border_size
        bsd = bs + bs
        bsh = bs / 2.0
        x, y, dx, dy = self.bounds
        
        # Fill the background region (if required);
        color = self.color_
        if color is not transparent_color:
            gc.set_fill_color( color )
            gc.begin_path()
            gc.rect( x + bs, y + bs, dx - bsd, dy - bsd ) 
            gc.fill_path()
            
        # Draw the border (if required):
        if bs > 0:
            border_color = self.border_color_
            if border_color is not transparent_color:
                gc.set_stroke_color( border_color )
                gc.set_line_width( bs )
                gc.begin_path()
                gc.rect( x + bsh, y + bsh, dx - bs, dy - bs )
                gc.stroke_path()

        gc.restore_state()

