/* $Id: e2_pane.h 553 2007-07-23 08:36:37Z tpgww $

Copyright (C) 2004-2007 tooar <tooar@gmx.net>

This file is part of emelFM2.
emelFM2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelFM2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, contact the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef E2_PANE_H
 #define E2_PANE_H

#include "emelfm2.h"
#include "e2_toolbar.h"
//#include "e2_option.h" in toolbar.h

//E2PANENATIVE for using native CWD regardless whether panes 1 & 2 are mounted or virtual
enum { E2PANECUR, E2PANE1, E2PANE2, E2PANENATIVE, E2PANECONF } ;

typedef struct _E2_PaneRuntime
{
	gchar *name;	//"pane1" or "pane2", not translated, for constructing set names
	GtkWidget *outer_box;
	GtkWidget *inner_box;
	GtkWidget *pane_sw;
//	GtkWidget *focus_widget;
#ifdef E2_FAM
	gint FAMreq;	//FAM request id used for this pane
#endif
	ViewInfo *view;
	gchar *path;	//utf-8 string, generally = view->dir, but on heap and not length-constrained
	GList *opendirs;	/*list of paths of dirs previously opened (utf-8,
						absolute for current namespace, with trailer). Used for
						"goto" buttons menu. List was cached, and then, data items
						were heaped copies of path strings. Now not cached, and
						shares data with pane->view->dir_history. Unlike the latter,
						this list may have multiple entries for the same place */
	guint opendir_cur;	//0-based index of current position in opendirs list
	E2_ToolbarRuntime toolbar;
	E2_OptionSet *opt_transparent;	//for quick checks whether to interpret relative path strings
	GHookList hook_change_dir;	//data for functions to run at end of change-dir function, for the pane
} E2_PaneRuntime;

gboolean e2_pane_goto_choice (E2_PaneRuntime *rt, GtkWidget *entry);
gboolean e2_pane_cd_checks (gchar *path);
gboolean e2_pane_activate_other_action (gpointer from, E2_ActionRuntime *art);
gboolean e2_pane_change_dir_action (gpointer from, E2_ActionRuntime *art);
#ifdef E2_VFS
void e2_pane_change_space_pointer (E2_PaneRuntime *rt, PlaceInfo *spacedata);
void e2_pane_change_space (E2_PaneRuntime *rt, gchar *space_uri);
gboolean e2_pane_vfs_menu_show (gpointer from, E2_ActionRuntime *art);
#endif
void e2_pane_activate_other (void);
void e2_pane_change_dir (E2_PaneRuntime *rt, gchar *path);
//void e2_pane_change_dir_watch (E2_PaneRuntime *rt, gchar *path, E2_CDType *completed_flag);
void e2_pane_create (E2_PaneRuntime *rt);
void e2_pane_create_part (E2_PaneRuntime *rt);
void e2_pane_create_option_data (E2_PaneRuntime *rt);
//void e2_pane_destroy (E2_PaneRuntime *rt);
//void e2_pane_recreate (E2_PaneRuntime *rt);
// initialisation things
void e2_pane_flag_active (void);
//void e2_pane_flag_inactive (void);
void e2_pane_actions_register (void);
void e2_pane_options_register (gint num);

#endif //ndef E2_PANE_H
