/* $Id: e2_size_filter_dialog.c 539 2007-07-18 11:52:43Z tpgww $

Copyright (C) 2003-2007 tooar <tooar@gmx.net>

This file is part of emelFM2.
emelFM2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelFM2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, contact the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "emelfm2.h"
#include <math.h>
#include "e2_dialog.h"
#include "e2_filelist.h"

typedef struct _E2_SzFltDlgData
{
	GtkWidget *dialog;	//the created dialog
	GtkWidget *operation_combo;
	GtkWidget *size_entry;
	GtkWidget *units_combo;
//	GtkWidget *menu_item;	//copy of pointer to clicked filters menu item
//	gboolean itemstate;	//initial state of menu_item
//	gboolean blocked = FALSE;	//flag to prevent toggles when not wanted
	ViewInfo *view;	//data for filelist being processed
} E2_SzFltDlgData;

/*static void _e2_size_filter_dialog_item_toggle_cb (void)
{
  gulong handler = g_signal_handler_find (menu_item, G_SIGNAL_MATCH_FUNC,
	0, 0, NULL, e2_size_filter_dialog_create_cb, NULL);
  g_signal_handler_block (menu_item, handler);
  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (menu_item), !itemstate);
  g_signal_handler_unblock (menu_item, handler);
}
*/
static void _e2_size_filter_dialog_ok (E2_SzFltDlgData *rt)
{
	gint index = gtk_combo_box_get_active (GTK_COMBO_BOX (rt->operation_combo));
	rt->view->size_filter.op = index;

	const gchar *s = gtk_entry_get_text (GTK_ENTRY (rt->size_entry));
	gdouble dsize = atof (s);
	index = gtk_combo_box_get_active (GTK_COMBO_BOX (rt->units_combo));
	if (index == 1 || index == 2)	//kb or Mb respectively
	  dsize *= pow (1024, index);
	rt->view->size_filter.size = (size_t)dsize;
	rt->view->size_filter.active = TRUE;
	//show the results
	e2_toolbar_toggle_filter_button (rt->view);
	e2_fileview_refilter_list (rt->view);
}
/**
@brief dialog response callback

@param dialog the permissions-dialog
@param response the response for the clicked button
@param rt pointer to dialog data struct

@return
*/
static void _e2_size_filter_dialog_response_cb (GtkDialog *dialog,
	gint response, E2_SzFltDlgData *rt)
{
	switch (response)
	{
		case GTK_RESPONSE_OK:
			gtk_widget_hide (rt->dialog);
			_e2_size_filter_dialog_ok (rt);
		  	//prevent toggle when dialog is destroyed
//			blocked = TRUE;
		  break;
		case E2_RESPONSE_REMOVE:
		  //update the cached copy of the state
		  rt->view->size_filter.active = FALSE;
		  gtk_widget_hide (rt->dialog);
		  //show the results
		  e2_toolbar_toggle_filter_button (rt->view);
		  e2_fileview_refilter_list (rt->view);
		  //prevent toggle when dialog is destroyed
//		  blocked = TRUE;
		  break;
//		case GTK_RESPONSE_CANCEL:
		default:
		  //the menu item will be re-toggled when dialog is destroyed
		break;
	}
	gtk_widget_destroy (rt->dialog);
	DEALLOCATE (E2_SzFltDlgData, rt);
//	gtk_main_quit ();
}
/**
@brief handle Return keypresses in the size entry
@param entry UNUSED the entry widget for the combo box
@param rt pointer to dialog data struct
@return
*/
static void _e2_size_filter_dialog_activated_cb (GtkEntry *entry,
	E2_SzFltDlgData *rt)
{
	_e2_size_filter_dialog_response_cb (GTK_DIALOG (rt->dialog),
		GTK_RESPONSE_OK, rt);
}
/**
@brief create file size filter dialog

The state of @a item when it arrives here is opposite to that
shown in the menu, when clicked

@param item the clicked checkbox widget in the fillters menu
@param view data structure for the view to which the file list belongs

@return
*/
void e2_size_filter_dialog_create_cb (GtkWidget *item, ViewInfo *view)
{
	GtkWidget *hbox;
	gchar size_string[32];

	//save local copies, for later use in other functions
//  menu_item = item;
//  itemstate = gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM (item));
	E2_SzFltDlgData *rt = ALLOCATE (E2_SzFltDlgData);
	CHECKALLOCATEDWARN (rt, return;);
	rt->view = view;

	rt->dialog = e2_dialog_create (NULL, _("Display only the items which are:"),
		_("size filter"), _e2_size_filter_dialog_response_cb, rt);
	hbox = add_hbox (GTK_DIALOG (rt->dialog)->vbox, FALSE, E2_PADDING, TRUE, E2_PADDING);

	rt->operation_combo = e2_combobox_add (hbox, FALSE, 0, NULL, NULL, NULL,
		E2_COMBOBOX_MENU_STYLE);
	//the order of these matches the Operator enum in e2_fileview.h
	gchar *size_choices[3] = { _("smaller than"), _("equal to"), _("bigger than") };
	e2_combobox_append_history_counted (rt->operation_combo, 3, size_choices);

	gint index = view->size_filter.op;
	gtk_combo_box_set_active (GTK_COMBO_BOX (rt->operation_combo), index) ;	//0=1st entry index
//	gtk_widget_set_size_request (operation_combo, 150, 30);

	if (view->size_filter.size < (1 << 10))
	{
		g_snprintf (size_string, sizeof (size_string), "%ld",
			(gulong) view->size_filter.size);
		index = 0; 	//0=1st combo entry index
	}
	else if (view->size_filter.size < (1 << 20))
	{
		g_snprintf (size_string, sizeof (size_string), "%.2f",
			(gdouble)((gdouble)view->size_filter.size / (gdouble)(1 << 10)));
		index = 1;
	}
	else
	{
		g_snprintf (size_string, sizeof (size_string), "%.2f",
			(gdouble)((gdouble)view->size_filter.size / (gdouble)(1 << 20)));
		index = 2;
	}

//	rt->size_entry = add_entry (hbox, "", FALSE, 0); this pair add the text without selection
//	gtk_entry_set_text (GTK_ENTRY (rt->size_entry), size_string);
	rt->size_entry = add_entry (hbox, size_string, FALSE, 0);
	gtk_widget_set_size_request (rt->size_entry, 100, 30);
	//handle <Return> key-presses when the entry is focused
	g_signal_connect (G_OBJECT (rt->size_entry), "activate",
		G_CALLBACK (_e2_size_filter_dialog_activated_cb), rt);

	rt->units_combo = e2_combobox_add (hbox, FALSE, 0, NULL, NULL, NULL,
		E2_COMBOBOX_MENU_STYLE);
	gchar *units_names [3] = { _("bytes"), _("kbytes"), _("Mbytes") };
	e2_combobox_append_history_counted (rt->units_combo, 3, units_names);
	gtk_combo_box_set_active (GTK_COMBO_BOX (rt->units_combo), index) ;

	//now the buttons
//  if (!itemstate)
	if (!gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM (item)))
		//user has just toggled off
		e2_dialog_add_defined_button (rt->dialog, &E2_BUTTON_REMOVE);
	e2_dialog_show (rt->dialog, app.main_window, 0,
		&E2_BUTTON_CANCEL, &E2_BUTTON_OK, NULL);
//  gtk_main ();
}
