/* $Id: e2_command_line.h 469 2007-07-06 22:58:30Z tpgww $

Copyright (C) 2004-2007 tooar <tooar@gmx.net>

This file is part of emelFM2.
emelFM2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelFM2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, contact the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

/**
@file src/command/e2_command_line.h
@brief command line header

This is the header file for the command line functions.
*/

#ifndef E2_COMMAND_LINE_H
#define E2_COMMAND_LINE_H

#include "emelfm2.h"
#include "e2_pane.h"

typedef enum
{
	E2_COMMAND_LINE_ORIGINAL = 1<<0,
	E2_COMMAND_LINE_DIR_LINE = 1<<1
} E2_CommandLineFlags;

typedef struct _E2_CommandLineRuntime
{
	gchar *name;  //this is a generated 'internal' name, not a 'public' one
	gpointer func;
	E2_CommandLineFlags flags;
	gboolean original;  //TRUE for command entry(ies), FALSE for dir lines
	E2_PaneRuntime *pane; //was	gpointer data, only used for dir lines;

	GtkWidget *cl;
	GList *history;
	GtkTreeModel *model;
	E2_OptionSet *opt_history_last;
} E2_CommandLineRuntime;

void e2_command_line_cd_activated_cb (GtkWidget *entry, E2_CommandLineRuntime *rt);
E2_CommandLineRuntime *e2_command_line_create (gchar *name_default,
	gpointer cl_data, gpointer activation_cb, E2_CommandLineFlags flags);
void e2_command_line_destroy (E2_CommandLineRuntime *rt);
void e2_command_line_clean (void);
void e2_command_line_actions_register (void);
void e2_command_line_options_register (void);

#endif // ndef E2_COMMAND_LINE_H
