/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2002 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

   ----------------------------------------------------------------------

   multi-node tree
   
*/
/****************************************************************************
 *    IMPLEMENTATION HEADERS
 ****************************************************************************/

#include <stdio.h>

#include "multree.h"
#include "xmalloc.h"

/****************************************************************************
 *    IMPLEMENTATION PRIVATE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION REQUIRED EXTERNAL REFERENCES (AVOID)
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE DATA
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DATA
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE FUNCTION PROTOTYPES
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE FUNCTIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTIONS
 ****************************************************************************/

multree_t *
multree_create (unsigned short children_count)
{
  multree_t *result;

  result                  = xmalloc (sizeof (multree_t));
  result->children_count  = children_count;
  result->children_filled = 0;
  result->children        = xcalloc (children_count, sizeof (multree_t *));

  return result;
}




void
multree_node_destroy (multree_t *node)
{
  if (node->children)
    xfree (node->children);
  xfree (node);
}



void
multree_preorder (multree_t *tree, void (*fun)(multree_t *))
{
  int i;

  fun (tree);
  for (i = 0; i < tree->children_filled; i++)
    multree_preorder (tree->children[i], fun);
}




void
multree_postorder (multree_t *tree, void (*fun)(multree_t *))
{
  int i;

  for (i = 0; i < tree->children_filled; i++)
    multree_postorder (tree->children[i], fun);
  fun (tree);
}




multree_t *
multree_add_child (multree_t *parent, multree_t *child)
{
  if (parent->children_count == parent->children_filled)
    return NULL;

  parent->children[parent->children_filled] = child;
  parent->children_filled++;

  return child;
}



multree_t *
multree_add_new_child (multree_t *node, unsigned short children_count)
{
  multree_t *new;

  new = multree_create (children_count);
  return multree_add_child (node, new);
}

/****************************************************************************
 *    INTERFACE CLASS BODIES
 ****************************************************************************/
/****************************************************************************
 *
 *    END MODULE multree.c
 *
 ****************************************************************************/
