#ifndef __HASH_H__
#define __HASH_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2002 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/*****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include "memblock.h"

/*****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/

typedef struct hentry {
  struct hentry *next;
  char          *key;
  void          *content;
} entry_t;

typedef struct entry_aux {
  struct entry_aux *next;
  entry_t          *entry;
} entry_aux_t;

typedef struct {
  entry_t     **array;
  entry_aux_t  *list;
  memblock_t   *memblock;
  unsigned      exponent;
  unsigned      count;
} htable_t;

/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

extern htable_t *htable_create (unsigned size);
extern void      htable_destroy (htable_t *table, void (*)(void*));
extern entry_t  *htable_lookup (htable_t *table, const char *key);
extern entry_t  *htable_insert (htable_t *table, const char *key,
                                void *content);
extern entry_t  *htable_remove (htable_t *table, const char *key);
extern void      htable_clear (htable_t *table, void (*)(void *));
extern void      htable_iterator (htable_t *table, void (*)(entry_t *));

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER hash.h
 *
 ****************************************************************************/
#endif
