#ifndef __FOLDER_H__
#define __FOLDER_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2002, 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/*****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include "mail.h"

/*****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES (FOR OTHER MODULES)
 ****************************************************************************/

extern mail_t *folder_mail_selected (void);
extern void    folder_init (void);
extern void    folder_free_resources (void);
extern int     folder_read_box (char *name);

/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES (USER INTERFACE)
 ****************************************************************************/

/**
 * bar movement
 */
/** move on to the next page */
extern void folder_page_next (void);
/** move to the previous page */
extern void folder_page_prev (void);
/** move bar to the next position */
extern void folder_bar_next (void);
/** move bar to the previous position */
extern void folder_bar_prev (void);
/** move bar to the first position */
extern void folder_bar_first (void);
/** move bar to the last position */
extern void folder_bar_last (void);
/** scroll window down */
extern void folder_scroll_down (void);
/** scroll window up */
extern void folder_scroll_up (void);
/** place bar in a center of the screen */
extern void folder_recenter (void);
/** move bar to next unread message */
extern void folder_next_unread (void);
/** move bar to previous unread message */
extern void folder_prev_unread (void);
extern void folder_redraw (void);
extern void folder_refresh (void);

/** re-read mailbox */
extern void folder_update (void);
/** remove spam and refresh the view */
extern void folder_flush (void);

/**
 * searching
 */
/** search forward */
extern void folder_search_forward (void);
/** search backward */
extern void folder_search_backward (void);

/**
 * sorting
 */
/** group mails in threads */
extern void folder_sort_threads (void);
/** sort messages by date */
extern void folder_sort_date (void);
/** sort messages by from */
extern void folder_sort_from (void);
/** sort messages by subject */
extern void folder_sort_subject (void);

/**
 * flagging
 */
/** toggle flag */
extern void folder_toggle_flag (void);
/** flag all messages */
extern void folder_flag_all (void);
/** unflag all messages */
extern void folder_unflag_all (void);
/** invert flag */
extern void folder_flag_invert (void);
/*+
  Set flag on all the messages, that are duplicates of other
  messages in the box.  It is useful to remove them.
  +*/
/** flag messages that are duplicates */
extern void folder_flag_duplicates (void);
/** removes message flag */
extern void folder_remove_flag (void);


extern void folder_set_focus (void);
extern void folder_unset_focus (void);

/**
 * spam
 */
/** check if selected messages are spam */
extern void folder_spam_check (void);
/** check all messages that were not checked if they are spam */
extern void folder_spam_check_all (void);
/** delete message as a spam */
extern void folder_spam_delete (void);
/** scan messages according to their spam indicator and delete spam */
extern void folder_spam_flush (void);
/** unmark message incorrectly recognized as spam */
extern void folder_spam_is_not (void);

extern void folder_after_read (void);
extern void folder_after_reply (void);
extern void folder_after_fwd (void);
/*+
  If you have a trash field defined in your .elmorc file, than move
  selected messages to trash folder.  Otherwise delete them.
  +*/
/** delete a message (or move to trash) */
extern void folder_delete_mail (void);

/*+
  Remove selected messages from the box.  It is then impossible
  to recover them.
  +*/
/** permanently delete message */
extern void folder_kill_mail (void);

/** move selected message to another box */
extern void folder_move_mail (void);
/** mark selected messages as read */
extern void folder_make_read (void);

/** this function is executed each time a box is being left */
extern void folder_at_leave (void);
/** this function is executed each time a bar in folder moves */
extern void folder_at_bar_move (void);

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER folder.h
 *
 ****************************************************************************/
#endif
