#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Author : Steven Harper
# License : GNU GENERAL PUBLIC LICENSE V2
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
import ConfigParser

class EasyCryptConfig:

	# Declare global variables for configuration as dictionary
	options = { "crypt":"~/.easycrypt-crypt", 
				"crypt-gen-random":"/tmp/.easycrypt-random", 
				"mode":"normal", 
				"autostart_on_login":"no",
				"use_stock_icons":"no",
				"use_filename_as_mountname":"yes",
				"show_keyfile_options":"no", 
				"modifiable_mount_path":"no",
				"history-1" : "",
				"history-2" : "",
				"history-3" : "",
				"history-4" : "",
				"history-5" : "",
				}
	



	def __init__(self, path):
		self.debug = False
		if (self.debug):print("Config Started")
		self.configPath = path
		self.config = ConfigParser.RawConfigParser(self.options)
		self.readConfig()
		self.writeConfig()

	def writeConfig( self ):
		fd = open( self.configPath, 'w+' )
		# write config in alphabetical order
		values = self.config.defaults()
		fd.write("[DEFAULT]\n")
		for k in sorted(values.keys()):
			fd.write(str(k) + " = " + str(values[k]) + "\n") 
		if self.debug:print("done writing")
		fd.close()

	def getOptions( self ) :
		return self.options

	def getOption( self, optionKey ) :
		if self.config.has_option( 'DEFAULT', optionKey ):
			return self.config.get('DEFAULT', optionKey)
		else:
			return ""

	def setOption( self, optionKey, optionValue ) :
		if self.config.has_option( 'DEFAULT', optionKey ):
			self.config.set('DEFAULT',optionKey,optionValue)
		
	def readConfig( self ):
		if self.debug:print("reading config")	
		self.config.read(self.configPath)
		for key in self.options.keys():
			if self.debug:print("checking key : " + key)
			if self.config.has_option( 'DEFAULT', key ):
				if self.debug:print("got a value!")
			else:
				self.config.set('DEFAULT',key,self.options[key])
				if self.debug:print("Defaulting")

		if self.debug:print("done reading")
		

if __name__ == "__main__":
	print "config main called"
