#include <sys/vfs.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include <qdatetime.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qprogressbar.h>
#include <qspinbox.h>
#include <iostream>
#include "QDvrGUIImpl.h"
#include "dvr.h"

void *QDvrGUIImpl::video_monitoring(void *o) {
	QDvrGUIImpl *me=(QDvrGUIImpl *)o;

	int segment_number=0;
	double video_frame_rate, capture_frame_rate;
  int nb_max_frames;
	double delta, max_duration, virtual_duration;
	struct timeval now, before, start_recording_time;
	struct stat s;
	struct statfs sfs;
	QTime t;
	
	statfs(me->qle_filename->text(), &sfs);
	double total_space=double(sfs.f_bsize)*double(sfs.f_blocks), available_space, actual_file_size, segments_total_size=0;

	QString filename=me->qle_filename->text();	

	start_recording_time=me->my_dvr->startRecordingTime();
	video_frame_rate=me->my_dvr->parameterAsDouble("video_frame_rate");
	capture_frame_rate=me->my_dvr->parameterAsDouble("capture_frame_rate");

  nb_max_frames=me->my_dvr->parameterAsInt("max_recording_time")*int(video_frame_rate);

	gettimeofday(&before, NULL);
	
	do {
		sleep(1);

		gettimeofday(&now, NULL);		
				
		delta=now.tv_sec-start_recording_time.tv_sec+(now.tv_usec-start_recording_time.tv_usec)/1000000.0;
		t=QTime();
    virtual_duration=me->my_dvr->nbFramesElapsed()/video_frame_rate;
		me->qlb_duration->setText(t.addSecs(int(virtual_duration)).toString());
		me->qlb_total_elapsed_frames->setText(QString::number(me->my_dvr->nbFramesElapsed()));
	
		me->qlb_frames_lost_cap->setText(QString::number(me->my_dvr->nbFramesLostInCapture()));
		me->qlb_frames_lost_enc->setText(QString::number(me->my_dvr->nbFramesLostInEncoding()));
		me->qlb_frames_enc_queue->setText(QString::number(me->my_dvr->nbFramesInEncQueue()));
		me->qlb_frames_stored->setText(QString::number(me->my_dvr->nbFramesStored()));
		
		me->qpb_cpu_load->setProgress(me->cpuLoad());
		
		
		stat(filename, &s);

		if(me->qsb_segmented_file->value()>0) {
			actual_file_size=segments_total_size+s.st_size;
			if(s.st_size>me->qsb_segmented_file->value()*1048576L) {
				segments_total_size+=s.st_size;
				// be carefull !!!
				// this way to calculate the names of the segments can fail if there is no ".avi" extension, or no extension at all
				QString s; s.sprintf("%03d", segment_number);
				filename=filename.left(filename.find('.'))+"."+s+".avi";
				segment_number++;
			}
		} else {
			actual_file_size=double(s.st_size);
		}
		me->qlb_actual_file_size->setText(QString::number(actual_file_size/1048576.0, 'f', 1)+" MB");
		me->qlb_average_data_rate->setText(QString::number((actual_file_size/delta)/1024.0, 'f', 1)+" KB/s");

		statfs(me->qle_filename->text(), &sfs);
		available_space=double(sfs.f_bsize)*double(sfs.f_bavail);	
		me->qlb_free_space->setText(QString::number(int(available_space/1048576.0))+" MB");
		me->qpb_free_space->setProgress(int(available_space/total_space*100.0));

		max_duration=delta*total_space/actual_file_size;
		if(nb_max_frames!=0) {
			double d=double(nb_max_frames)/video_frame_rate;
			if(d<max_duration) max_duration=d;
		}
		t=QTime();
		if(max_duration<86400) {
			me->qlb_max_estimated_duration->setText(t.addSecs(int(max_duration)).toString());
		} else {
			me->qlb_max_estimated_duration->setText(QString::number(int(max_duration)/86400)+trUtf8(" day(s), ")+t.addSecs(int(max_duration)).toString());
			// waouh... recording several days of video ??? yes ! it's now possible !!!
		}

		if(nb_max_frames==0) {
			me->qlb_estimated_file_size->setText(QString::number((available_space+actual_file_size)/1048576.0, 'f', 1)+" MB, or less...");
		} else {
			me->qlb_estimated_file_size->setText(QString::number(max_duration*actual_file_size/(virtual_duration*1048576.0), 'f', 1)+" MB");
		}

		//me->qpb_duration->setProgress(int(delta*100/max_duration)>100?100:int(delta*100/max_duration));
		me->qpb_duration->setProgress(int(100*virtual_duration/max_duration));
				
	} while(me->my_dvr->getStatus()==DVR::DVR_RECORDING);


	return NULL;
}
