/*********************************************************************************************************
DVR, Digital Video Recorder - a tool to record movies (audio/video), using realtime compression

It uses libavifile (see http://divx.euro.ru) and some code from kwintv (see wenk@mathematik.uni-kl.de)

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General
Public License as published by the Free Software Foundation, etc.
This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY, etc.

copyright(C) february 2001, Pierre Hbert (pierre.hebert@netcourrier.com)
*********************************************************************************************************/

// codec configuration dialog box implementation header

#ifndef QCODECCONFIGIMPL_H
#define QCODECCONFIGIMPL_H
#include <string>

#include <avifile/infotypes.h>
#include "QCodecConfig.h"

using namespace std;

class QCodecConfigImpl : public QCodecConfig
{ 
    Q_OBJECT

public:
    QCodecConfigImpl( QWidget* parent = 0, const char* name = 0);
    QCodecConfigImpl( int fourcc, QWidget* parent = 0, const char* name = 0);
    ~QCodecConfigImpl();

	void setVideoCodecName(const string &);
	string videoCodecName() const { return video_codec_name; }

public slots:
    virtual void changeAttribute(QListViewItem *);
    virtual void changeCodec();
    virtual void setAttribute();
	virtual void changeParameter();

signals:
	void parameterChanged();

protected:
	string	video_codec_name;
	int compressor;
	AttributeInfo::Kind current_attribute_kind;
};

#endif // QCODECCONFIGIMPL_H
