/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/


void PortDlg::init()
{
    Client *c=frame->client();
    cfg.setName(config->name());
    cfg.setSave(false);
    
    QValueList<Portinfo>::Iterator it1;
    QValueList<Port *>::Iterator it2;
    
    for(it2=c->ports.begin();it2 != c->ports.end();++it2)
	if((*it2)->type() == Port::Output)
	    OutputFrom->insertItem((*it2)->name());
    
    for(it1=c->out_ports.begin();it1 != c->out_ports.end();++it1)
	OutputFrom->insertItem((*it1).name);
}


void PortDlg::OutputFrom_selectionChanged( QListBoxItem * li)
{
    QString text;
    if(li)
	text=li->text();
    outputStoreSetup();
    OutputTo->clear();
    outputSelected=text;
    if(text == QString::null)
	return;
    insertEligible(OutputTo, text);
    QString val=cfg.getValue(text, "");
    QStringList sl=QStringList::split("=", val, false);
    QStringList::Iterator it;
    for(it=sl.begin();it!=sl.end();++it)
    {
	QListBoxItem *i=OutputTo->findItem((*it));
	if(i)
	    OutputTo->setSelected(i, true);
    }
}


bool PortDlg::isMine( QString port )
{
    Client *c=frame->client();
    
    QValueList<Port *>::Iterator it2;
    
    for(it2=c->ports.begin();it2 != c->ports.end();++it2)
	if((*it2)->name() == port)
	    return true;
    return false;
}



void PortDlg::insertEligible( QListBox *lb, QString port )
{
    Client *c=frame->client();
    QValueList<Portinfo>::Iterator it1;
    QValueList<Port *>::Iterator it2;
    
    for(it2=c->ports.begin();it2 != c->ports.end();++it2)
	if((*it2)->type() == Port::Input)
	    OutputTo->insertItem((*it2)->name());
    if(isMine(port))
    {
	for(it1=c->in_ports.begin();it1 != c->in_ports.end();++it1)
	    OutputTo->insertItem((*it1).name);
    }
}


void PortDlg::outputStoreSetup()
{
    if(outputSelected == QString::null)
	return;
    QStringList sl;
    int i;
    for(i=0;i<OutputTo->count();++i)
    {
	QListBoxItem *it=OutputTo->item(i);
	if(OutputTo->isSelected(it))
	    sl.append(it->text());
    }
    QString val=sl.join("=");
    if(val == QString::null)
	val="";
    cfg.setValue(outputSelected, val);
}
